/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Definition;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaException;

public class WSDLSchemas {
    private Definition definition;
    private Map preparedSchemas = new HashMap(19);
    private PreparedSchemaKey lookupKey = new PreparedSchemaKey();

    public WSDLSchemas(Definition definition) {
        this.definition = definition;
    }

    public synchronized void clean(String serializationID) {
        Set keys = this.preparedSchemas.keySet();
        Vector<PreparedSchemaKey> remove = new Vector<PreparedSchemaKey>();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            PreparedSchemaKey pk = (PreparedSchemaKey)i.next();
            if (!pk.serializationId.equals(serializationID)) continue;
            remove.add(pk);
        }
        Iterator i2 = remove.iterator();
        while (i2.hasNext()) {
            this.preparedSchemas.remove(i2.next());
        }
    }

    public synchronized void prepareSchema(String serializationId, String encodingURI, Map namespaceURIToLocationMap) throws SchemaException {
        this.lookupKey.serializationId = serializationId;
        this.lookupKey.encodingURI = encodingURI;
        if (this.preparedSchemas.containsKey(this.lookupKey)) {
            return;
        }
        Schema schema = XMLSchemaUtil.parseTypes(this.definition, namespaceURIToLocationMap, true);
        this.preparedSchemas.put(this.lookupKey, schema);
        this.lookupKey = new PreparedSchemaKey();
    }

    public synchronized void setSchema(String serializationId, String encodingURI, Schema schema) {
        this.preparedSchemas.put(new PreparedSchemaKey(serializationId, encodingURI), schema);
    }

    public synchronized Schema getSchema(String serializationId, String encodingURI) {
        this.lookupKey.serializationId = serializationId;
        this.lookupKey.encodingURI = encodingURI;
        return (Schema)this.preparedSchemas.get(this.lookupKey);
    }

    public synchronized void removeUnusedSchmeas(String serializationId) {
        Iterator i = this.preparedSchemas.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry schema = i.next();
            PreparedSchemaKey key = (PreparedSchemaKey)schema.getKey();
            if (!key.serializationId.equals(serializationId)) continue;
            i.remove();
        }
    }

    public static class PreparedSchemaKey {
        String serializationId;
        String encodingURI;

        PreparedSchemaKey() {
        }

        PreparedSchemaKey(String serializationId, String encodingURI) {
            this.serializationId = serializationId;
            this.encodingURI = encodingURI;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PreparedSchemaKey)) {
                return false;
            }
            PreparedSchemaKey preparedSchemaKey = (PreparedSchemaKey)o;
            boolean bl = this.encodingURI != null ? !this.encodingURI.equals(preparedSchemaKey.encodingURI) : preparedSchemaKey.encodingURI != null;
            if (bl) {
                return false;
            }
            return !(this.serializationId != null ? !this.serializationId.equals(preparedSchemaKey.serializationId) : preparedSchemaKey.serializationId != null);
        }

        public int hashCode() {
            int result = this.serializationId != null ? this.serializationId.hashCode() : 0;
            result = 29 * result + (this.encodingURI != null ? this.encodingURI.hashCode() : 0);
            return result;
        }
    }
}

