/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import com.idoox.debug.Category;
import com.idoox.util.SignatureHelper;
import com.idoox.util.xml.DOMWriter;
import com.idoox.wasp.Constants;
import com.idoox.wasp.WSDLSchemas;
import com.idoox.wasp.WSDLServiceInfo;
import com.idoox.wsdl.util.WSDLUtil;
import com.idoox.wsdl.util.XmlUtil;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.dime.DIMEMessage;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.http.HTTPUrlEncoded;
import javax.wsdl.extensions.http.HTTPUrlReplacement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.idoox.util.Base64;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.serialization.SerializationRepository;
import org.idoox.wasp.serialization.TypeMappingContext;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.idoox.wasp.wsdl.SOAPPortInfo;
import org.idoox.wasp.wsdl.SOAPServiceInfo;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.systinet.wsdl.extensions.java.JavaOperation;

public class WSDLPortInfo
implements SOAPPortInfo {
    private static final Category cat = Category.getCategory("com.idoox.wasp.WSDLPortInfo");
    private static SerializationRepository serializationRepo = (SerializationRepository)Context.getInstance("org.idoox.wasp.serialization.SerializationRepository");
    private Map serializationIdToJavaMethodToMethodInfo = new HashMap(11, 0.75f);
    private Map serializationIdToOperationToMethodInfo = new HashMap(11, 0.75f);
    private Map serializationIdToSoapActionToMethodInfo = new HashMap(11, 0.75f);
    private Map serializationIdToAllMethodInfos = new HashMap(11, 0.75f);
    private String endpointURI;
    private String documentation;
    private WSDLServiceInfo soapServiceInfo;
    private Definition definition;
    private Service service;
    private Port port;
    private Binding binding;
    private PortType portType;
    private Schema correctSchema;
    private WSDLSchemas wsdlSchemas;
    private QName bindingExtensibilityElementQName;
    private boolean isHTTPGET;
    private static final SOAPMethodInfo.PartInfo[] EMPTY_PARTINFOS = new SOAPMethodInfo.PartInfo[0];
    private static final boolean DEFAULT_SHOULD_UNWRAP = false;
    private static final QName BASE64_BINARY_TYPE = new QName("http://www.w3.org/2001/XMLSchema", "base64Binary");
    private static final QName HEX_BINARY_TYPE = new QName("http://www.w3.org/2001/XMLSchema", "hexBinary");
    static /* synthetic */ Class class$javax$wsdl$extensions$soap$SOAPOperation;
    static /* synthetic */ Class class$javax$wsdl$extensions$soap$SOAPBinding;
    static /* synthetic */ Class class$javax$wsdl$extensions$http$HTTPOperation;
    static /* synthetic */ Class class$org$systinet$wsdl$extensions$java$JavaOperation;
    static /* synthetic */ Class class$javax$wsdl$extensions$soap$SOAPBody;

    public WSDLPortInfo(WSDLServiceInfo soapServiceInfo, Definition definition, Service service, Port port, Binding binding, PortType portType, WSDLSchemas wsdlSchemas) throws SchemaException {
        this.soapServiceInfo = soapServiceInfo;
        this.definition = definition;
        this.service = service;
        this.port = port;
        this.binding = binding;
        this.portType = portType;
        this.wsdlSchemas = wsdlSchemas;
        if (port != null) {
            this.endpointURI = WSDLUtil.getAddressLocationURI(port);
            this.documentation = DOMWriter.serializeContent(port.getDocumentationElement(), true);
        } else {
            this.endpointURI = null;
            this.documentation = null;
        }
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getPortName() {
        if (this.port != null) {
            return this.port.getName();
        }
        return null;
    }

    public QName getPortTypeQName() {
        return this.portType.getQName();
    }

    public synchronized SOAPMethodInfo getMethodInfo(String serializationId, String methodName, Method method) throws SchemaException, WSDLException {
        SOAPMethodInfo ret;
        HashMap<Method, SOAPMethodInfo> javaMethodToMethodInfo = (HashMap<Method, SOAPMethodInfo>)this.serializationIdToJavaMethodToMethodInfo.get(serializationId);
        if (javaMethodToMethodInfo == null) {
            javaMethodToMethodInfo = new HashMap<Method, SOAPMethodInfo>(19);
            this.serializationIdToJavaMethodToMethodInfo.put(serializationId, javaMethodToMethodInfo);
        }
        if ((ret = (SOAPMethodInfo)javaMethodToMethodInfo.get(method)) != null) {
            return ret;
        }
        ret = this.parseMethod(serializationId, methodName, method.getParameterTypes(), method.getReturnType(), false);
        if (ret != null) {
            javaMethodToMethodInfo.put(method, ret);
            this.getOperationToMethodInfo(serializationId).put(ret.requestName, ret);
        } else {
            cat.warn("Don't have a WSDL method for java method " + method);
        }
        return ret;
    }

    public SOAPMethodInfo getMethodInfo(String serializationId, String methodName, Object cacheId, Class[] params, Class returnType) throws SchemaException, WSDLException {
        return this.getMethodInfo(serializationId, methodName, cacheId, params, returnType, false);
    }

    public SOAPMethodInfo getMethodInfo(String serializationId, String methodName, Object cacheId, Class[] params, Class returnType, boolean shouldUnwrap) throws SchemaException, WSDLException {
        if (cacheId != null) {
            SOAPMethodInfo ret;
            HashMap<Object, SOAPMethodInfo> javaMethodToMethodInfo = (HashMap<Object, SOAPMethodInfo>)this.serializationIdToJavaMethodToMethodInfo.get(serializationId);
            if (javaMethodToMethodInfo == null) {
                javaMethodToMethodInfo = new HashMap<Object, SOAPMethodInfo>(19);
                this.serializationIdToJavaMethodToMethodInfo.put(serializationId, javaMethodToMethodInfo);
            }
            if ((ret = (SOAPMethodInfo)javaMethodToMethodInfo.get(cacheId)) != null) {
                return ret;
            }
            ret = this.parseMethod(serializationId, methodName, params, returnType, shouldUnwrap);
            if (ret != null) {
                javaMethodToMethodInfo.put(cacheId, ret);
                this.getOperationToMethodInfo(serializationId).put(ret.requestName, ret);
            } else {
                cat.warn("Don't have a WSDL method for java method " + cacheId);
            }
            return ret;
        }
        return this.parseMethod(serializationId, methodName, params, returnType, shouldUnwrap);
    }

    private Map getOperationToMethodInfo(String serializationId) {
        HashMap operationToMethodInfo = (HashMap)this.serializationIdToOperationToMethodInfo.get(serializationId);
        if (operationToMethodInfo == null) {
            operationToMethodInfo = new HashMap(19);
            this.serializationIdToOperationToMethodInfo.put(serializationId, operationToMethodInfo);
        }
        return operationToMethodInfo;
    }

    public synchronized SOAPMethodInfo getMethodInfo(String serializationId, String soapAction, boolean shouldUnwrap) throws SchemaException, WSDLException {
        SOAPMethodInfo ret;
        HashMap<String, SOAPMethodInfo> soapActionToMethodInfo = (HashMap<String, SOAPMethodInfo>)this.serializationIdToSoapActionToMethodInfo.get(serializationId);
        if (soapActionToMethodInfo == null) {
            soapActionToMethodInfo = new HashMap<String, SOAPMethodInfo>(19);
            this.serializationIdToSoapActionToMethodInfo.put(serializationId, soapActionToMethodInfo);
        }
        if ((ret = (SOAPMethodInfo)soapActionToMethodInfo.get(soapAction)) != null) {
            return ret;
        }
        ret = this.parseMethod(serializationId, soapAction, shouldUnwrap);
        if (ret != null) {
            soapActionToMethodInfo.put(soapAction, ret);
        } else {
            cat.warn("Don't have a WSDL method for soapAction " + soapAction);
        }
        return ret;
    }

    public SOAPMethodInfo getMethodInfo(String serializationId, QName requestQName, boolean shouldUnwrap) throws SchemaException, WSDLException {
        Map operationToMethodInfo = this.getOperationToMethodInfo(serializationId);
        SOAPMethodInfo methodInfo = (SOAPMethodInfo)operationToMethodInfo.get(requestQName);
        if (methodInfo != null) {
            return methodInfo;
        }
        methodInfo = this.parseMethod(serializationId, requestQName, shouldUnwrap);
        if (methodInfo != null) {
            operationToMethodInfo.put(methodInfo.requestName, methodInfo);
        } else {
            cat.warn("Don't have a WSDL method for request name " + requestQName);
        }
        return methodInfo;
    }

    private static boolean checkTypesMatch(Part part, String javaType, TypeMappingContext tmCtx) throws SchemaException {
        QName schemaType = part.getTypeName();
        if (schemaType == null) {
            QName elementName = part.getElementName();
            if (elementName == null) {
                throw new SchemaException("At least WSLD <part> type or element attribute is required for " + part.getName());
            }
            Member elementMember = tmCtx.getSchema().getSchemaElement(elementName);
            if (elementMember == null) {
                throw new SchemaException("Element " + elementName + " not found in schema.");
            }
            schemaType = elementMember.getType().getName();
            if (schemaType == null) {
                return false;
            }
        }
        if (Constants.IREF_TYPE_QNAME.equals(schemaType) || Constants.JNDIINSTANCE_TYPE_QNAME.equals(schemaType)) {
            return true;
        }
        String javaTypeMapping = tmCtx.getType(tmCtx.getSchemaType(schemaType));
        return javaType.equals(javaTypeMapping);
    }

    public Schema getCorrectSchema() {
        return this.correctSchema;
    }

    public void setCorrectSchema(Schema schema) {
        this.correctSchema = schema;
    }

    protected static String getSignature(Method method) {
        return SignatureHelper.getSignature(method);
    }

    protected static String getSignature(Class[] params, Class returnType) {
        return SignatureHelper.getSignature(params, returnType);
    }

    private boolean testSoapAction(BindingOperation bOperation, String signature) {
        int p2;
        int p1;
        String soapAction = null;
        SOAPOperation extensibilitySOAPOperation = (SOAPOperation)this.getBindingOperationExtensibilityElement(bOperation, class$javax$wsdl$extensions$soap$SOAPOperation == null ? (class$javax$wsdl$extensions$soap$SOAPOperation = WSDLPortInfo.class$("javax.wsdl.extensions.soap.SOAPOperation")) : class$javax$wsdl$extensions$soap$SOAPOperation);
        if (extensibilitySOAPOperation != null) {
            soapAction = extensibilitySOAPOperation.getSoapActionURI();
        }
        if (soapAction != null && (p1 = soapAction.indexOf("#")) >= 0 && (p2 = soapAction.lastIndexOf("#")) > 0) {
            String ms = soapAction.substring(p2 + 1);
            try {
                String sig = new String(Base64.decode(ms.getBytes(Constants.UTF_8)), Constants.UTF_8);
                return signature.equals(sig);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean testNamespace(BindingOperation bindingOperation, String signature) {
        int signaturePos;
        SOAPBody body;
        MIMEMultipartRelated mimeInput = null;
        String requestNamespaceURI = null;
        if (bindingOperation.getBindingInput() != null) {
            mimeInput = this.getMIMEMultipartRelated(bindingOperation.getBindingInput());
        }
        if ((body = this.getSOAPBody(bindingOperation.getBindingInput(), mimeInput)) != null) {
            requestNamespaceURI = body.getNamespaceURI();
        }
        if (requestNamespaceURI == null) {
            return false;
        }
        int methodNamePos = requestNamespaceURI.indexOf(35);
        String encodedSignature = requestNamespaceURI;
        if (methodNamePos >= 0 && (signaturePos = encodedSignature.indexOf(35, methodNamePos + 1)) >= 0) {
            String sig = encodedSignature.substring(signaturePos + 1);
            try {
                sig = new String(Base64.decode(sig.getBytes("US-ASCII")), "US-ASCII");
                return signature.equals(sig);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    private SOAPMethodInfo parseMethod(String serializationId, String methodName, Class[] params, Class returnType, boolean shouldUnwrap) throws SchemaException, WSDLException {
        BindingOperation bindingOperation = null;
        String encodingURI = null;
        TypeMappingContext tmCtx = null;
        if (this.binding == null) {
            throw new WSDLException("OTHER_ERROR", "Need to have <binding> in call to parseMethod");
        }
        List bindingOperations = this.binding.getBindingOperations();
        Iterator i = bindingOperations.iterator();
        while (i.hasNext()) {
            BindingOperation oper = (BindingOperation)i.next();
            if (!methodName.equals(oper.getName())) continue;
            if (bindingOperation == null) {
                bindingOperation = oper;
                encodingURI = this.getEncodingURI(bindingOperation);
                continue;
            }
            bindingOperation = null;
            break;
        }
        String signature = WSDLPortInfo.getSignature(params, returnType);
        if (bindingOperation == null) {
            Iterator bOperationI = this.binding.getBindingOperations().iterator();
            while (bOperationI.hasNext()) {
                BindingOperation bOperation = (BindingOperation)bOperationI.next();
                if (!methodName.equals(bOperation.getName())) continue;
                JavaOperation javaOperation = this.getJavaOperation(bOperation);
                if (javaOperation != null) {
                    if (!methodName.equals(javaOperation.getJavaName()) || !signature.equals(javaOperation.getJavaSignature())) continue;
                    bindingOperation = bOperation;
                    encodingURI = this.getEncodingURI(bOperation);
                    break;
                }
                if (this.testSoapAction(bOperation, signature)) {
                    bindingOperation = bOperation;
                    encodingURI = this.getEncodingURI(bOperation);
                    break;
                }
                if (this.testNamespace(bOperation, signature)) {
                    bindingOperation = bOperation;
                    encodingURI = this.getEncodingURI(bOperation);
                    break;
                }
                Operation operation = bOperation.getOperation();
                Message inMsg = operation.getInput() != null ? operation.getInput().getMessage() : null;
                Message outMsg = operation.getOutput() != null ? operation.getOutput().getMessage() : null;
                String testedEncodingURI = this.getEncodingURI(bOperation);
                if (tmCtx != null) {
                    serializationRepo.releaseTypeMappingContext(tmCtx);
                }
                tmCtx = serializationRepo.createTypeMappingContext(serializationId, testedEncodingURI, "java");
                tmCtx.setSchema(this.prepareAndGetSchema(serializationId, testedEncodingURI), true);
                if (outMsg != null) {
                    Map partMap = outMsg.getParts();
                    Part retPart = (Part)partMap.get("response");
                    if (retPart == null) {
                        retPart = (Part)partMap.get("return");
                    }
                    if (retPart == null) {
                        retPart = (Part)partMap.get("result");
                    }
                    String methodRetTypeName = returnType.getName();
                    if (retPart != null ? !WSDLPortInfo.checkTypesMatch(retPart, methodRetTypeName, tmCtx) : !methodRetTypeName.equals("void")) continue;
                }
                if (inMsg == null) continue;
                List paramList = operation.getParameterOrdering();
                if (paramList == null) {
                    if (params != null && params.length != 0) continue;
                    bindingOperation = bOperation;
                    encodingURI = testedEncodingURI;
                    break;
                }
                if (params == null || params.length != paramList.size() || params == null || params.length != paramList.size()) continue;
                Iterator paramI = paramList.iterator();
                int i2 = 0;
                boolean match = true;
                while (paramI.hasNext()) {
                    String partName = (String)paramI.next();
                    Part inPart = inMsg.getPart(partName);
                    if (!WSDLPortInfo.checkTypesMatch(inPart, params[i2].getName(), tmCtx)) {
                        match = false;
                        break;
                    }
                    ++i2;
                }
                if (!match) continue;
                bindingOperation = bOperation;
                encodingURI = testedEncodingURI;
                break;
            }
        }
        if (tmCtx != null) {
            serializationRepo.releaseTypeMappingContext(tmCtx);
        }
        return this.convertBindingOperation(this.prepareAndGetSchema(serializationId, encodingURI), bindingOperation, this.binding, methodName, shouldUnwrap);
    }

    private Schema prepareAndGetSchema(String serializationId, String encodingURI) throws SchemaException {
        WSDLSchemas wSDLSchemas = this.wsdlSchemas;
        synchronized (wSDLSchemas) {
            Schema schema = this.getSchema(serializationId, encodingURI);
            if (schema == null) {
                this.prepareSchema(serializationId, encodingURI);
                schema = this.getSchema(serializationId, encodingURI);
            }
            Schema schema2 = schema;
            return schema2;
        }
    }

    private JavaOperation getJavaOperation(BindingOperation operation) {
        if (operation == null) {
            return null;
        }
        List ext = operation.getExtensibilityElements();
        Iterator i = ext.iterator();
        while (i.hasNext()) {
            ExtensibilityElement exte = (ExtensibilityElement)i.next();
            if (!(exte instanceof JavaOperation)) continue;
            return (JavaOperation)exte;
        }
        return null;
    }

    private SOAPMethodInfo parseMethod(String serializationId, QName requestName, boolean shouldUnwrap) throws SchemaException, WSDLException {
        Iterator i = this.binding.getBindingOperations().iterator();
        while (i.hasNext()) {
            BindingOperation bindingOperation = (BindingOperation)i.next();
            Operation operation = bindingOperation.getOperation();
            SOAPMethodInfo mi = this.convertBindingOperation(this.prepareAndGetSchema(serializationId, this.getEncodingURI(bindingOperation)), bindingOperation, this.binding, requestName.toString(), shouldUnwrap);
            if (!requestName.equals(mi.requestName)) continue;
            return mi;
        }
        return null;
    }

    private SOAPMethodInfo parseMethod(String serializationId, String soapAction, boolean shouldUnwrap) throws SchemaException, WSDLException {
        Iterator i = this.binding.getBindingOperations().iterator();
        while (i.hasNext()) {
            String operationSoapAction;
            BindingOperation bindingOperation = (BindingOperation)i.next();
            SOAPOperation extensibilitySOAPOperation = (SOAPOperation)this.getBindingOperationExtensibilityElement(bindingOperation, class$javax$wsdl$extensions$soap$SOAPOperation == null ? WSDLPortInfo.class$("javax.wsdl.extensions.soap.SOAPOperation") : class$javax$wsdl$extensions$soap$SOAPOperation);
            if (extensibilitySOAPOperation == null || !soapAction.equals(operationSoapAction = extensibilitySOAPOperation.getSoapActionURI())) continue;
            return this.convertBindingOperation(this.prepareAndGetSchema(serializationId, this.getEncodingURI(bindingOperation)), bindingOperation, this.binding, soapAction, shouldUnwrap);
        }
        return null;
    }

    private SOAPMethodInfo convertBindingOperation(Schema schema, BindingOperation bindingOperation, Binding binding, String what, boolean shouldUnwrap) throws SchemaException, WSDLException {
        Type elType;
        JavaOperation jOper;
        Output output;
        Operation oper;
        HTTPOperation extensibilityHTTPOperation;
        if (bindingOperation == null) {
            throw new WSDLException("OTHER_ERROR", "No binding operation for \"" + what + "\"");
        }
        SOAPMethodInfo ret = new SOAPMethodInfo();
        SOAPBinding extensibilitySOAPBinding = (SOAPBinding)this.getSoapBindingExtensibilityElement(binding, class$javax$wsdl$extensions$soap$SOAPBinding == null ? (class$javax$wsdl$extensions$soap$SOAPBinding = WSDLPortInfo.class$("javax.wsdl.extensions.soap.SOAPBinding")) : class$javax$wsdl$extensions$soap$SOAPBinding);
        SOAPOperation extensibilitySOAPOperation = (SOAPOperation)this.getBindingOperationExtensibilityElement(bindingOperation, class$javax$wsdl$extensions$soap$SOAPOperation == null ? (class$javax$wsdl$extensions$soap$SOAPOperation = WSDLPortInfo.class$("javax.wsdl.extensions.soap.SOAPOperation")) : class$javax$wsdl$extensions$soap$SOAPOperation);
        if (extensibilitySOAPBinding != null) {
            ret.rpcOperation = "rpc".equals(extensibilitySOAPBinding.getStyle());
        }
        if (extensibilitySOAPOperation != null) {
            if (extensibilitySOAPOperation.getSoapActionURI() != null) {
                ret.soapAction = extensibilitySOAPOperation.getSoapActionURI();
            }
            if (extensibilitySOAPOperation.getStyle() != null) {
                ret.rpcOperation = "rpc".equals(extensibilitySOAPOperation.getStyle());
            }
        }
        if ((extensibilityHTTPOperation = (HTTPOperation)this.getBindingOperationExtensibilityElement(bindingOperation, class$javax$wsdl$extensions$http$HTTPOperation == null ? (class$javax$wsdl$extensions$http$HTTPOperation = WSDLPortInfo.class$("javax.wsdl.extensions.http.HTTPOperation")) : class$javax$wsdl$extensions$http$HTTPOperation)) != null) {
            ret.httpLocationURI = extensibilityHTTPOperation.getLocationURI();
        }
        if ((oper = bindingOperation.getOperation()) == null) {
            throw new WSDLException("OTHER_ERROR", "No operation defined for bindingOperation : " + bindingOperation);
        }
        ArrayList ordering = oper.getParameterOrdering();
        ordering = ordering != null ? new ArrayList(ordering) : new ArrayList();
        HashMap mimeAttachmentParts = new HashMap(7);
        MIMEMultipartRelated mimeInput = null;
        MIMEMultipartRelated mimeOutput = null;
        if (bindingOperation.getBindingInput() != null) {
            mimeInput = this.getMIMEMultipartRelated(bindingOperation.getBindingInput());
            this.processAttachments(mimeAttachmentParts, mimeInput);
        }
        if (bindingOperation.getBindingOutput() != null) {
            mimeOutput = this.getMIMEMultipartRelated(bindingOperation.getBindingOutput());
            this.processAttachments(mimeAttachmentParts, mimeOutput);
        }
        DIMEMessage dimeInput = null;
        DIMEMessage dimeOutput = null;
        if (bindingOperation.getBindingInput() != null) {
            dimeInput = this.getDIMEMessage(bindingOperation.getBindingInput());
        }
        if (bindingOperation.getBindingOutput() != null) {
            dimeOutput = this.getDIMEMessage(bindingOperation.getBindingOutput());
        }
        ret.useDime = dimeInput != null | dimeOutput != null;
        ret.containsRequestAttachment = dimeInput != null || mimeInput != null;
        boolean bl = ret.containsResponseAttachment = dimeOutput != null || mimeOutput != null;
        if (bindingOperation.getBindingInput() != null) {
            ret.httpUriEncoding = this.getHTTPUrlEncoded(bindingOperation.getBindingInput());
        }
        Message inputMessage = null;
        if (oper.getInput() != null) {
            inputMessage = oper.getInput().getMessage();
        }
        Message outputMessage = null;
        if (oper.getOutput() != null) {
            outputMessage = oper.getOutput().getMessage();
        }
        String wrappedMessagePartName = null;
        if (shouldUnwrap && !ret.rpcOperation && ret.requestMessageEncodingURI == null && ret.responseMessageEncodingURI == null) {
            Part outWrappedPart;
            Part inWrappedPart = WSDLUtil.getInputWrappedPart(oper, schema);
            if (inWrappedPart != null) {
                ret.inWrapperQName = inWrappedPart.getElementName();
                wrappedMessagePartName = inWrappedPart.getName();
            }
            if (ret.inWrapperQName != null && (outWrappedPart = WSDLUtil.getOutputWrappedPart(oper, schema)) != null) {
                ret.outWrapperQName = outWrappedPart.getElementName();
            }
        }
        boolean unwrap = shouldUnwrap && ret.inWrapperQName != null && ret.outWrapperQName != null;
        WSDLUtil.getOrdering(inputMessage, outputMessage, ordering);
        ret.parts = new SOAPMethodInfo.PartInfo[ordering.size()];
        Part returnPart = null;
        if (outputMessage != null) {
            returnPart = this.getReturnPart(ordering, outputMessage.getOrderedParts(null));
        }
        List inWrapperMembers = new ArrayList();
        List outWrapperMembers = new ArrayList();
        SOAPMethodInfo.PartInfo[] newPartInfosArr = EMPTY_PARTINFOS;
        if (unwrap) {
            Member outSchemaElement;
            Member inSchemaElement = XMLSchemaUtil.getSchemaElement(schema, ret.inWrapperQName);
            if (inSchemaElement != null) {
                Type schemaType = inSchemaElement.getType();
                inWrapperMembers = WSDLUtil.fetchWrapperMembers(schemaType);
            }
            if (ret.outWrapperQName != null && (outSchemaElement = XMLSchemaUtil.getSchemaElement(schema, ret.outWrapperQName)) != null) {
                Type schemaType = outSchemaElement.getType();
                outWrapperMembers = WSDLUtil.fetchWrapperMembers(schemaType);
            }
            newPartInfosArr = WSDLUtil.mergePartInfos(inWrapperMembers, outWrapperMembers, schema, ordering, mimeAttachmentParts);
        }
        int partPos = 0;
        Iterator i = ordering.iterator();
        while (i.hasNext()) {
            SOAPMethodInfo.PartInfo part;
            String name = (String)i.next();
            if (unwrap && name.equals(wrappedMessagePartName)) {
                ret.parts = this.reallocateParts(ret.parts, partPos, ret.parts.length + newPartInfosArr.length - 1);
                int j = 0;
                while (j < newPartInfosArr.length) {
                    ret.parts[partPos] = newPartInfosArr[j];
                    ++partPos;
                    ++j;
                }
                if (outWrapperMembers.size() <= 0) continue;
                Member m = (Member)outWrapperMembers.get(0);
                SOAPMethodInfo.PartInfo possibleReturnPart = new SOAPMethodInfo.PartInfo();
                possibleReturnPart.partName = m.getName().getLocalPart();
                boolean alreadyPresent = false;
                int j2 = 0;
                while (j2 < newPartInfosArr.length) {
                    if (newPartInfosArr[j2].partName.equals(possibleReturnPart.partName)) {
                        alreadyPresent = true;
                        break;
                    }
                    ++j2;
                }
                if (alreadyPresent) continue;
                possibleReturnPart.partType = 2;
                possibleReturnPart.outSchemaElement = m;
                possibleReturnPart.outSchemaType = m.getType();
                if (mimeAttachmentParts.containsKey(possibleReturnPart.partName)) {
                    possibleReturnPart.isAttachment = true;
                    possibleReturnPart.mimeType = (String)mimeAttachmentParts.get(name);
                }
                ret.returnValuePart = possibleReturnPart;
                cat.debug("setting new return part (from wrapper) " + ret.returnValuePart.partName);
                continue;
            }
            Part inputPart = null;
            Part outputPart = null;
            if (inputMessage != null) {
                inputPart = inputMessage.getPart(name);
            }
            if (outputMessage != null) {
                outputPart = outputMessage.getPart(name);
            }
            ret.parts[partPos] = part = new SOAPMethodInfo.PartInfo();
            if (mimeAttachmentParts.containsKey(name)) {
                part.isAttachment = true;
                part.mimeType = (String)mimeAttachmentParts.get(name);
            }
            if (inputPart != null) {
                if (outputPart != null) {
                    boolean inout = WSDLUtil.isPartInOut(inputPart.getElementName(), inputPart.getTypeName(), outputPart.getElementName(), outputPart.getTypeName(), schema);
                    if (inout) {
                        part.partType = 3;
                        part.partName = outputPart.getName();
                        this.setPartSchemaType(schema, part, outputPart, false);
                        this.setPartSchemaType(schema, part, inputPart, true);
                    } else {
                        part.partType = 1;
                        String inName = part.partName = inputPart.getName();
                        this.setPartSchemaType(schema, part, inputPart, true);
                        ret.parts = this.reallocateParts(ret.parts, ++partPos, ret.parts.length + 1);
                        ret.parts[partPos] = part = new SOAPMethodInfo.PartInfo();
                        part.partType = 2;
                        part.partName = !inName.equals(outputPart.getName()) ? outputPart.getName() : outputPart.getName() + "_out";
                        this.setPartSchemaType(schema, part, outputPart, false);
                    }
                } else {
                    part.partType = 1;
                    part.partName = inputPart.getName();
                    this.setPartSchemaType(schema, part, inputPart, true);
                }
                ++partPos;
                continue;
            }
            if (outputPart != null) {
                part.partType = 2;
                part.partName = outputPart.getName();
                this.setPartSchemaType(schema, part, outputPart, false);
                ++partPos;
                continue;
            }
            cat.warn("Unknown part <" + name + "> in parameterOrder");
        }
        if (partPos != ret.parts.length) {
            ret.parts = this.reallocateParts(ret.parts, partPos, partPos);
        }
        SOAPBody body = this.getSOAPBody(bindingOperation.getBindingOutput(), mimeOutput);
        List headersOut = this.getSOAPHeaders(bindingOperation.getBindingOutput(), mimeOutput);
        String responseNamespaceURI = null;
        if (body != null) {
            responseNamespaceURI = body.getNamespaceURI();
            boolean responseMessageEncoded = "encoded".equals(body.getUse());
            List es = body.getEncodingStyles();
            if (es != null && es.size() > 0) {
                ret.responseMessageEncodingURI = (String)es.get(0);
                if (ret.responseMessageEncodingURI.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                    ret.responseMessageEncodingURI = "http://schemas.xmlsoap.org/soap/encoding/";
                }
            } else {
                ret.responseMessageEncodingURI = responseMessageEncoded ? "http://schemas.xmlsoap.org/soap/encoding/" : null;
            }
        }
        body = this.getSOAPBody(bindingOperation.getBindingInput(), mimeInput);
        List headersIn = this.getSOAPHeaders(bindingOperation.getBindingInput(), mimeInput);
        String requestNamespaceURI = null;
        if (body != null) {
            requestNamespaceURI = body.getNamespaceURI();
            boolean requestMessageEncoded = "encoded".equals(body.getUse());
            List es = body.getEncodingStyles();
            ret.requestMessageEncodingURI = es != null && es.size() > 0 ? ("http://schemas.xmlsoap.org/soap/encoding/".equals(es.get(0)) ? "http://schemas.xmlsoap.org/soap/encoding/" : (String)es.get(0)) : (requestMessageEncoded ? "http://schemas.xmlsoap.org/soap/encoding/" : null);
        }
        ret.operationType = 0;
        if (returnPart != null) {
            ret.returnValuePart = new SOAPMethodInfo.PartInfo();
            ret.returnValuePart.partName = returnPart.getName();
            ret.returnValuePart.partType = 2;
            if (mimeAttachmentParts.containsKey(ret.returnValuePart.partName)) {
                ret.returnValuePart.isAttachment = true;
                ret.returnValuePart.mimeType = (String)mimeAttachmentParts.get(ret.returnValuePart.partName);
            }
            this.setPartSchemaType(schema, ret.returnValuePart, returnPart, false);
        }
        if (outputMessage == null) {
            ret.operationType = 1;
        }
        ret.operationName = oper.getName();
        Input input = oper.getInput();
        if (input != null) {
            ret.inputName = input.getName();
        }
        if ((output = oper.getOutput()) != null) {
            ret.outputName = output.getName();
        }
        if (ret.requestName == null || "".equals(ret.requestName.getLocalPart())) {
            ret.requestName = new QName(requestNamespaceURI, oper.getName());
        }
        if (ret.responseName == null || "".equals(ret.responseName.getLocalPart())) {
            ret.responseName = new QName(responseNamespaceURI, oper.getName() + "Response");
        }
        if ((jOper = (JavaOperation)this.getBindingOperationExtensibilityElement(bindingOperation, class$org$systinet$wsdl$extensions$java$JavaOperation == null ? (class$org$systinet$wsdl$extensions$java$JavaOperation = WSDLPortInfo.class$("org.systinet.wsdl.extensions.java.JavaOperation")) : class$org$systinet$wsdl$extensions$java$JavaOperation)) != null) {
            ret.javaMethodName = jOper.getJavaName();
            ret.signature = jOper.getJavaSignature();
        }
        Map faults = bindingOperation.getBindingFaults();
        ArrayList<String> javaExceptions = new ArrayList<String>();
        ArrayList<String> nonJavaFaults = new ArrayList<String>();
        ret.fillFaultPartInfos(bindingOperation, schema);
        partPos = 0;
        Iterator fi = faults.entrySet().iterator();
        while (fi.hasNext()) {
            Map.Entry e = fi.next();
            String name = (String)e.getKey();
            Fault fault = oper.getFault(name);
            if (fault == null) {
                throw new WSDLException("OTHER_ERROR", "No fault for binding fault " + name);
            }
            Message msg = fault.getMessage();
            if (msg == null) {
                nonJavaFaults.add(name);
            } else {
                Map faultMessageParts = msg.getParts();
                if (faultMessageParts.size() != 1) {
                    nonJavaFaults.add(name);
                } else {
                    Iterator faultMessagePartsI = faultMessageParts.keySet().iterator();
                    String partName = (String)faultMessagePartsI.next();
                    if (partName.startsWith("idoox-java-mapping.")) {
                        String javaException = partName.substring("idoox-java-mapping.".length());
                        javaExceptions.add(javaException);
                    } else {
                        nonJavaFaults.add(name);
                    }
                }
            }
            ++partPos;
        }
        ret.javaExceptions = javaExceptions.toArray(new String[javaExceptions.size()]);
        ret.nonJavaFaults = nonJavaFaults.toArray(new String[nonJavaFaults.size()]);
        int j = 0;
        while (j < ret.parts.length) {
            if (ret.parts[j].partType == 1 || ret.parts[j].partType == 3) {
                Type type = elType = ret.parts[j].inSchemaElement != null ? ret.parts[j].inSchemaElement.getType() : ret.parts[j].inSchemaType;
                if (dimeInput != null && this.isBase64(elType)) {
                    ret.parts[j].isAttachment = true;
                }
            }
            if (ret.parts[j].partType == 2 || ret.parts[j].partType == 3) {
                Type type = elType = ret.parts[j].outSchemaElement != null ? ret.parts[j].outSchemaElement.getType() : ret.parts[j].outSchemaType;
                if (dimeOutput != null && this.isBase64(elType)) {
                    ret.parts[j].isAttachment = true;
                }
            }
            ++j;
        }
        if (ret.returnValuePart != null) {
            Type type = elType = ret.returnValuePart.outSchemaElement != null ? ret.returnValuePart.outSchemaElement.getType() : ret.returnValuePart.outSchemaType;
            if (dimeOutput != null && this.isBase64(elType)) {
                ret.returnValuePart.isAttachment = true;
            }
        }
        ArrayList<SOAPMethodInfo.PartInfo> partsList = new ArrayList<SOAPMethodInfo.PartInfo>();
        ArrayList<SOAPMethodInfo.PartInfo> headerPartsList = new ArrayList<SOAPMethodInfo.PartInfo>();
        int k = 0;
        while (k < ret.parts.length) {
            SOAPMethodInfo.PartInfo pi = ret.parts[k];
            boolean bl2 = pi.isSoapHeader = headersIn.contains(pi.partName) || headersOut.contains(pi.partName);
            if (pi.isSoapHeader) {
                headerPartsList.add(pi);
            } else {
                partsList.add(pi);
            }
            ++k;
        }
        ret.parts = partsList.toArray(new SOAPMethodInfo.PartInfo[0]);
        ret.headerParts = headerPartsList.toArray(new SOAPMethodInfo.PartInfo[0]);
        ret.getRequiredInElements();
        ret.getRequiredOutElements();
        return ret;
    }

    private boolean isBase64(Type type) {
        while (type != null) {
            if (BASE64_BINARY_TYPE.equals(type.getName()) || HEX_BINARY_TYPE.equals(type.getName())) {
                return true;
            }
            type = type.getBaseType();
        }
        return false;
    }

    private SOAPBody getSOAPBody(BindingInput input, MIMEMultipartRelated extensibilityMime) {
        if (extensibilityMime != null) {
            return this.getSOAPBody(extensibilityMime);
        }
        return (SOAPBody)this.getSoapBodyExtensibilityElement(input, class$javax$wsdl$extensions$soap$SOAPBody == null ? (class$javax$wsdl$extensions$soap$SOAPBody = WSDLPortInfo.class$("javax.wsdl.extensions.soap.SOAPBody")) : class$javax$wsdl$extensions$soap$SOAPBody);
    }

    private SOAPBody getSOAPBody(BindingOutput output, MIMEMultipartRelated extensibilityMime) {
        if (extensibilityMime != null) {
            return this.getSOAPBody(extensibilityMime);
        }
        return (SOAPBody)this.getSoapBodyExtensibilityElement(output, class$javax$wsdl$extensions$soap$SOAPBody == null ? (class$javax$wsdl$extensions$soap$SOAPBody = WSDLPortInfo.class$("javax.wsdl.extensions.soap.SOAPBody")) : class$javax$wsdl$extensions$soap$SOAPBody);
    }

    private List getSOAPHeaders(BindingOutput output, MIMEMultipartRelated extensibilityMime) {
        List headers = new ArrayList();
        if (extensibilityMime != null) {
            List mimeParts = extensibilityMime.getMIMEParts();
            Iterator it = mimeParts.iterator();
            while (it.hasNext()) {
                MIMEPart mimePart = (MIMEPart)it.next();
                headers = this.extractSoapHeaders(mimePart.getExtensibilityElements());
            }
        } else if (output != null) {
            headers = this.extractSoapHeaders(output.getExtensibilityElements());
        }
        return headers;
    }

    private List getSOAPHeaders(BindingInput input, MIMEMultipartRelated extensibilityMime) {
        List headers = new ArrayList();
        if (extensibilityMime != null) {
            List mimeParts = extensibilityMime.getMIMEParts();
            Iterator it = mimeParts.iterator();
            while (it.hasNext()) {
                MIMEPart mimePart = (MIMEPart)it.next();
                headers = this.extractSoapHeaders(mimePart.getExtensibilityElements());
            }
        } else if (input != null) {
            headers = this.extractSoapHeaders(input.getExtensibilityElements());
        }
        return headers;
    }

    private List extractSoapHeaders(List extElements) {
        ArrayList<String> ret = new ArrayList<String>();
        if (extElements != null) {
            int i = 0;
            while (i < extElements.size()) {
                SOAPHeader hdr;
                String partName;
                ExtensibilityElement el = (ExtensibilityElement)extElements.get(i);
                if (el != null && el instanceof SOAPHeader && (partName = (hdr = (SOAPHeader)el).getPart()) != null) {
                    ret.add(partName);
                }
                ++i;
            }
        }
        return ret;
    }

    private SOAPBody getSOAPBody(MIMEMultipartRelated extensibilityMime) {
        Iterator i;
        List parts = extensibilityMime.getMIMEParts();
        if (parts != null && (i = parts.iterator()).hasNext()) {
            MIMEPart p = (MIMEPart)i.next();
            return this.findSOAPBody(p);
        }
        return null;
    }

    private SOAPBody findSOAPBody(MIMEPart part) {
        if (part != null) {
            List ext = part.getExtensibilityElements();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                ExtensibilityElement exte = (ExtensibilityElement)i.next();
                if (!(exte instanceof SOAPBody)) continue;
                return (SOAPBody)exte;
            }
        }
        return null;
    }

    private void processAttachments(Map attachmentParts, MIMEMultipartRelated extensibilityMime) {
        List parts;
        if (extensibilityMime != null && (parts = extensibilityMime.getMIMEParts()) != null) {
            Iterator i = parts.iterator();
            while (i.hasNext()) {
                MIMEPart part = (MIMEPart)i.next();
                MIMEContent content = this.getMIMEContent(part);
                if (content == null) continue;
                attachmentParts.put(content.getPart(), content.getType());
            }
        }
    }

    private MIMEMultipartRelated getMIMEMultipartRelated(BindingInput input) {
        if (input != null) {
            List ext = input.getExtensibilityElements();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                ExtensibilityElement exte = (ExtensibilityElement)i.next();
                if (!(exte instanceof MIMEMultipartRelated)) continue;
                return (MIMEMultipartRelated)exte;
            }
        }
        return null;
    }

    private MIMEMultipartRelated getMIMEMultipartRelated(BindingOutput output) {
        if (output != null) {
            List ext = output.getExtensibilityElements();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                ExtensibilityElement exte = (ExtensibilityElement)i.next();
                if (!(exte instanceof MIMEMultipartRelated)) continue;
                return (MIMEMultipartRelated)exte;
            }
        }
        return null;
    }

    private DIMEMessage getDIMEMessage(BindingInput input) {
        if (input != null) {
            List ext = input.getExtensibilityElements();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                ExtensibilityElement exte = (ExtensibilityElement)i.next();
                if (!(exte instanceof DIMEMessage)) continue;
                return (DIMEMessage)exte;
            }
        }
        return null;
    }

    private DIMEMessage getDIMEMessage(BindingOutput output) {
        if (output != null) {
            List ext = output.getExtensibilityElements();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                ExtensibilityElement exte = (ExtensibilityElement)i.next();
                if (!(exte instanceof DIMEMessage)) continue;
                return (DIMEMessage)exte;
            }
        }
        return null;
    }

    private QName getHTTPUrlEncoded(BindingInput input) {
        if (input != null) {
            List ext = input.getExtensibilityElements();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                ExtensibilityElement exte = (ExtensibilityElement)i.next();
                if (!(exte instanceof HTTPUrlEncoded) && !(exte instanceof HTTPUrlReplacement)) continue;
                return exte.getElementType();
            }
        }
        return null;
    }

    private SOAPMethodInfo convertOperation(Schema schema, Operation operation) throws SchemaException {
        Output output;
        SOAPMethodInfo ret = new SOAPMethodInfo();
        ret.rpcOperation = true;
        ret.soapAction = null;
        ArrayList ordering = operation.getParameterOrdering();
        ordering = ordering != null ? new ArrayList(ordering) : new ArrayList();
        Message inputMessage = null;
        if (operation.getInput() != null) {
            inputMessage = operation.getInput().getMessage();
        }
        Message outputMessage = null;
        if (operation.getOutput() != null) {
            outputMessage = operation.getOutput().getMessage();
        }
        WSDLUtil.getOrdering(inputMessage, outputMessage, ordering);
        ret.parts = new SOAPMethodInfo.PartInfo[ordering.size()];
        int partPos = 0;
        Iterator i = ordering.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Part inputPart = null;
            Part outputPart = null;
            if (inputMessage != null) {
                inputPart = inputMessage.getPart(name);
            }
            if (outputMessage != null) {
                outputPart = outputMessage.getPart(name);
            }
            ret.parts[partPos] = new SOAPMethodInfo.PartInfo();
            if (inputPart != null) {
                if (outputPart != null) {
                    if (inputPart.getTypeName() != null && inputPart.getTypeName().equals(outputPart.getTypeName()) || inputPart.getElementName() != null && inputPart.getElementName().equals(outputPart.getElementName())) {
                        ret.parts[partPos].partType = 3;
                        ret.parts[partPos].partName = outputPart.getName();
                        this.setPartSchemaType(schema, ret.parts[partPos], inputPart, true);
                        this.setPartSchemaType(schema, ret.parts[partPos], outputPart, false);
                    } else {
                        ret.parts[partPos].partType = 1;
                        ret.parts[partPos].partName = inputPart.getName();
                        this.setPartSchemaType(schema, ret.parts[partPos], inputPart, true);
                        ret.parts = this.reallocateParts(ret.parts, ++partPos, ret.parts.length + 1);
                        ret.parts[partPos] = new SOAPMethodInfo.PartInfo();
                        ret.parts[partPos].partType = 2;
                        ret.parts[partPos].partName = !inputPart.getName().equals(outputPart.getName()) ? outputPart.getName() : outputPart.getName() + "_out";
                        this.setPartSchemaType(schema, ret.parts[partPos], outputPart, false);
                    }
                } else {
                    ret.parts[partPos].partType = 1;
                    ret.parts[partPos].partName = inputPart.getName();
                    this.setPartSchemaType(schema, ret.parts[partPos], inputPart, true);
                }
                ++partPos;
                continue;
            }
            if (outputPart != null) {
                ret.parts[partPos].partType = 2;
                ret.parts[partPos].partName = outputPart.getName();
                this.setPartSchemaType(schema, ret.parts[partPos], outputPart, false);
                ++partPos;
                continue;
            }
            cat.warn("Unknown part <" + name + "> in parameterOrder");
        }
        if (partPos != ret.parts.length) {
            ret.parts = this.reallocateParts(ret.parts, partPos, partPos);
        }
        ret.requestMessageEncodingURI = "http://schemas.xmlsoap.org/soap/encoding/";
        ret.responseMessageEncodingURI = "http://schemas.xmlsoap.org/soap/encoding/";
        ret.operationType = 0;
        if (outputMessage != null) {
            Part returnPart = this.getReturnPart(ordering, outputMessage.getOrderedParts(null));
            if (returnPart != null) {
                ret.returnValuePart = new SOAPMethodInfo.PartInfo();
                ret.returnValuePart.partName = returnPart.getName();
                this.setPartSchemaType(schema, ret.returnValuePart, returnPart, false);
            }
        } else {
            ret.operationType = 1;
        }
        ret.operationName = operation.getName();
        Input input = operation.getInput();
        if (input != null) {
            ret.inputName = input.getName();
        }
        if ((output = operation.getOutput()) != null) {
            ret.outputName = output.getName();
        }
        if (ret.requestName == null || "".equals(ret.requestName.getLocalPart())) {
            ret.requestName = new QName(null, operation.getName());
        }
        if (ret.responseName == null || "".equals(ret.responseName.getLocalPart())) {
            ret.responseName = new QName(null, operation.getName() + "Response");
        }
        return ret;
    }

    private SOAPMethodInfo.PartInfo[] reallocateParts(SOAPMethodInfo.PartInfo[] parts, int last, int reqSize) {
        SOAPMethodInfo.PartInfo[] newParts = new SOAPMethodInfo.PartInfo[reqSize];
        System.arraycopy(parts, 0, newParts, 0, reqSize > last ? last : reqSize);
        return newParts;
    }

    private void setPartSchemaType(Schema schema, SOAPMethodInfo.PartInfo part, Part wsdlpart, boolean isInput) throws SchemaException {
        QName typeName = wsdlpart.getTypeName();
        if (typeName != null) {
            if (isInput) {
                if (schema == null) {
                    throw new IllegalStateException("prepareSchema() or setSchema() must be called before getting types");
                }
                part.inSchemaType = XMLSchemaUtil.getSchemaType(schema, typeName);
                if (part.inSchemaType == null) {
                    throw new SchemaException("Can not get schema type for " + typeName);
                }
            } else {
                part.outSchemaType = XMLSchemaUtil.getSchemaType(schema, typeName);
                if (part.outSchemaType == null) {
                    throw new SchemaException("Can not get schema type for " + typeName);
                }
            }
        } else {
            QName elementName = wsdlpart.getElementName();
            if (isInput) {
                part.inSchemaElement = XMLSchemaUtil.getSchemaElement(schema, elementName);
                if (part.inSchemaElement == null) {
                    throw new SchemaException("Can not get schema element for " + elementName);
                }
                if (part.inSchemaElement != null) {
                    part.inSchemaType = part.inSchemaElement.getType();
                }
            } else {
                part.outSchemaElement = XMLSchemaUtil.getSchemaElement(schema, elementName);
                if (part.outSchemaElement == null) {
                    throw new SchemaException("Can not get schema element for " + elementName);
                }
                if (part.outSchemaElement != null) {
                    part.outSchemaType = part.outSchemaElement.getType();
                }
            }
        }
    }

    private Part getReturnPart(List parameterOrder, List orderedOutputParts) {
        int parameterOrderLength = parameterOrder.size();
        boolean printPossibleWarning = false;
        Iterator i = orderedOutputParts.iterator();
        while (i.hasNext()) {
            Part possibleRet = (Part)i.next();
            String name = possibleRet.getName();
            int j = 0;
            while (j < parameterOrderLength) {
                if (name.equals(parameterOrder.get(j))) break;
                ++j;
            }
            if (j == parameterOrderLength) {
                if (printPossibleWarning) {
                    cat.warn("Part containing 'return' should always be the first part of output message.");
                }
                return possibleRet;
            }
            printPossibleWarning = true;
        }
        return null;
    }

    private ExtensibilityElement getBindingOperationExtensibilityElement(BindingOperation bo, Class cls) {
        if (bo != null) {
            List ext = bo.getExtensibilityElements();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                ExtensibilityElement exte = (ExtensibilityElement)i.next();
                if (!cls.isInstance(exte)) continue;
                return exte;
            }
        }
        return null;
    }

    private MIMEContent getMIMEContent(MIMEPart part) {
        if (part != null) {
            List ext = part.getExtensibilityElements();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                ExtensibilityElement exte = (ExtensibilityElement)i.next();
                if (!(exte instanceof MIMEContent)) continue;
                return (MIMEContent)exte;
            }
        }
        return null;
    }

    private ExtensibilityElement getSoapBindingExtensibilityElement(Binding b, Class cls) {
        if (b != null) {
            List ext = b.getExtensibilityElements();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                ExtensibilityElement exte = (ExtensibilityElement)i.next();
                if (!cls.isInstance(exte)) continue;
                return exte;
            }
        }
        return null;
    }

    private ExtensibilityElement getSoapBodyExtensibilityElement(BindingOutput bo, Class cls) {
        if (bo != null) {
            List ext = bo.getExtensibilityElements();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                ExtensibilityElement exte = (ExtensibilityElement)i.next();
                if (!cls.isInstance(exte)) continue;
                return exte;
            }
        }
        return null;
    }

    private ExtensibilityElement getSoapBodyExtensibilityElement(BindingInput bi, Class cls) {
        if (bi != null) {
            List ext = bi.getExtensibilityElements();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                ExtensibilityElement exte = (ExtensibilityElement)i.next();
                if (!cls.isInstance(exte)) continue;
                return exte;
            }
        }
        return null;
    }

    public synchronized SOAPMethodInfo[] getMethodInfos(String serializationId) throws SchemaException, WSDLException {
        return this.getMethodInfos(serializationId, false);
    }

    public synchronized SOAPMethodInfo[] getMethodInfos(String serializationId, boolean unwrap) throws SchemaException, WSDLException {
        SOAPMethodInfo[] ret = (SOAPMethodInfo[])this.serializationIdToAllMethodInfos.get(serializationId);
        if (ret != null) {
            return ret;
        }
        if (this.binding != null) {
            List bolist = this.binding.getBindingOperations();
            int l = bolist.size();
            ret = new SOAPMethodInfo[l];
            l = 0;
            Iterator i = bolist.iterator();
            while (i.hasNext()) {
                BindingOperation bindingOperation = (BindingOperation)i.next();
                SOAPOperation extensibilitySOAPOperation = (SOAPOperation)this.getBindingOperationExtensibilityElement(bindingOperation, class$javax$wsdl$extensions$soap$SOAPOperation == null ? WSDLPortInfo.class$("javax.wsdl.extensions.soap.SOAPOperation") : class$javax$wsdl$extensions$soap$SOAPOperation);
                if (extensibilitySOAPOperation != null) {
                    String operationSoapAction = extensibilitySOAPOperation.getSoapActionURI();
                    ret[l++] = this.convertBindingOperation(this.prepareAndGetSchema(serializationId, this.getEncodingURI(bindingOperation)), bindingOperation, this.binding, operationSoapAction, unwrap);
                    continue;
                }
                ret[l++] = this.convertBindingOperation(this.prepareAndGetSchema(serializationId, this.getEncodingURI(bindingOperation)), bindingOperation, this.binding, null, unwrap);
            }
        } else {
            List oplist = this.portType.getOperations();
            int l = oplist.size();
            ret = new SOAPMethodInfo[l];
            l = 0;
            Iterator i = oplist.iterator();
            while (i.hasNext()) {
                Operation operation = (Operation)i.next();
                ret[l++] = this.convertOperation(this.prepareAndGetSchema(serializationId, null), operation);
            }
        }
        this.serializationIdToAllMethodInfos.put(serializationId, ret);
        return ret;
    }

    public SOAPServiceInfo getServiceInfo() {
        return this.soapServiceInfo;
    }

    public String getEndpointURI() {
        return this.endpointURI;
    }

    public void prepareSchema(String serializationId, String encodingURI) throws SchemaException {
        Map namespaceURIToLocationMap = serializationRepo.getNamespaceLocationMap(serializationId, encodingURI);
        this.wsdlSchemas.prepareSchema(serializationId, encodingURI, namespaceURIToLocationMap);
    }

    public void setSchema(String serializationId, String encodingURI, Schema schema) {
        this.wsdlSchemas.setSchema(serializationId, encodingURI, schema);
    }

    public Schema getSchema(String serializationId, String encodingURI) {
        return this.wsdlSchemas.getSchema(serializationId, encodingURI);
    }

    public String toString() {
        try {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance("com.idoox.wsdl.factory.WSDLFactoryImpl");
            WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
            StringWriter wr = new StringWriter();
            wsdlWriter.writeWSDL(this.definition, wr);
            wr.flush();
            wr.close();
            return "Service : " + (this.service != null ? this.service.getQName().toString() : "<null>") + " : port " + (this.port != null ? this.port.getName() : "<null>") + "\n" + wr.toString();
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public synchronized void removeInfos(String serializationId) {
        if (this.serializationIdToJavaMethodToMethodInfo != null) {
            this.serializationIdToJavaMethodToMethodInfo.remove(serializationId);
        }
        if (this.serializationIdToOperationToMethodInfo != null) {
            this.serializationIdToOperationToMethodInfo.remove(serializationId);
        }
        if (this.serializationIdToSoapActionToMethodInfo != null) {
            this.serializationIdToSoapActionToMethodInfo.remove(serializationId);
        }
        if (this.serializationIdToAllMethodInfos != null) {
            this.serializationIdToAllMethodInfos.remove(serializationId);
        }
        this.wsdlSchemas.removeUnusedSchmeas(serializationId);
    }

    private String getEncodingURI(BindingOperation bindingOperation) {
        MIMEMultipartRelated mimeInput = null;
        if (bindingOperation.getBindingInput() != null) {
            mimeInput = this.getMIMEMultipartRelated(bindingOperation.getBindingInput());
        }
        SOAPBody body = this.getSOAPBody(bindingOperation.getBindingInput(), mimeInput);
        String requestMessageEncodingURI = null;
        if (body != null) {
            boolean requestMessageEncoded = "encoded".equals(body.getUse());
            List es = body.getEncodingStyles();
            requestMessageEncodingURI = es != null && es.size() > 0 ? ("http://schemas.xmlsoap.org/soap/encoding/".equals(es.get(0)) ? "http://schemas.xmlsoap.org/soap/encoding/" : (String)es.get(0)) : (requestMessageEncoded ? "http://schemas.xmlsoap.org/soap/encoding/" : null);
        }
        return requestMessageEncodingURI;
    }

    public QName getBindingExtensibilityElementQName() {
        if (this.bindingExtensibilityElementQName == null && this.binding != null) {
            Iterator extIter = this.binding.getExtensibilityElements().iterator();
            while (extIter.hasNext()) {
                Object binding = extIter.next();
                if (binding instanceof SOAPBinding) {
                    this.bindingExtensibilityElementQName = ((SOAPBinding)binding).getElementType();
                    break;
                }
                if (!(binding instanceof HTTPBinding)) continue;
                this.bindingExtensibilityElementQName = ((HTTPBinding)binding).getElementType();
                if (!"GET".equals(((HTTPBinding)binding).getVerb())) break;
                this.isHTTPGET = true;
                break;
            }
        }
        return this.bindingExtensibilityElementQName;
    }

    public String getProtocol() {
        QName bindingQName = this.getBindingExtensibilityElementQName();
        if (XmlUtil.SOAPBINDING_QNAME.equals(bindingQName)) {
            return "soap11";
        }
        if (XmlUtil.SOAP12_BINDING_QNAME.equals(bindingQName)) {
            return "soap12";
        }
        if (XmlUtil.HTTPBINDING_QNAME.equals(bindingQName) && this.isHTTPGET) {
            return "httpget";
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

