/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.ProcessingConfigurationImpl;
import com.idoox.wasp.ProtocolRepositoryImpl;
import com.idoox.wasp.interceptor.InterceptorRepositoryImpl;
import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import com.idoox.xmlrpc.CorrelatedMessagePool;
import com.idoox.xmlrpc.header.HeaderProcessorRepositoryImpl;
import com.systinet.wasp.ServiceManagerImpl;
import com.systinet.wasp.client.ClientProxy;
import com.systinet.wasp.webservice.HeaderProcessorsImpl;
import com.systinet.wasp.webservice.InterceptorsImpl;
import com.systinet.wasp.webservice.ServiceClientImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.rpc.encoding.Serializer;
import org.idoox.config.Configurable;
import org.idoox.transport.client.Endpoint;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.ProtocolHandler;
import org.idoox.wasp.client.config.ClientStubConfiguration;
import org.idoox.wasp.config.EndpointCreationListener;
import org.idoox.wasp.config.WASPConfiguration;
import org.idoox.wasp.server.WSContext;
import org.idoox.wasp.server.config.ServiceEndpointConfiguration;
import org.idoox.xml.schema.Schema;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceEndpoint;

public class WASPConfigurationImpl
extends com.systinet.wasp.webservice.WASPConfigurationImpl
implements WASPConfiguration,
Module {
    public void load(Configurable config) {
        InitialReferencesRegistrar.addInitialReference("org.idoox.wasp.config.WASPConfiguration", this);
    }

    public ServiceEndpointConfiguration getEndpointConfiguration(WSContext service) {
        return service.getEndpointConfiguration();
    }

    public ClientStubConfiguration getStubConfiguration(Object stub, Class iface) {
        InvocationHandler iH;
        if (stub == null) {
            return null;
        }
        if (Proxy.isProxyClass(stub.getClass()) && (iH = Proxy.getInvocationHandler(stub)) instanceof ClientProxy) {
            return WASPConfigurationImpl.createServiceConfigurationImpl(((ClientProxy)stub).getServiceClient());
        }
        throw new IllegalArgumentException("Object not a Systinet Server client stub: " + stub);
    }

    public ClientStubConfiguration getStubConfiguration(Object stub) {
        InvocationHandler iH;
        if (stub == null) {
            return null;
        }
        if (Proxy.isProxyClass(stub.getClass()) && (iH = Proxy.getInvocationHandler(stub)) instanceof ClientProxy) {
            Class<?>[] ifaces = stub.getClass().getInterfaces();
            if (ifaces == null || ifaces.length != 1) {
                throw new IllegalStateException("Stub has multiple interfaces (configurations)");
            }
            return WASPConfigurationImpl.createServiceConfigurationImpl(((ClientProxy)stub).getServiceClient());
        }
        throw new IllegalArgumentException("Object not a Systinet Server client stub: " + stub);
    }

    public void registerEndpointCreationListener(EndpointCreationListener listener) {
        ServiceManagerImpl registry = (ServiceManagerImpl)Context.getInstance("org.systinet.wasp.webservice.IRegistry");
        registry.registerServiceCreationListener(listener);
    }

    public ClientStubConfiguration getDefaultClientConfiguration() {
        return WASPConfigurationImpl.createServiceConfigurationImpl();
    }

    public ClientStubConfiguration getDefaultClientConfiguration(WSContext service) {
        if (service == null) {
            return this.getDefaultClientConfiguration();
        }
        return service.getDefaultClientConfiguration();
    }

    public String registerSerializer(Serializer instance, QName type) {
        return this.sRepo.registerSerializer(instance, type);
    }

    public String registerSerializer(Serializer instance, Class type) {
        return this.sRepo.registerSerializer(instance, type);
    }

    public void unregisterSerializer(String name) {
        this.sRepo.unregisterSerializer(name);
    }

    public String registerDeserializer(Deserializer instance, QName type) {
        return this.sRepo.registerDeserializer(instance, type);
    }

    public void unregisterDeserializer(String name) {
        this.sRepo.unregisterDeserializer(name);
    }

    public String registerFaultSerializer(Serializer instance, Class[] exceptions) {
        return this.sRepo.registerFaultSerializer(instance, exceptions);
    }

    public void unregisterFaultSerializer(String name) {
        this.sRepo.unregisterFaultSerializer(name);
    }

    public String registerFaultDeserializer(Deserializer instance, QName faultCode, String faultActor, QName firstDetailElement) {
        return this.sRepo.registerFaultDeserializer(instance, faultCode, faultActor, firstDetailElement);
    }

    public void unregisterFaultDeserializer(String name) {
        this.sRepo.unregisterFaultDeserializer(name);
    }

    public static StubConfigurationImpl createServiceConfigurationImpl() {
        PortMetaData pmd = new PortMetaData();
        ProtocolRepositoryImpl pRepo = (ProtocolRepositoryImpl)Context.getInstance("org.idoox.wasp.ProtocolRepository");
        SerializationRepositoryImpl serializationRepository = (SerializationRepositoryImpl)Context.getInstance("org.idoox.wasp.serialization.SerializationRepository");
        HeaderProcessorRepositoryImpl hpRepository = (HeaderProcessorRepositoryImpl)Context.getInstance("com.idoox.xmlrpc.header.HeaderProcessorRepository");
        InterceptorRepositoryImpl interceptorRepository = (InterceptorRepositoryImpl)Context.getInstance("com.idoox.wasp.interceptor.InterceptorRepository");
        pmd.handler = pRepo.getProtocolHandler(null);
        pmd.doMultirefs = true;
        pmd.noInstanceIDs = false;
        pmd.noPTMappingPassing = false;
        pmd.headers = hpRepository.cloneHeadersID(null);
        pmd.transportInterceptors = interceptorRepository.cloneInterceptorsID(null, "clientTransportInterceptors");
        pmd.serviceSerializationID = serializationRepository.cloneSerializationID(null);
        pmd.serviceFaultID = serializationRepository.cloneFaultSerializationID(null);
        return new StubConfigurationImpl(pmd, pRepo);
    }

    public static StubConfigurationImpl createServiceConfigurationImpl(ServiceClient serviceClient) {
        ProtocolRepositoryImpl pRepo = (ProtocolRepositoryImpl)Context.getInstance("org.idoox.wasp.ProtocolRepository");
        return new StubConfigurationImpl((ServiceClientImpl)serviceClient, pRepo);
    }

    public static class PortMetaData {
        Endpoint url;
        Schema schemaFromMappingFile;
        Properties lookupProps;
        Configurable usedConfigurable;
        ProtocolHandler handler;
        String encodingId;
        String encoding;
        public String headers;
        public String transportInterceptors;
        String serviceSerializationID;
        String serviceFaultID;
        String securityProvider;
        boolean doMultirefs;
        boolean doPolymorphism = true;
        boolean noInstanceIDs;
        boolean noPTMappingPassing;
        String asyncProtocol;
        CorrelatedMessagePool pool;
        String reverseAddress;
        int asyncTimeout;
        public ServiceEndpoint receiverConfig;
    }

    private static class StubConfigurationImpl
    extends ProcessingConfigurationImpl
    implements ClientStubConfiguration {
        private PortMetaData pmd;
        private ProtocolRepositoryImpl pRepo;

        public StubConfigurationImpl(PortMetaData portMD, ProtocolRepositoryImpl pRepo) {
            this.pmd = portMD;
            this.pRepo = pRepo;
        }

        public StubConfigurationImpl(ServiceClientImpl serviceClient, ProtocolRepositoryImpl pRepo) {
            this.pRepo = pRepo;
            this.pmd = new PortMetaData();
            try {
                this.pmd.url = new Endpoint(serviceClient.getServiceURL());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getSerializationID(boolean create) {
            return this.pmd.serviceSerializationID;
        }

        public String getFaultID(boolean create) {
            return this.pmd.serviceFaultID;
        }

        public String getHeadersID(boolean create) {
            return this.pmd.headers;
        }

        public String getInterceptorsID(boolean create) {
            return this.pmd.transportInterceptors;
        }

        public boolean isInitConfigUsed() {
            return this.pmd.schemaFromMappingFile != null;
        }

        public void setDefaultProtocol(String protocolName) {
            ProtocolHandler pHandler = this.pRepo.getProtocolHandler(protocolName);
            if (pHandler == null) {
                throw new IllegalArgumentException("No such protocol: " + protocolName);
            }
            this.pmd.handler = pHandler;
            if (this.pmd.receiverConfig != null) {
                this.pmd.receiverConfig.setXMLProtocol(protocolName);
            }
        }

        public String getDefaultProtocol() {
            try {
                return this.pRepo.getProtocolHandlerName(this.pmd.handler);
            }
            catch (Exception e) {
                return null;
            }
        }

        public void addInHeaderProcessor(String name, QName[] understoodHeaders) {
            super.addInHeaderProcessor(name, understoodHeaders);
            if (this.pmd.receiverConfig != null) {
                ((HeaderProcessorsImpl)this.pmd.receiverConfig.getHeaderProcessors()).addInHeaderProcessor(name, understoodHeaders, false);
            }
        }

        public void addInHeaderProcessor(String name, QName[] understoodHeaders, int position) {
            super.addInHeaderProcessor(name, understoodHeaders, position);
            if (this.pmd.receiverConfig != null) {
                ((HeaderProcessorsImpl)this.pmd.receiverConfig.getHeaderProcessors()).addInHeaderProcessor(name, understoodHeaders, position, false);
            }
        }

        public void removeInHeaderProcessor(String name) {
            super.removeInHeaderProcessor(name);
            if (this.pmd.receiverConfig != null) {
                ((HeaderProcessorsImpl)this.pmd.receiverConfig.getHeaderProcessors()).removeInHeaderProcessor(name);
            }
        }

        public void addInFaultHeaderProcessor(String name, QName[] understoodHeaders) {
            super.addInFaultHeaderProcessor(name, understoodHeaders);
            if (this.pmd.receiverConfig != null) {
                ((HeaderProcessorsImpl)this.pmd.receiverConfig.getHeaderProcessors()).addInFaultHeaderProcessor(name, understoodHeaders, false);
            }
        }

        public void addInFaultHeaderProcessor(String name, QName[] understoodHeaders, int position) {
            super.addInFaultHeaderProcessor(name, understoodHeaders, position);
            if (this.pmd.receiverConfig != null) {
                ((HeaderProcessorsImpl)this.pmd.receiverConfig.getHeaderProcessors()).addInFaultHeaderProcessor(name, understoodHeaders, position, false);
            }
        }

        public void removeInFaultHeaderProcessor(String name) {
            super.removeInFaultHeaderProcessor(name);
            if (this.pmd.receiverConfig != null) {
                ((HeaderProcessorsImpl)this.pmd.receiverConfig.getHeaderProcessors()).removeInFaultHeaderProcessor(name);
            }
        }

        public void addInterceptor(String name, int direction) {
            super.addInterceptor(name, direction);
            if (this.pmd.receiverConfig != null) {
                ((InterceptorsImpl)this.pmd.receiverConfig.getInterceptors()).addInterceptor(name, direction);
            }
        }

        public void addInterceptor(String name, int direction, int position) {
            super.addInterceptor(name, direction, position);
            if (this.pmd.receiverConfig != null) {
                ((InterceptorsImpl)this.pmd.receiverConfig.getInterceptors()).addInterceptor(name, direction, position);
            }
        }

        public void removeInterceptor(String name) {
            super.removeInterceptor(name);
            if (this.pmd.receiverConfig != null) {
                ((InterceptorsImpl)this.pmd.receiverConfig.getInterceptors()).removeInterceptor(name);
            }
        }

        public boolean isMultirefsEnabled() {
            return this.pmd.doMultirefs;
        }

        public void setMultirefsEnabled(boolean value) {
            this.pmd.doMultirefs = value;
        }

        public boolean isPolymorphismEnabled() {
            return this.pmd.doPolymorphism;
        }

        public void setPolymorphismEnabled(boolean value) {
            this.pmd.doPolymorphism = value;
        }

        public boolean isInstanceIDEnabled() {
            return !this.pmd.noInstanceIDs;
        }

        public void setInstanceIDEnabled(boolean value) {
            boolean bl = this.pmd.noInstanceIDs = !value;
            if (this.pmd.receiverConfig != null) {
                ((ServiceEndpointImpl)this.pmd.receiverConfig).setInstanceIDEnabled(value);
            }
        }

        public boolean isPortTypeMappingPassingEnabled() {
            return !this.pmd.noPTMappingPassing;
        }

        public void setPortTypeMappingPassingEnabled(boolean value) {
            this.pmd.noPTMappingPassing = !value;
        }

        public String getAsyncProtocol() {
            return this.pmd.asyncProtocol;
        }

        public void setAsyncProtocol(String protocol) {
            this.pmd.asyncProtocol = protocol;
        }

        public int getAsyncTimeout() {
            return this.pmd.asyncTimeout;
        }

        public void setAsyncTimeout(int timeout) {
            this.pmd.asyncTimeout = timeout;
        }
    }
}

