/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import com.idoox.wasp.interceptor.InterceptorRepositoryImpl;
import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import com.idoox.xmlrpc.header.HeaderProcessorChain;
import com.idoox.xmlrpc.header.HeaderProcessorRepositoryImpl;
import java.util.List;
import javax.xml.namespace.QName;
import org.idoox.wasp.Context;
import org.idoox.wasp.config.ProcessingConfiguration;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.server.ServiceMediator;
import org.idoox.wasp.server.config.ServiceEndpointConfiguration;

public abstract class ServiceEndpointConfigurationImpl
implements ServiceEndpointConfiguration {
    protected HeaderProcessorRepositoryImpl hpRepo;
    protected SerializationRepositoryImpl sRepo;
    protected InterceptorRepositoryImpl iRepo;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final ProcessingConfiguration.HeaderProcessorEntry[] EMPTY_HPE_ARRAY = new ProcessingConfiguration.HeaderProcessorEntry[0];
    private static final ProcessingConfiguration.InterceptorEntry[] EMPTY_IE_ARRAY = new ProcessingConfiguration.InterceptorEntry[0];

    public ServiceEndpointConfigurationImpl() {
        try {
            this.hpRepo = (HeaderProcessorRepositoryImpl)Context.getInstance("com.idoox.xmlrpc.header.HeaderProcessorRepository");
            this.sRepo = (SerializationRepositoryImpl)Context.getInstance("org.idoox.wasp.serialization.SerializationRepository");
            this.iRepo = (InterceptorRepositoryImpl)Context.getInstance("com.idoox.wasp.interceptor.InterceptorRepository");
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unsupported repository implementation! (" + e.getMessage() + ")");
        }
    }

    public abstract String getSerializationID(boolean var1);

    public abstract String getFaultID(boolean var1);

    public abstract String getHeadersID(boolean var1);

    public abstract String getInterceptorsID(boolean var1);

    public void addSerializer(String name) {
        String serID = this.getSerializationID(true);
        this.sRepo.addSerializer(serID, name);
    }

    public void addSerializer(String name, int position) {
        String serID = this.getSerializationID(true);
        this.sRepo.addSerializer(serID, name, position);
    }

    public void removeSerializer(String name) {
        String serID = this.getSerializationID(false);
        if (serID == null) {
            return;
        }
        this.sRepo.removeSerializer(serID, name);
    }

    public String[] getSerializers() {
        String serID = this.getSerializationID(false);
        if (serID == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.sRepo.getSerializers(serID);
    }

    public void addDeserializer(String name) {
        String serID = this.getSerializationID(true);
        this.sRepo.addDeserializer(serID, name);
    }

    public void addDeserializer(String name, int position) {
        String serID = this.getSerializationID(true);
        this.sRepo.addDeserializer(serID, name, position);
    }

    public void removeDeserializer(String name) {
        String serID = this.getSerializationID(false);
        if (serID == null) {
            return;
        }
        this.sRepo.removeDeserializer(serID, name);
    }

    public String[] getDeserializers() {
        String serID = this.getSerializationID(false);
        if (serID == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.sRepo.getDeserializers(serID);
    }

    public void addFaultSerializer(String name) {
        String fserID = this.getFaultID(true);
        this.sRepo.addFaultSerializer(fserID, name);
    }

    public void addFaultSerializer(String name, int position) {
        String fserID = this.getFaultID(true);
        this.sRepo.addFaultSerializer(fserID, name, position);
    }

    public void removeFaultSerializer(String name) {
        String fserID = this.getFaultID(false);
        if (fserID == null) {
            return;
        }
        this.sRepo.removeFaultSerializer(fserID, name);
    }

    public String[] getFaultSerializers() {
        String fserID = this.getFaultID(false);
        if (fserID == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.sRepo.getFaultSerializers(fserID);
    }

    public void addFaultDeserializer(String name) {
        String fserID = this.getFaultID(true);
        this.sRepo.addFaultDeserializer(fserID, name);
    }

    public void addFaultDeserializer(String name, int position) {
        String fserID = this.getFaultID(true);
        this.sRepo.addFaultDeserializer(fserID, name, position);
    }

    public void removeFaultDeserializer(String name) {
        String fserID = this.getFaultID(false);
        if (fserID == null) {
            return;
        }
        this.sRepo.removeFaultDeserializer(fserID, name);
    }

    public String[] getFaultDeserializers() {
        String fserID = this.getFaultID(false);
        if (fserID == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.sRepo.getFaultDeserializers(fserID);
    }

    public void addInHeaderProcessor(String name, QName[] understoodHeaders) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getIncomingHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders);
        }
    }

    public void addInHeaderProcessor(String name, QName[] understoodHeaders, int position) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getIncomingHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders, position);
        }
    }

    public void removeInHeaderProcessor(String name) {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getIncomingHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return;
        }
        HeaderProcessorChain headerProcessorChain = hpChain;
        synchronized (headerProcessorChain) {
            HeaderProcessorRepositoryImpl.removeHeaderProcessor(hpChain, name);
        }
    }

    public ProcessingConfiguration.HeaderProcessorEntry[] getInHeaderProcessors() {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getIncomingHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return EMPTY_HPE_ARRAY;
        }
        return this.getHeaderEntries(hpChain);
    }

    public void addOutHeaderProcessor(String name, QName[] understoodHeaders) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getOutgoingHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders);
        }
    }

    public void addOutHeaderProcessor(String name, QName[] understoodHeaders, int position) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getOutgoingHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders, position);
        }
    }

    public void removeOutHeaderProcessor(String name) {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getOutgoingHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return;
        }
        HeaderProcessorChain headerProcessorChain = hpChain;
        synchronized (headerProcessorChain) {
            HeaderProcessorRepositoryImpl.removeHeaderProcessor(hpChain, name);
        }
    }

    public ProcessingConfiguration.HeaderProcessorEntry[] getOutHeaderProcessors() {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getOutgoingHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return EMPTY_HPE_ARRAY;
        }
        return this.getHeaderEntries(hpChain);
    }

    public void addInFaultHeaderProcessor(String name, QName[] understoodHeaders) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getInputFaultHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders);
        }
    }

    public void addInFaultHeaderProcessor(String name, QName[] understoodHeaders, int position) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getInputFaultHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders, position);
        }
    }

    public void removeInFaultHeaderProcessor(String name) {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getInputFaultHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return;
        }
        HeaderProcessorChain headerProcessorChain = hpChain;
        synchronized (headerProcessorChain) {
            HeaderProcessorRepositoryImpl.removeHeaderProcessor(hpChain, name);
        }
    }

    public ProcessingConfiguration.HeaderProcessorEntry[] getInFaultHeaderProcessors() {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getInputFaultHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return EMPTY_HPE_ARRAY;
        }
        return this.getHeaderEntries(hpChain);
    }

    public void addOutFaultHeaderProcessor(String name, QName[] understoodHeaders) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getOutputFaultHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders);
        }
    }

    public void addOutFaultHeaderProcessor(String name, QName[] understoodHeaders, int position) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getOutputFaultHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders, position);
        }
    }

    public void removeOutFaultHeaderProcessor(String name) {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getOutputFaultHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return;
        }
        HeaderProcessorChain headerProcessorChain = hpChain;
        synchronized (headerProcessorChain) {
            HeaderProcessorRepositoryImpl.removeHeaderProcessor(hpChain, name);
        }
    }

    public ProcessingConfiguration.HeaderProcessorEntry[] getOutFaultHeaderProcessors() {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getOutputFaultHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return EMPTY_HPE_ARRAY;
        }
        return this.getHeaderEntries(hpChain);
    }

    public void addInterceptor(String name, int direction) {
        if (this.iRepo.getInterceptor(name) == null) {
            throw new IllegalArgumentException("interceptor unknown: '" + name + "'");
        }
        String iChainName = this.getInterceptorsID(true);
        InterceptorChain iChain = this.iRepo.getChain(iChainName);
        iChain.add(name, direction);
    }

    public void addInterceptor(String name, int direction, int position) {
        if (this.iRepo.getInterceptor(name) == null) {
            throw new IllegalArgumentException("interceptor unknown: '" + name + "'");
        }
        String iChainName = this.getInterceptorsID(true);
        InterceptorChain iChain = this.iRepo.getChain(iChainName);
        iChain.add(name, position, direction);
    }

    public void removeInterceptor(String name) {
        if (name == null) {
            return;
        }
        String iChainName = this.getInterceptorsID(false);
        InterceptorChain iChain = this.iRepo.getChain(iChainName);
        if (iChain == null) {
            return;
        }
        int len = iChain.size();
        int i = 0;
        while (i < len) {
            if (name.equals(iChain.getName(i))) {
                iChain.remove(i);
                break;
            }
            ++i;
        }
    }

    public ProcessingConfiguration.InterceptorEntry[] getInterceptors() {
        String iChainName = this.getInterceptorsID(false);
        InterceptorChain iChain = this.iRepo.getChain(iChainName);
        if (iChain == null) {
            return EMPTY_IE_ARRAY;
        }
        InterceptorChain interceptorChain = iChain;
        synchronized (interceptorChain) {
            int len = iChain.size();
            ProcessingConfiguration.InterceptorEntry[] retval = new ProcessingConfiguration.InterceptorEntry[len];
            int i = 0;
            while (i < len) {
                retval[i] = new ProcessingConfiguration.InterceptorEntry();
                retval[i].name = iChain.getName(i);
                retval[i].direction = iChain.getDirection(i);
                ++i;
            }
            ProcessingConfiguration.InterceptorEntry[] interceptorEntryArray = retval;
            return interceptorEntryArray;
        }
    }

    private ProcessingConfiguration.HeaderProcessorEntry[] getHeaderEntries(HeaderProcessorChain hpChain) {
        HeaderProcessorChain headerProcessorChain = hpChain;
        synchronized (headerProcessorChain) {
            String[] names = HeaderProcessorRepositoryImpl.getHeaderProcessors(hpChain);
            ProcessingConfiguration.HeaderProcessorEntry[] retval = new ProcessingConfiguration.HeaderProcessorEntry[names.length];
            int i = 0;
            while (i < names.length) {
                retval[i] = new ProcessingConfiguration.HeaderProcessorEntry();
                retval[i].name = names[i];
                retval[i].understoodHeaders = hpChain.getUnderstandHeaders(i);
                ++i;
            }
            ProcessingConfiguration.HeaderProcessorEntry[] headerProcessorEntryArray = retval;
            return headerProcessorEntryArray;
        }
    }

    public abstract void removeMediator(ServiceMediator var1);

    public abstract void addMediator(ServiceMediator var1);

    public abstract ServiceMediator[] getMediators();

    public abstract void setTypeMapping(QName var1, String var2);

    public abstract void setSchemaLocation(String var1, String var2);

    public abstract void setPortTypeMappingPassingEnabled(boolean var1);

    public abstract boolean isPortTypeMappingPassingEnabled();

    public abstract void setInstanceIDEnabled(boolean var1);

    public abstract boolean isInstanceIDEnabled();

    public abstract void setPolymorphismEnabled(boolean var1);

    public abstract boolean isPolymorphismEnabled();

    public abstract void setMultirefsEnabled(boolean var1);

    public abstract boolean isMultirefsEnabled();

    public abstract String getDefaultProtocol();

    public abstract void setDefaultProtocol(String var1);

    public abstract void addOutHeaderProcessor(String var1, List var2, List var3, int var4);

    public abstract void addInHeaderProcessor(String var1, List var2, List var3, int var4);

    public abstract void addOutHeaderProcessor(String var1, List var2, List var3);

    public abstract void addInHeaderProcessor(String var1, List var2, List var3);
}

