/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import com.idoox.debug.Category;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.config.ModuleConfig;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.WaspInternalException;

public class ModuleRepository {
    private static final Category log = Category.getCategory("com.idoox.wasp.ModuleRepository");
    private List modules = Collections.synchronizedList(new ArrayList(47));
    private boolean isLoading = false;
    private List newModules = new ArrayList(11);
    private Configurator configurator;
    Listener listener;
    static /* synthetic */ Class class$com$idoox$wasp$config$ModuleConfig;
    static /* synthetic */ Class class$org$idoox$wasp$Module;

    public ModuleRepository() {
        InitialReferencesRegistrar.addInitialReference("com.idoox.wasp.ModuleRepository", this);
        this.configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
    }

    public Module addModule(Configurable config) throws WaspInternalException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.isLoading) {
            Module module = this.loadModule(config, false);
            ModuleEntry entry = new ModuleEntry(config.getName(), module);
            this.newModules.add(entry);
            return module;
        }
        Module module = this.loadModule(config, true);
        module.init();
        return module;
    }

    private Module loadModule(Configurable c, boolean addToModules) throws WaspInternalException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ModuleConfig config = (ModuleConfig)c.narrow(class$com$idoox$wasp$config$ModuleConfig == null ? (class$com$idoox$wasp$config$ModuleConfig = ModuleRepository.class$("com.idoox.wasp.config.ModuleConfig")) : class$com$idoox$wasp$config$ModuleConfig);
        String loaderClassName = config.getLoader();
        if (loaderClassName == null) {
            throw new WaspInternalException("Config file does not contain loader for module " + config.getName());
        }
        String moduleClassSpaceName = config.getClassSpace();
        try {
            ClassSpace moduleClassSpace = ClassSpaceHelper.getClassSpace(moduleClassSpaceName, c.getReferenceLocation());
            Module module = (Module)moduleClassSpace.createInstance(class$org$idoox$wasp$Module == null ? (class$org$idoox$wasp$Module = ModuleRepository.class$("org.idoox.wasp.Module")) : class$org$idoox$wasp$Module, loaderClassName);
            if (module == null) {
                throw new WaspInternalException("Could not access loader " + loaderClassName + " in class space " + moduleClassSpaceName);
            }
            module.load(c);
            if (addToModules) {
                ModuleEntry entry = new ModuleEntry(config.getName(), module);
                this.modules.add(entry);
            }
            return module;
        }
        catch (MalformedURLException e) {
            throw new WaspInternalException(e);
        }
        catch (ClassCastException e) {
            throw new WaspInternalException("Module " + config.getName() + " does not implement Module interface", e);
        }
    }

    public Module removeModule(String name) {
        if (this.isLoading) {
            throw new RuntimeException("Cannot remove module when ModuleRepository is being loaded/destroyed");
        }
        Iterator it = this.modules.iterator();
        Module module = null;
        while (it.hasNext()) {
            ModuleEntry entry = (ModuleEntry)it.next();
            if (!entry.name.equals(name)) continue;
            module = entry.module;
            it.remove();
            break;
        }
        if (module == null) {
            return null;
        }
        module.destroy();
        return module;
    }

    public void loadModules() throws WaspInternalException {
        Configurable[] moduleConfigs = Configurator.getTopEntries("module");
        this.isLoading = true;
        this.modules.clear();
        if (moduleConfigs == null || moduleConfigs.length == 0) {
            return;
        }
        int i = 0;
        while (i < moduleConfigs.length) {
            try {
                this.loadModule(moduleConfigs[i], true);
            }
            catch (WaspInternalException e) {
                throw e;
            }
            catch (Exception e) {
                ModuleConfig config = (ModuleConfig)moduleConfigs[i].narrow(class$com$idoox$wasp$config$ModuleConfig == null ? ModuleRepository.class$("com.idoox.wasp.config.ModuleConfig") : class$com$idoox$wasp$config$ModuleConfig);
                log.error("Exception during module " + config.getName() + " loading, loader " + config.getLoader() + ", class space " + config.getClassSpace(), e);
            }
            ++i;
        }
        Iterator it = this.modules.iterator();
        while (it.hasNext()) {
            ModuleEntry entry = (ModuleEntry)it.next();
            if (entry.module == null) continue;
            try {
                entry.module.init();
            }
            catch (WaspInternalException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("Exception during module " + entry.name + " initialization", e);
            }
        }
        while (!this.newModules.isEmpty()) {
            int index = this.modules.size();
            Iterator newModulesIt = this.newModules.iterator();
            this.newModules = new ArrayList(11);
            while (newModulesIt.hasNext()) {
                ModuleEntry newEntry = (ModuleEntry)newModulesIt.next();
                this.modules.add(newEntry);
            }
            int i2 = index;
            while (i2 < this.modules.size()) {
                ModuleEntry entry = (ModuleEntry)this.modules.get(i2);
                if (entry.module != null) {
                    try {
                        entry.module.init();
                    }
                    catch (WaspInternalException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        log.error("Exception during module " + entry.name + " initialization", e);
                    }
                }
                ++i2;
            }
        }
        if (this.listener != null) {
            this.listener.onLoadModules();
        }
        this.isLoading = false;
    }

    public void destroyModules() {
        this.isLoading = true;
        int i = this.modules.size() - 1;
        while (i >= 0) {
            ModuleEntry entry = (ModuleEntry)this.modules.get(i);
            if (entry.module != null) {
                try {
                    entry.module.destroy();
                }
                catch (Throwable e) {
                    log.error("Exception during module " + entry.name + " destroying", e);
                }
            }
            --i;
        }
        this.modules.clear();
        this.isLoading = false;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Listener {
        public void onLoadModules();
    }

    static class ModuleEntry {
        String name;
        Module module;

        ModuleEntry(String name, Module module) {
            this.name = name;
            this.module = module;
        }
    }
}

