/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import com.idoox.wasp.HProcessor;
import com.systinet.wasp.webservice.CurrentImpl;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.header.HeaderProcessingException;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.soap.bc.MessageConvertor;
import org.systinet.wasp.webservice.Current;

public abstract class HPAdaptor
extends GenericHandler {
    private QName[] understandHeaders;
    protected HProcessor instanceHP;
    private String httpHeaderName;
    private String noHeaderValue;
    private int processingType;

    public HPAdaptor(HProcessor instanceHP, String httpHeaderName, String noHeaderValue, QName[] undestandHeaders) {
        this.noHeaderValue = noHeaderValue;
        this.instanceHP = instanceHP;
        this.httpHeaderName = httpHeaderName;
        this.understandHeaders = undestandHeaders;
        this.processingType = -1;
    }

    private int getProcessingType() {
        if (this.processingType == -1) {
            this.processingType = Current.getProcessingType();
        }
        return this.processingType;
    }

    protected HProcessor getHPInstance() {
        return this.instanceHP;
    }

    public QName[] getHeaders() {
        return this.understandHeaders;
    }

    public boolean handleRequest(MessageContext context) {
        try {
            if (this.getProcessingType() == 1) {
                this.processClientOutput(context);
                if (!this.instanceHP.wasHeaderCreated()) {
                    this.noHeader(context);
                }
            } else {
                if (!this.isThereHeader(context)) {
                    return true;
                }
                this.processServerInput(context);
            }
        }
        catch (HeaderProcessingException e) {
            throw new JAXRPCException("Error while processing handleRequest", e);
        }
        return true;
    }

    public boolean handleResponse(MessageContext context) {
        try {
            if (this.getProcessingType() == 1) {
                if (!this.isThereHeader(context)) {
                    return true;
                }
                this.processClientInput(context);
            } else {
                this.processServerOutput(context);
                if (!this.instanceHP.wasHeaderCreated()) {
                    this.noHeader(context);
                }
            }
        }
        catch (HeaderProcessingException e) {
            throw new JAXRPCException("Error while processing handleRequest", e);
        }
        return true;
    }

    public boolean handleFault(MessageContext context) {
        if (!this.isThereHeader(context)) {
            return true;
        }
        try {
            if (this.getProcessingType() == 1) {
                if (!this.isThereHeader(context)) {
                    return true;
                }
                this.instanceHP.processInputFault(this.convertMessage(context, true));
            } else {
                this.instanceHP.processOutputFault(this.convertMessage(context, false));
                if (!this.instanceHP.wasHeaderCreated()) {
                    this.noHeader(context);
                }
            }
        }
        catch (HeaderProcessingException e) {
            throw new JAXRPCException("Error while processing handleRequest", e);
        }
        return true;
    }

    public void init(HandlerInfo config) {
        super.init(config);
    }

    private void noHeader(MessageContext messageContext) {
    }

    private boolean isThereHeader(MessageContext messageContext) {
        return messageContext.containsProperty("MessageSourceImpl.headerPresent");
    }

    protected abstract void processServerInput(MessageContext var1) throws HeaderProcessingException;

    protected abstract void processClientOutput(MessageContext var1) throws HeaderProcessingException;

    protected abstract void processServerOutput(MessageContext var1) throws HeaderProcessingException;

    protected abstract void processClientInput(MessageContext var1) throws HeaderProcessingException;

    protected Message convertMessage(MessageContext context, boolean isInput) {
        WaspSOAPMessage saajMess = (WaspSOAPMessage)((SOAPMessageContext)context).getMessage();
        return MessageConvertor.convertSOAPMessage(saajMess, isInput, false);
    }

    protected Map getCallContextData(MessageContext context) {
        CurrentImpl.ThreadLocals threadLocals = (CurrentImpl.ThreadLocals)context.getProperty("core.current.threadlocals");
        return threadLocals.callContext.getContextData();
    }
}

