/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import com.idoox.debug.Category;
import com.idoox.wasp.classloader.WaspClassLoader;
import com.idoox.wasp.config.ClassSpaceConfig;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.wasp.Context;

public class ClassSpace
implements VetoableChangeListener {
    private ClassLoader classSpaceClassLoader;
    private ClassSpace[] parentClassSpaces;
    private ClassSpace[] childrenClassSpaces;
    private ClassSpaceConfig[] childrenConfigs;
    private String name;
    String currentPath;
    Map allSpaces;
    boolean modifiable = true;
    URL[] classPaths;
    private String referenceLocation;
    private static final Category cat = Category.getCategory("com.idoox.wasp.ClassSpace");

    public ClassSpace(ClassSpace[] parentClassSpaces, String name) {
        this.parentClassSpaces = parentClassSpaces;
        this.name = name;
    }

    public ClassSpace(ClassSpace[] parentClassSpaces, ClassSpaceConfig config) {
        String configLocation;
        if (config == null) {
            throw new IllegalArgumentException("Config is needed");
        }
        this.name = config.getName();
        this.parentClassSpaces = parentClassSpaces;
        Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        this.referenceLocation = configLocation = Configurator.getConfigurable(config).getReferenceLocation();
        ClassSpaceConfig.ClassPath[] p = config.getClassPaths();
        ArrayList<URL> paths = new ArrayList<URL>(p.length);
        int i = 0;
        while (i < p.length) {
            String url = p[i].getUrl().trim();
            if (url.length() != 0) {
                if (url.indexOf(58) < 0 && url.charAt(0) != '/' && url.charAt(0) != '\\') {
                    url = configLocation + File.separator + url;
                }
                try {
                    paths.add(new URL(url));
                }
                catch (MalformedURLException e) {
                    cat.error("Malformed path in class space " + this.name + " " + p[i].getUrl() + " was found.");
                }
            }
            ++i;
        }
        if (paths.size() > 0) {
            this.classPaths = new URL[paths.size()];
            int i2 = 0;
            while (i2 < this.classPaths.length) {
                this.classPaths[i2] = (URL)paths.get(i2);
                ++i2;
            }
        }
        this.childrenConfigs = config.getChildClassSpaces();
    }

    public void init(String path, Map classSpaceMap, Map refToClassSpace) {
        if (this.name == null) {
            throw new IllegalStateException("Need name");
        }
        this.updateLoader();
        path = path != null ? path + '.' + this.name : this.name;
        this.currentPath = path;
        this.allSpaces = classSpaceMap;
        if (classSpaceMap != null) {
            classSpaceMap.put(path, this);
        }
        this.createChildrenClassSpaces(path, classSpaceMap, refToClassSpace);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public String getReferenceLocation() {
        return this.referenceLocation;
    }

    public ClassSpace[] getParentClassSpaces() {
        return this.parentClassSpaces;
    }

    public Enumeration getChildClassSpaces() {
        throw new SecurityException("No permissions to enumerate children class spaces");
    }

    public void addChildClassSpace(ClassSpace childClassSpace) {
        if (this.childrenClassSpaces != null) {
            ClassSpace[] cs = new ClassSpace[this.childrenClassSpaces.length + 1];
            System.arraycopy(this.childrenClassSpaces, 0, cs, 0, this.childrenClassSpaces.length);
            cs[this.childrenClassSpaces.length] = childClassSpace;
            this.childrenClassSpaces = cs;
        } else {
            this.childrenClassSpaces = new ClassSpace[]{childClassSpace};
        }
    }

    public ClassSpace createChildClassSpace(String name) {
        ClassSpace newClassSpace = new ClassSpace(new ClassSpace[]{this}, name);
        this.addChildClassSpace(newClassSpace);
        return newClassSpace;
    }

    public void removeChildClassSpace(ClassSpace childClassSpace) {
        if (this.childrenClassSpaces != null) {
            int pos = 0;
            while (pos < this.childrenClassSpaces.length && childClassSpace != this.childrenClassSpaces[pos]) {
                ++pos;
            }
            if (pos == this.childrenClassSpaces.length) {
                return;
            }
            ClassSpace[] cs = new ClassSpace[this.childrenClassSpaces.length - 1];
            System.arraycopy(this.childrenClassSpaces, 0, cs, 0, pos);
            System.arraycopy(this.childrenClassSpaces, pos + 1, cs, pos, this.childrenClassSpaces.length - pos - 1);
            this.childrenClassSpaces = cs;
        }
    }

    public void addParentClassSpace(ClassSpace parentClassSpace) {
        if (this.parentClassSpaces != null) {
            ClassSpace[] cs = new ClassSpace[this.parentClassSpaces.length + 1];
            System.arraycopy(this.parentClassSpaces, 0, cs, 0, this.parentClassSpaces.length);
            cs[this.parentClassSpaces.length] = parentClassSpace;
            this.parentClassSpaces = cs;
        } else {
            this.parentClassSpaces = new ClassSpace[]{parentClassSpace};
        }
    }

    public URL[] getClassPath() {
        return this.classPaths;
    }

    public void setClassPath(URL[] classpaths) {
        this.classPaths = classpaths;
        this.updateLoader();
    }

    public void addClassPath(URL url) throws MalformedURLException {
        if (url == null) {
            throw new IllegalArgumentException("url can not be null");
        }
        URL[] oldClassPaths = this.classPaths;
        if (oldClassPaths == null) {
            this.classPaths = new URL[]{url};
        } else {
            this.classPaths = new URL[oldClassPaths.length + 1];
            System.arraycopy(oldClassPaths, 0, this.classPaths, 0, oldClassPaths.length);
            this.classPaths[oldClassPaths.length] = url;
        }
        this.updateLoader();
    }

    public void removeFromClassPath(URL url) {
        if (this.classPaths == null) {
            return;
        }
        int i = 0;
        while (i < this.classPaths.length) {
            if (this.classPaths[i].equals(url)) break;
            ++i;
        }
        if (i == this.classPaths.length) {
            return;
        }
        if (this.classPaths.length == 1) {
            this.classPaths = null;
            return;
        }
        URL[] newClassPaths = new URL[this.classPaths.length - 1];
        System.arraycopy(this.classPaths, 0, newClassPaths, 0, i);
        System.arraycopy(this.classPaths, i + 1, newClassPaths, i, this.classPaths.length - i - 1);
        this.classPaths = newClassPaths;
        this.updateLoader();
    }

    public ClassLoader getClassLoader() {
        if (this.classSpaceClassLoader != null) {
            return this.classSpaceClassLoader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    protected void updateLoader() {
        if (this.modifiable) {
            ArrayList<ClassLoader> parentClassLoaders = new ArrayList<ClassLoader>();
            if (this.parentClassSpaces != null) {
                int i = 0;
                while (i < this.parentClassSpaces.length) {
                    parentClassLoaders.add(this.parentClassSpaces[i].getClassLoader());
                    ++i;
                }
            } else {
                parentClassLoaders.add(ClassLoader.getSystemClassLoader());
            }
            if (this.classSpaceClassLoader != null) {
                try {
                    ((WaspClassLoader)this.classSpaceClassLoader).releaseAllResources();
                }
                catch (IOException e) {
                    cat.error("Error during releasing classloader " + this.classSpaceClassLoader, e);
                }
                this.classSpaceClassLoader = null;
            }
            ClassLoader[] parents = parentClassLoaders.toArray(new ClassLoader[0]);
            this.classSpaceClassLoader = this.classPaths != null && this.classPaths.length > 0 ? new WaspClassLoader(this.classPaths, parents) : new WaspClassLoader(new URL[0], parents);
        }
        if (this.childrenClassSpaces != null) {
            int i = 0;
            while (i < this.childrenClassSpaces.length) {
                this.childrenClassSpaces[i].updateLoader();
                ++i;
            }
        }
    }

    private void createChildrenClassSpaces(String path, Map classSpaceMap, Map refToClassSpace) {
        ClassSpaceConfig[] childrenConfigs = this.childrenConfigs;
        if (childrenConfigs == null || childrenConfigs.length == 0) {
            return;
        }
        this.childrenClassSpaces = new ClassSpace[childrenConfigs.length];
        int i = 0;
        while (i < childrenConfigs.length) {
            ClassSpace child = new ClassSpace(new ClassSpace[]{this}, childrenConfigs[i]);
            child.init(path, classSpaceMap, refToClassSpace);
            Configurable configurable = Configurator.getConfigurable(childrenConfigs[i]);
            if (configurable != null) {
                refToClassSpace.put(configurable.getReferenceLocation(), child.getCurrentPath());
            }
            this.childrenClassSpaces[i] = child;
            ++i;
        }
    }

    public void setClassLoader(ClassLoader loader) throws MalformedURLException {
        this.classSpaceClassLoader = loader;
        this.modifiable = false;
        this.updateLoader();
    }

    public Object createInstance(Class iface, String implementationName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class retcls;
        Class<?> cls = Class.forName(iface.getName(), true, this.getClassLoader());
        if (!cls.equals(iface)) {
            throw new ClassNotFoundException("Interface duplicity: " + iface + ", " + cls);
        }
        StringWriter traces = new StringWriter();
        try {
            retcls = this.getClass(iface, implementationName, null, false, false, new PrintWriter(traces));
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Class " + implementationName + " or one of its components not found in " + this.currentPath + "\n\nTraces : \n" + traces.getBuffer().toString());
        }
        if (retcls == null) {
            throw new ClassNotFoundException("Class " + implementationName + " or one of its components not found in " + this.currentPath + "\n\nTraces : \n" + traces.getBuffer().toString());
        }
        Object ret = retcls.newInstance();
        return ret;
    }

    public Class getClass(Class iface, String implementationName) throws ClassNotFoundException {
        Class<?> cls = Class.forName(iface.getName(), true, this.getClassLoader());
        if (!cls.equals(iface)) {
            throw new ClassNotFoundException("Interface duplicity: " + iface + ", " + cls);
        }
        StringWriter traces = new StringWriter();
        Class ret = this.getClass(iface, implementationName, null, false, false, new PrintWriter(traces));
        if (ret == null) {
            throw new ClassNotFoundException("Class " + implementationName + " or one of its components not found in " + this.currentPath + "\n\nTraces : \n" + traces.getBuffer().toString());
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    protected Class getClass(Class iface, String implementationName, ClassSpace excludedClassSpace, boolean alreadyChecked, boolean tryParent, PrintWriter errors) throws ClassNotFoundException {
        block15: {
            implementationClass = null;
            if (!alreadyChecked) {
                block14: {
                    block13: {
                        try {
                            implementationClass = Class.forName(implementationName, true, this.getClassLoader());
                            return implementationClass;
                        }
                        catch (ClassNotFoundException e) {
                            errors.println("=====================");
                            errors.println("Class space : " + this.toString() + "(" + this.classSpaceClassLoader + ")" + " : " + this.currentPath + " : " + this.name);
                            errors.print("Class path :");
                            if (this.classPaths == null) break block13;
                            i = 0;
                            ** while (i < this.classPaths.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            errors.print(" ");
                            errors.print(this.classPaths[i]);
                            ++i;
                            continue;
                        }
                    }
                    errors.println();
                    errors.println();
                    errors.println(e);
                    e.printStackTrace(errors);
                    break block15;
                    catch (NoClassDefFoundError e) {
                        errors.println("=====================");
                        errors.println("Class space : " + this.toString() + "(" + this.classSpaceClassLoader + ")" + " : " + this.currentPath + " : " + this.name);
                        errors.print("Class path :");
                        if (this.classPaths == null) break block14;
                        i = 0;
                        ** while (i < this.classPaths.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        errors.print(" ");
                        errors.print(this.classPaths[i]);
                        ++i;
                        continue;
                    }
                }
                errors.println();
                errors.println();
                errors.println(e);
                e.printStackTrace(errors);
            }
        }
        if (this.childrenClassSpaces != null) {
            i = 0;
            while (i < this.childrenClassSpaces.length) {
                if (this.childrenClassSpaces[i] != excludedClassSpace && (ret = this.childrenClassSpaces[i].getClass(iface, implementationName, null, false, false, errors)) != null) {
                    return ret;
                }
                ++i;
            }
        }
        if (!tryParent || this.parentClassSpaces == null) {
            return null;
        }
        if (iface.getClassLoader() == this.classSpaceClassLoader) {
            throw new ClassNotFoundException("No implementation " + implementationName + "[" + iface + "] found in this class space tree");
        }
        i = 0;
        while (i < this.parentClassSpaces.length) {
            res = this.parentClassSpaces[i].getClass(iface, implementationName, this, true, true, errors);
            if (res != null) {
                return res;
            }
            ++i;
        }
        return null;
    }

    public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        if ("classPaths".equals(event.getPropertyName())) {
            try {
                this.updateLoader();
            }
            catch (Exception e) {
                cat.error("Exception during class space initialization : ", e);
                throw new PropertyVetoException(e.getMessage(), event);
            }
        }
    }
}

