/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util.xml;

import com.idoox.debug.Category;
import com.idoox.util.xml.OutputFormat;
import com.idoox.util.xml.XMLSerializer;
import com.idoox.wasp.Constants;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMWriter {
    private static final Category cat = Category.getCategory("com.idoox.util.xml.DOMWriter");
    static String lineSeparator = "\n";

    public static String serialize(Document doc, boolean doIndent) {
        StringWriter writer = new StringWriter();
        try {
            OutputFormat format = new OutputFormat("xml", Constants.UTF_8, doIndent);
            format.setLineSeparator(lineSeparator);
            format.setLineWidth(80);
            format.setPreserveSpace(false);
            XMLSerializer serializer = new XMLSerializer(writer, format);
            serializer.serialize(doc);
        }
        catch (Exception e) {
            cat.error("Unexpected exception caught ", e);
        }
        return writer.toString();
    }

    public static String serialize(Element element, boolean doIndent) {
        StringWriter writer = new StringWriter();
        try {
            OutputFormat format = new OutputFormat("xml", Constants.UTF_8, doIndent);
            format.setLineSeparator(lineSeparator);
            format.setLineWidth(80);
            format.setPreserveSpace(false);
            XMLSerializer serializer = new XMLSerializer(writer, format);
            serializer.serialize(element);
        }
        catch (Exception e) {
            cat.error("Unexpected exception caught ", e);
        }
        return writer.toString();
    }

    public static String serialize(Element element, boolean doIndent, int indentationLevel) {
        StringWriter writer = new StringWriter();
        try {
            OutputFormat format = new OutputFormat("xml", Constants.UTF_8, doIndent);
            format.setLineSeparator(lineSeparator);
            format.setIndentationLevel(indentationLevel);
            format.setLineWidth(80);
            format.setPreserveSpace(false);
            XMLSerializer serializer = new XMLSerializer(writer, format);
            serializer.serialize(element);
        }
        catch (Exception e) {
            cat.error("Unexpected exception caught ", e);
        }
        return writer.toString();
    }

    public static String serialize(Element element, boolean doIndent, boolean omitXmlDeclaration) {
        StringWriter writer = new StringWriter();
        try {
            OutputFormat format = new OutputFormat("xml", Constants.UTF_8, doIndent);
            format.setLineSeparator(lineSeparator);
            format.setLineWidth(80);
            format.setPreserveSpace(false);
            format.setOmitXMLDeclaration(omitXmlDeclaration);
            XMLSerializer serializer = new XMLSerializer(writer, format);
            serializer.serialize(element);
        }
        catch (Exception e) {
            cat.error("Unexpected exception caught ", e);
        }
        return writer.toString();
    }

    public static String serialize(Element element, boolean doIndent, boolean omitXmlDeclaration, int indentationLevel) {
        StringWriter writer = new StringWriter();
        try {
            OutputFormat format = new OutputFormat("xml", Constants.UTF_8, doIndent);
            format.setLineSeparator(lineSeparator);
            format.setIndentationLevel(indentationLevel);
            format.setLineWidth(80);
            format.setPreserveSpace(false);
            format.setOmitXMLDeclaration(omitXmlDeclaration);
            XMLSerializer serializer = new XMLSerializer(writer, format);
            serializer.serialize(element);
        }
        catch (Exception e) {
            cat.error("Unexpected exception caught ", e);
        }
        return writer.toString();
    }

    public static String serializeContent(Element element, boolean doIndent) {
        return DOMWriter.serializeContent(element, doIndent, 4);
    }

    public static String serializeContent(Element element, boolean doIndent, int indentationLevel) {
        if (element == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                writer.write(child.getNodeValue());
                writer.write(lineSeparator);
            } else if (child instanceof Element) {
                writer.write(DOMWriter.serialize((Element)child, doIndent, true, indentationLevel));
            }
            child = child.getNextSibling();
        }
        return writer.toString();
    }

    public static void serialize(Document doc, OutputStream os, String encoding, boolean doIndent) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, encoding);
        OutputFormat format = new OutputFormat("xml", encoding, doIndent);
        format.setLineSeparator(lineSeparator);
        format.setLineWidth(80);
        format.setPreserveSpace(false);
        XMLSerializer serializer = new XMLSerializer(writer, format);
        serializer.serialize(doc);
    }

    public static void serialize(Element element, OutputStream os, String encoding, boolean doIndent) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, encoding);
        OutputFormat format = new OutputFormat("xml", encoding, doIndent);
        format.setLineSeparator(lineSeparator);
        format.setLineWidth(80);
        format.setPreserveSpace(false);
        XMLSerializer serializer = new XMLSerializer(writer, format);
        serializer.serialize(element);
    }
}

