/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util.xml;

import java.io.IOException;
import org.idoox.xml.TokenWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOM2XMLWriter {
    public static void writeElement(Element elementToWrite, TokenWriter writer) throws IOException {
        DOM2XMLWriter.writeNode(elementToWrite, writer, true);
    }

    public static void writeElementContent(Element elementToWrite, TokenWriter writer) throws IOException {
        DOM2XMLWriter.writeNode(elementToWrite, writer, false);
    }

    private static void writeNode(Node node, TokenWriter writer, boolean writeTopElement) throws IOException {
        if (node instanceof Element) {
            Element el = (Element)node;
            if (writeTopElement) {
                String localName = el.getLocalName();
                if (localName != null) {
                    writer.enter(el.getNamespaceURI(), localName);
                } else {
                    writer.enter(null, el.getNodeName());
                }
            }
            NamedNodeMap attrs = el.getAttributes();
            int alength = attrs.getLength();
            int i = 0;
            while (i < alength) {
                Attr attr = (Attr)attrs.item(i);
                String name = attr.getName();
                String value = attr.getValue();
                if (name.startsWith("xmlns:")) {
                    String prefix = name.substring(6);
                    writer.setPrefixForNamespace(prefix, value);
                } else if (name.equals("xmlns")) {
                    writer.setPrefixForNamespace("", value);
                }
                ++i;
            }
            attrs = el.getAttributes();
            alength = attrs.getLength();
            int i2 = 0;
            while (i2 < alength) {
                Attr attr = (Attr)attrs.item(i2);
                String name = attr.getName();
                String localname = attr.getLocalName();
                String value = attr.getValue();
                String ns = attr.getNamespaceURI();
                if (!name.startsWith("xmlns:") && !name.equals("xmlns")) {
                    writer.writeAttribute(ns, localname != null ? localname : name, value);
                }
                ++i2;
            }
            Node n = el.getFirstChild();
            while (n != null) {
                DOM2XMLWriter.writeNode(n, writer, true);
                n = n.getNextSibling();
            }
            if (writeTopElement) {
                writer.leave();
            }
        } else if (node instanceof Text) {
            writer.writeContent(((Text)node).getData());
        } else if (!(node instanceof Comment)) {
            throw new UnsupportedOperationException("Unable to serialize : " + node);
        }
    }
}

