/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util;

import com.idoox.debug.Category;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class ThreadPool {
    private static final Category log = Category.getCategory("com.idoox.util.ThreadPool");
    private String name;
    private int count;
    private List pool;
    private Set trash;
    private int maxThreads;
    private boolean daemon;

    public ThreadPool(String name, int minThreads, int maxThreads, boolean daemon) {
        this.name = name;
        this.pool = new LinkedList();
        this.setMinThreads(minThreads);
        this.maxThreads = maxThreads;
        this.trash = new HashSet(minThreads);
        this.daemon = daemon;
    }

    public int getFreeThreadsCount() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            int poolSize = this.pool.size();
            int reserve = this.maxThreads - this.count;
            if (reserve > 0) {
                int n = poolSize + reserve;
                return n;
            }
            int n = poolSize;
            return n;
        }
    }

    public void job(Object object) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            try {
                while (this.pool.size() == 0 && this.count >= this.maxThreads) {
                    this.wait();
                }
                ThreadEx thread = null;
                if (this.pool.size() > 0) {
                    thread = (ThreadEx)this.pool.remove(this.pool.size() - 1);
                } else {
                    thread = new ThreadEx(this, this.daemon);
                    ++this.count;
                }
                ThreadEx threadEx = thread;
                synchronized (threadEx) {
                    thread.unrelease();
                    thread.ext = object;
                    if (!thread.isAlive()) {
                        thread.start();
                    } else {
                        thread.notify();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setMinThreads(int minThreads) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            int i = this.pool.size();
            while (i < minThreads) {
                ThreadEx thread = new ThreadEx(this, this.daemon);
                this.pool.add(thread);
                ++i;
            }
            this.notify();
        }
    }

    public void setMaxThreads(int maxThreads) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.maxThreads = maxThreads;
            this.notify();
        }
    }

    public void destroy() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            Iterator i = this.trash.iterator();
            while (i.hasNext()) {
                ThreadEx thread = (ThreadEx)i.next();
                thread.stopping = true;
                thread.interrupt();
            }
            this.trash.clear();
            Iterator i2 = this.pool.iterator();
            while (i2.hasNext()) {
                ThreadEx thread;
                ThreadEx threadEx = thread = (ThreadEx)i2.next();
                synchronized (threadEx) {
                    thread.stopping = true;
                    thread.notify();
                }
            }
            this.pool.clear();
        }
    }

    protected abstract void handle(Object var1);

    public class ThreadEx
    extends Thread {
        public ThreadPool threadPool;
        public Object ext;
        public boolean stopping = false;

        public ThreadEx(ThreadPool threadPool, boolean daemon) {
            super(ThreadPool.this.name + "-" + (ThreadPool.this.count + 1));
            this.threadPool = threadPool;
            this.setDaemon(daemon);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    ThreadEx threadEx = this;
                    synchronized (threadEx) {
                        try {
                            ThreadPool.this.handle(this.ext);
                        }
                        catch (Exception e) {
                            log.error(this.getName(), e);
                        }
                        if (this.stopping) {
                            return;
                        }
                        this.release();
                        this.wait();
                        if (this.stopping) {
                            return;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void release() {
            ThreadPool threadPool = this.threadPool;
            synchronized (threadPool) {
                ThreadPool.this.trash.remove(this);
                ThreadPool.this.pool.add(this);
                this.threadPool.notify();
            }
        }

        void unrelease() {
            ThreadPool threadPool = this.threadPool;
            synchronized (threadPool) {
                ThreadPool.this.trash.add(this);
                this.threadPool.notify();
            }
        }
    }
}

