/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util;

import com.idoox.util.Pool;
import java.lang.ref.SoftReference;
import java.util.WeakHashMap;

public class SoftReferencePool
implements Pool {
    private SoftReference[] objects;
    private WeakHashMap references;
    private int top;
    private int size;
    private Pool.Factory factory;

    public void init(Pool.Factory fact, int size) {
        this.objects = new SoftReference[size];
        this.references = new WeakHashMap();
        this.top = -1;
        this.size = size;
        this.factory = fact;
    }

    public synchronized Object get() {
        while (this.top >= 0) {
            Object retval = this.objects[this.top].get();
            this.objects[this.top] = null;
            --this.top;
            if (retval == null) continue;
            return retval;
        }
        return this.factory.getNewInstance();
    }

    public synchronized void release(Object obj) {
        if (this.top < this.size - 1) {
            ++this.top;
            SoftReference<Object> ref = (SoftReference<Object>)this.references.get(obj);
            if (ref == null) {
                ref = new SoftReference<Object>(obj);
                this.references.put(obj, ref);
            }
            this.objects[this.top] = ref;
        }
    }
}

