/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util;

import com.idoox.util.SignatureHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class MethodResolverHelper {
    public static Method resolveMethod(Class clazz, String methodDescriptor) throws NoSuchMethodException {
        String trimMethod = methodDescriptor.trim();
        int posBeginArgs = trimMethod.indexOf(40);
        int posEndArgs = trimMethod.indexOf(41);
        if (posBeginArgs != -1 && posEndArgs != -1) {
            String methodName = trimMethod.substring(0, posBeginArgs);
            ArrayList<String> argList = new ArrayList<String>();
            if (trimMethod.charAt(posBeginArgs + 1) != ')') {
                String args = methodDescriptor.substring(posBeginArgs + 1, posEndArgs);
                StringTokenizer tokenizer = new StringTokenizer(args, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    int bracketCount = SignatureHelper.countBrackets(token);
                    if (bracketCount > 0) {
                        argList.add(SignatureHelper.getSignature(token).replace('/', '.'));
                        continue;
                    }
                    argList.add(token);
                }
            }
            Method[] methods = clazz.getMethods();
            int i = 0;
            while (i < methods.length) {
                Class<?>[] parameterTypes;
                Method method = methods[i];
                if (methodName.equals(method.getName()) && (parameterTypes = method.getParameterTypes()).length == argList.size()) {
                    if (parameterTypes.length == 0) {
                        return method;
                    }
                    boolean found = true;
                    int j = 0;
                    while (j < parameterTypes.length) {
                        String parameterType = parameterTypes[j].getName();
                        if (!parameterType.equals(argList.get(j))) {
                            found = false;
                            break;
                        }
                        ++j;
                    }
                    if (found) {
                        return method;
                    }
                }
                ++i;
            }
        } else {
            throw new NoSuchMethodException("Invalid method descriptor " + methodDescriptor + ". It doesn't contain ( or )");
        }
        return null;
    }
}

