/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util;

import antlr.collections.AST;
import com.idoox.util.ClassInfo;
import com.idoox.util.JavaLexer;
import com.idoox.util.JavaParser;
import com.idoox.util.JavaTokenTypes;
import com.idoox.util.MethodInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class JavaTool
implements JavaTokenTypes {
    private static Map constMap;
    static /* synthetic */ Class class$com$idoox$util$JavaTokenTypes;

    public static ClassInfo getClassInfo(Class referenceClass) {
        return JavaTool.getClassInfo(referenceClass, null);
    }

    /*
     * WARNING - void declaration
     */
    public static ClassInfo getClassInfo(Class referenceClass, ClassLoader classLoader) {
        URL resourceURL;
        String clazzName;
        if (classLoader == null) {
            classLoader = referenceClass.getClassLoader();
        }
        ArrayList<String> innerNamesList = new ArrayList<String>(2);
        String resourceName = clazzName = referenceClass.getName();
        int lastIx = clazzName.indexOf(36);
        if (lastIx != -1) {
            int ix;
            resourceName = clazzName.substring(0, lastIx);
            while ((ix = clazzName.indexOf(36, lastIx + 1)) != -1) {
                void var5_6;
                innerNamesList.add(clazzName.substring(lastIx + 1, (int)var5_6));
                lastIx = var5_6;
            }
            innerNamesList.add(clazzName.substring(lastIx + 1));
        }
        if ((resourceURL = classLoader.getResource(resourceName.replace('.', '/') + ".java")) == null) {
            return null;
        }
        AST resourceAST = JavaTool.createAST(resourceURL);
        if (resourceAST != null) {
            String refClassFlatName;
            String packageName = "";
            AST classAST = resourceAST;
            if (resourceAST.getType() == 16) {
                packageName = JavaTool.getPackageName(resourceAST);
            }
            if (referenceClass.getPackage() != null ? !packageName.equals(referenceClass.getPackage().getName()) : packageName.length() > 0) {
                return null;
            }
            if (classAST.getType() != 14 && classAST.getType() != 15) {
                classAST = JavaTool.findSibling(resourceAST, 14, 15);
            }
            String string = refClassFlatName = packageName.length() > 0 ? resourceName.substring(packageName.length() + 1) : resourceName;
            if (!refClassFlatName.equals(JavaTool.findChild(classAST, 55).getText())) {
                return null;
            }
            Iterator innerNameI = innerNamesList.iterator();
            while (innerNameI.hasNext()) {
                String segment = (String)innerNameI.next();
                AST objBlk = JavaTool.findChild(classAST, 6);
                if (objBlk == null) {
                    return null;
                }
                classAST = JavaTool.findChild(objBlk, 14, 15);
                if (segment.equals(JavaTool.findChild(classAST, 55).getText())) continue;
                return null;
            }
            return new ClassInfo(referenceClass, classAST);
        }
        return null;
    }

    private static String getPackageName(AST packageDef) {
        StringBuffer ret = new StringBuffer("");
        JavaTool.getPackageName(packageDef.getFirstChild(), ret);
        return ret.toString();
    }

    private static void getPackageName(AST node, StringBuffer pkgName) {
        if (node.getType() == 55) {
            pkgName.append(node.getText());
        } else if (node.getType() == 56) {
            AST child = node.getFirstChild();
            JavaTool.getPackageName(child, pkgName);
            pkgName.append(".");
            JavaTool.getPackageName(child.getNextSibling(), pkgName);
        } else {
            throw new RuntimeException("Bad AST (type=" + node.getType() + ")");
        }
    }

    private static AST createAST(URL fileURL) {
        InputStream fileIS = null;
        try {
            String fileName = fileURL.toExternalForm();
            fileIS = fileURL.openStream();
            JavaLexer lexer = new JavaLexer(fileIS);
            lexer.setFilename(fileName);
            JavaParser parser = new JavaParser(lexer);
            parser.setFilename(fileName);
            parser.compilationUnit();
            fileIS.close();
            return parser.getAST();
        }
        catch (Exception e) {
            if (fileIS != null) {
                try {
                    fileIS.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    static AST findChild(AST node, int type) {
        AST child = node.getFirstChild();
        while (child != null && child.getType() != type) {
            child = child.getNextSibling();
        }
        return child;
    }

    static AST findChild(AST node, int type1, int type2) {
        AST child = node.getFirstChild();
        while (child != null && child.getType() != type1 && child.getType() != type2) {
            child = child.getNextSibling();
        }
        return child;
    }

    static AST findSibling(AST node, int siblingType) {
        AST sibling = node.getNextSibling();
        while (sibling != null && sibling.getType() != siblingType) {
            sibling = sibling.getNextSibling();
        }
        return sibling;
    }

    static AST findSibling(AST node, int siblingType1, int siblingType2) {
        AST sibling = node.getNextSibling();
        while (sibling != null && sibling.getType() != siblingType1 && sibling.getType() != siblingType2) {
            sibling = sibling.getNextSibling();
        }
        return sibling;
    }

    static String getTypeName(AST typeNode) {
        StringBuffer sBuf = new StringBuffer();
        JavaTool.getTypeName(typeNode.getFirstChild(), sBuf);
        return sBuf.toString();
    }

    private static void getTypeName(AST typeNode, StringBuffer ret) {
        if (typeNode == null) {
            return;
        }
        AST fChild = typeNode.getFirstChild();
        JavaTool.getTypeName(fChild, ret);
        ret.append(typeNode.getText());
        if (fChild != null) {
            JavaTool.getTypeName(fChild.getNextSibling(), ret);
        }
    }

    static String getTypeName(Class clazz) {
        StringBuffer sbRet = new StringBuffer("");
        while (clazz.isArray()) {
            sbRet.append("[");
            clazz = clazz.getComponentType();
        }
        return clazz.getName() + sbRet.toString();
    }

    static Package getPackage(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz.getPackage();
    }

    public static Class getClass(String path) {
        InternalCL iCL = new InternalCL();
        return iCL.getClass(path);
    }

    public static Class getClass(byte[] bytes) {
        InternalCL iCL = new InternalCL();
        return iCL.getClass(bytes);
    }

    private static String getConstName(int constVal) {
        if (constMap == null) {
            return null;
        }
        return (String)constMap.get(new Integer(constVal));
    }

    private static void printAST(AST ast) {
        JavaTool.printAST(ast, "");
    }

    private static void printAST(AST ast, String prefix) {
        if (ast == null) {
            return;
        }
        System.out.println(prefix + JavaTool.getConstName(ast.getType()) + " \"" + ast.getText() + "\"");
        JavaTool.printAST(ast.getFirstChild(), prefix + "   ");
        JavaTool.printAST(ast.getNextSibling(), prefix);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new Exception("Usage: com.idoox.util.JavaTool <class>");
        }
        File fl = new File(args[0]);
        JavaTool.printAST(JavaTool.createAST(fl.toURL()));
        System.out.println("printed");
        Class<?> clazz = Class.forName(args[0]);
        ClassInfo cInfo = JavaTool.getClassInfo(clazz);
        if (cInfo == null) {
            throw new Exception("Source for class " + args[0] + " not found!");
        }
        Method[] methodA = clazz.getDeclaredMethods();
        int i = 0;
        while (i < methodA.length) {
            MethodInfo mInfo = cInfo.getMethodInfo(methodA[i]);
            if (mInfo == null) {
                System.err.println("Cannot find source for method " + methodA[i] + "!");
            } else {
                System.out.println("Method: " + methodA[i].getName());
                String[] paramNames = mInfo.getParameterNames();
                if (paramNames != null) {
                    int j = 0;
                    while (j < paramNames.length) {
                        System.out.println(">>> " + paramNames[j]);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Field[] fieldA = (class$com$idoox$util$JavaTokenTypes == null ? (class$com$idoox$util$JavaTokenTypes = JavaTool.class$("com.idoox.util.JavaTokenTypes")) : class$com$idoox$util$JavaTokenTypes).getFields();
            constMap = new HashMap((int)((double)fieldA.length / 0.75));
            int i = 0;
            while (i < fieldA.length) {
                constMap.put(new Integer(fieldA[i].getInt(null)), fieldA[i].getName());
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class InternalCL
    extends SecureClassLoader {
        private InternalCL() {
        }

        /*
         * WARNING - void declaration
         */
        public Class getClass(byte[] buf) {
            try {
                void e;
                Class<?> clazz = super.defineClass(null, buf, 0, buf.length);
                return e;
            }
            catch (Exception e) {
                return null;
            }
        }

        public Class getClass(String path) {
            File cFile = new File(path);
            try {
                if (!cFile.isFile() || !cFile.canRead()) {
                    return null;
                }
                FileInputStream fileIS = new FileInputStream(cFile);
                int index = 0;
                byte[] buf = new byte[new Long(cFile.length()).intValue()];
                while (index != buf.length && -1 != (index = fileIS.read(buf, index, buf.length - index))) {
                }
                Class<?> clazz = super.defineClass(null, buf, 0, buf.length);
                return clazz;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

