/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util;

import com.idoox.debug.Category;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CopyOnWriteHelper {
    private static final Category log = Category.getCategory("com.idoox.util.CopyOnWriteHelper");
    private long cowCount = 0L;
    private String namePrefix;
    private CopyingHandler handler;
    private Map cows = new HashMap();

    public CopyOnWriteHelper(CopyingHandler handler, String namePrefix) {
        this.namePrefix = namePrefix;
        this.handler = handler;
    }

    public synchronized String cloneID(String id) {
        String name = this.namePrefix + this.cowCount++;
        String origID = this.resolveID(id, false);
        this.cows.put(name, origID);
        this.cows.put(origID, origID);
        return name;
    }

    public synchronized String resolveID(String id, boolean write) {
        if (write) {
            if (id == null) {
                return null;
            }
            if (this.cows.containsKey(id)) {
                this.copyCOW(id);
            }
            return id;
        }
        if (this.cows.containsKey(id)) {
            return (String)this.cows.get(id);
        }
        return id;
    }

    private void copyCOW(String id) {
        if (!this.cows.containsKey(id)) {
            log.warn("copyCOW called with a non-COW id " + id);
            return;
        }
        String origID = (String)this.cows.remove(id);
        if (id.equals(origID)) {
            id = this.namePrefix + this.cowCount++;
            Iterator it = this.cows.entrySet().iterator();
            boolean foundAnotherCOWReferencingOrigID = false;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if ((origID != null || entry.getValue() != null) && (origID == null || !origID.equals(entry.getValue()))) continue;
                entry.setValue(id);
                foundAnotherCOWReferencingOrigID = true;
            }
            if (!foundAnotherCOWReferencingOrigID) {
                this.cows.remove(origID);
                return;
            }
            this.cows.put(id, id);
        }
        this.handler.doCopy(origID, id);
    }

    public void removeID(String id) {
        if (id == null) {
            log.warn("NULL copy-on-write ID should never be removed - ignoring.");
            return;
        }
        if (!this.cows.containsKey(id)) {
            return;
        }
        Object origID = this.cows.get(id);
        if (id.equals(origID)) {
            this.copyCOW(id);
        }
        this.cows.remove(id);
    }

    public static interface CopyingHandler {
        public void doCopy(String var1, String var2);
    }
}

