/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.util;

import java.io.IOException;
import java.io.OutputStream;

public class WriteLine {
    public static int MAX_LINE_LENGTH = 65536;
    public static byte CR = (byte)13;
    public static byte LF = (byte)10;
    public static byte[] CRLF = new byte[]{CR, LF};
    public static byte COLON = (byte)58;
    public static byte SP = (byte)32;
    protected OutputStream output;
    public byte[] buffer;

    public WriteLine(OutputStream output) {
        this.output = output;
        this.buffer = new byte[256];
    }

    public void setOutputStream(OutputStream output) {
        this.output = output;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public void write(String line, boolean crlf) throws IOException {
        int length = line.length();
        if (crlf) {
            length += 2;
        }
        this.checkBuffer(length);
        line.getBytes(0, line.length(), this.buffer, 0);
        if (crlf) {
            this.buffer[length - 2] = CR;
            this.buffer[length - 1] = LF;
        }
        this.output.write(this.buffer, 0, length);
    }

    public void write(byte[] line, boolean crlf) throws IOException {
        if (line != null) {
            this.output.write(line);
        }
        if (crlf) {
            this.output.write(CRLF);
        }
    }

    public void writeHeader(String name, String value) throws IOException {
        this.checkBuffer(name.length() + 2);
        int off = 0;
        int crlf = value.indexOf("\r\n", off);
        if (crlf == -1) {
            crlf = value.length();
        }
        do {
            name.getBytes(0, name.length(), this.buffer, 0);
            this.buffer[name.length()] = COLON;
            this.buffer[name.length() + 1] = SP;
            this.output.write(this.buffer, 0, name.length() + 2);
            this.checkBuffer(crlf - off + 2);
            value.getBytes(off, crlf, this.buffer, 0);
            this.buffer[crlf - off] = CR;
            this.buffer[crlf - off + 1] = LF;
            this.output.write(this.buffer, 0, crlf - off + 2);
        } while ((crlf = value.indexOf("\r\n", off = crlf + 2)) != -1);
    }

    private void checkBuffer(int newSize) throws IOException {
        if (this.buffer.length < newSize) {
            if (newSize >= MAX_LINE_LENGTH) {
                throw new IOException("Line is too long - maximum size is " + MAX_LINE_LENGTH + " bytes");
            }
            this.buffer = new byte[newSize];
        }
    }
}

