/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.util;

import java.io.IOException;
import java.io.InputStream;

public class ReadLine {
    public static int MAX_LINE_LENGTH = 65536;
    public static byte CR = (byte)13;
    public static byte LF = (byte)10;
    public static byte[] CRLF = new byte[]{CR, LF};
    protected InputStream input;
    public byte[] buffer;
    public int count = 0;

    public ReadLine(InputStream input) {
        this.input = input;
        this.buffer = new byte[256];
    }

    public void setInputStream(InputStream input) {
        this.input = input;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public int read() throws IOException {
        int readChar;
        this.count = 0;
        do {
            if (this.count >= MAX_LINE_LENGTH) {
                throw new IOException("Line is too long - maximum size is " + MAX_LINE_LENGTH + " bytes");
            }
            readChar = this.input.read();
            if (readChar < 0) {
                if (this.count == 0) {
                    throw new IOException("Server closed the connection");
                }
                throw new IOException("Incomplete read line (server closed the connection): '" + new String(this.buffer, 0, this.count) + "'");
            }
            if (readChar == CR || readChar == LF) continue;
            if (this.count == this.buffer.length) {
                byte[] newbuffer = new byte[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, newbuffer, 0, this.count);
                this.buffer = newbuffer;
            }
            this.buffer[this.count++] = (byte)readChar;
        } while (readChar != LF);
        return this.count;
    }
}

