/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class MyBufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;

    public MyBufferedOutputStream(OutputStream out) {
        this(out, 512);
    }

    public MyBufferedOutputStream(OutputStream out, int size) {
        super(out);
        this.buf = new byte[size];
    }

    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len < this.buf.length - this.count) {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        } else {
            int size = this.buf.length - this.count;
            System.arraycopy(b, off, this.buf, this.count, size);
            off += size;
            len -= size;
            this.count = this.buf.length;
            this.flushBuffer();
            size = len % this.buf.length;
            if (len - size > 0) {
                this.out.write(b, off, len - size);
            }
            System.arraycopy(b, off + len - size, this.buf, this.count, size);
            this.count += size;
        }
    }

    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }
}

