/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.util;

import com.idoox.transport.util.ReadLine;
import com.idoox.transport.util.WriteLine;
import com.idoox.wasp.Constants;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class Headers {
    private Header[] headers;
    private int size;
    private Set names;
    private boolean dirtyNames = true;
    public static byte HT = (byte)9;
    public static byte SPACE = (byte)32;
    public static byte COLON = (byte)58;

    public Headers(Map fromMap) {
        this.headers = new Header[fromMap.size()];
        this.size = 0;
        Iterator i = fromMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.headers[this.size] = new Header((String)entry.getKey(), (String)entry.getValue());
            ++this.size;
        }
    }

    public Headers(int initialSize) {
        this.headers = new Header[initialSize];
        this.size = 0;
    }

    public Set getNames() {
        if (!this.dirtyNames) {
            return this.names;
        }
        this.names = new HashSet(this.size);
        int i = 0;
        while (i < this.size) {
            if (this.headers[i] != null) {
                this.names.add(this.headers[i].name);
            }
            ++i;
        }
        this.names = Collections.unmodifiableSet(this.names);
        this.dirtyNames = false;
        return this.names;
    }

    public String get(String name) {
        int i = 0;
        while (i < this.size) {
            if (this.headers[i] != null && this.headers[i].name.equalsIgnoreCase(name)) {
                return this.headers[i].value;
            }
            ++i;
        }
        return null;
    }

    public static long parseDate(String value) {
        if (value == null) {
            return -1L;
        }
        int colon = value.indexOf(59);
        if (colon < 0) {
            return Date.parse(value);
        }
        return Date.parse(value.substring(0, colon));
    }

    public long getDate(String name) {
        return Headers.parseDate(this.get(name));
    }

    public int getInt(String name) {
        String value = this.get(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public void set(String name, String value) {
        int i = 0;
        while (i < this.size) {
            if (this.headers[i] != null && this.headers[i].name.equalsIgnoreCase(name)) {
                this.headers[i].value = value;
                return;
            }
            ++i;
        }
        this.checkBufferSize();
        this.headers[this.size++] = new Header(name, value);
        this.dirtyNames = true;
    }

    public static String createDate(long value) {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(new Date(value));
    }

    public void setDate(String name, long value) {
        this.set(name, Headers.createDate(value));
    }

    public void setInt(String name, int value) {
        this.set(name, String.valueOf(value));
    }

    public void remove(String name) {
        int i = 0;
        while (i < this.size) {
            if (this.headers[i] != null && this.headers[i].name.equalsIgnoreCase(name)) {
                this.headers[i] = null;
                this.dirtyNames = true;
                break;
            }
            ++i;
        }
        int i2 = this.size - 1;
        while (i2 >= 0) {
            if (this.headers[i2] != null) break;
            --this.size;
            --i2;
        }
    }

    public void clear() {
        this.size = 0;
        this.dirtyNames = true;
    }

    private void add(String name, String value, boolean newLine) {
        int i = this.size - 1;
        while (i >= 0) {
            if (this.headers[i] != null && this.headers[i].name.equalsIgnoreCase(name)) {
                StringBuffer buffer = new StringBuffer(this.headers[i].value.length() + 2 + value.length());
                buffer.append(this.headers[i].value);
                if (newLine) {
                    buffer.append('\r');
                    buffer.append('\n');
                }
                buffer.append(value);
                this.headers[i].value = value = buffer.toString();
                return;
            }
            --i;
        }
        this.checkBufferSize();
        this.headers[this.size++] = new Header(name, value);
        this.dirtyNames = true;
    }

    private void checkBufferSize() {
        if (this.size >= this.headers.length) {
            Header[] newHeaders = new Header[this.headers.length + 10];
            int i = 0;
            while (i < this.headers.length) {
                newHeaders[i] = this.headers[i];
                ++i;
            }
            this.headers = newHeaders;
        }
    }

    public void read(ReadLine input) throws IOException {
        String headerName = null;
        String headerValue = null;
        this.clear();
        while (true) {
            input.read();
            if (input.count == 0) break;
            if (input.buffer[0] == SPACE || input.buffer[0] == HT) {
                if (headerName == null) {
                    throw new IOException("Malformed header line: '" + new String(input.buffer, Constants.UTF_8) + "'");
                }
                headerValue = new String(input.buffer, 0, 0, input.count);
                this.add(headerName, headerValue, false);
                continue;
            }
            int colon = 0;
            while (colon < input.count) {
                if (input.buffer[colon] == COLON) break;
                ++colon;
            }
            if (colon >= input.count) {
                throw new IOException("Malformed header line: '" + new String(input.buffer, Constants.UTF_8) + "'");
            }
            headerName = new String(input.buffer, 0, 0, colon);
            int valueStart = colon + 1;
            while (input.buffer[valueStart] == SPACE || input.buffer[valueStart] == HT) {
                ++valueStart;
            }
            headerValue = new String(input.buffer, 0, valueStart, input.count - valueStart);
            this.add(headerName, headerValue, true);
        }
    }

    public void write(WriteLine output) throws IOException {
        int i = 0;
        while (i < this.size) {
            if (this.headers[i] != null && this.headers[i].name != null && this.headers[i].value != null) {
                output.writeHeader(this.headers[i].name, this.headers[i].value);
            }
            ++i;
        }
        output.write((byte[])null, true);
    }

    class Header {
        public String name;
        public String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

