/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.util;

public class Bytes {
    public static int parseHexInt(byte[] buffer, int off, int length) {
        int value = 0;
        int i = off;
        while (i < off + length) {
            if (buffer[i] >= 48 && buffer[i] <= 57) {
                value = 16 * value + buffer[i] - 48;
            } else if (buffer[i] >= 65 && buffer[i] <= 70) {
                value = 16 * value + buffer[i] - 55;
            } else if (buffer[i] >= 97 && buffer[i] <= 102) {
                value = 16 * value + buffer[i] - 87;
            } else {
                throw new NumberFormatException(new String(buffer, 0, off, length));
            }
            ++i;
        }
        return value;
    }

    public static int parseInt(byte[] buffer, int off, int length) {
        int value = 0;
        int i = off;
        while (i < off + length) {
            if (buffer[i] < 48 || buffer[i] > 57) {
                throw new NumberFormatException(new String(buffer, 0, off, length));
            }
            value = 10 * value + buffer[i] - 48;
            ++i;
        }
        return value;
    }

    public static float parseFloat(byte[] buffer, int off, int length) {
        float value = 0.0f;
        int dot = 0;
        int i = off;
        while (i < off + length) {
            if (buffer[i] >= 48 && buffer[i] <= 57) {
                value = 10.0f * value + (float)buffer[i] - 48.0f;
                if (dot > 0) {
                    ++dot;
                }
            } else if (buffer[i] == 46) {
                dot = 1;
            } else {
                throw new NumberFormatException(new String(buffer, 0, off, length));
            }
            ++i;
        }
        if (dot > 0) {
            return value / (float)(10 * dot);
        }
        return value;
    }

    public static int indexOf(byte[] buffer, int off, int length, byte ch) {
        int i = off;
        while (i < off + length) {
            if (buffer[i] == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

