/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.util;

import com.idoox.transport.util.Headers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Set;
import org.idoox.transport.InputMessage;
import org.idoox.transport.InputMessageWrapper;

public class BufferedInputMessage
extends InputMessageWrapper {
    private static final int BUFFER_RESIZE = 2000;
    private int initialBufferSize;
    private Headers headers;

    public BufferedInputMessage(InputMessage message) {
        this(message, 2000);
    }

    public BufferedInputMessage(InputMessage message, int initialBufferSize) {
        super(message);
        this.initialBufferSize = initialBufferSize;
    }

    /*
     * WARNING - void declaration
     */
    public void fill(boolean bufferHeaders) throws IOException {
        int length;
        if (bufferHeaders) {
            Set headerNames = this.getWrappedMessage().getHeaderNames();
            this.headers = new Headers(headerNames.size());
            while (headerNames.iterator().hasNext()) {
                String name = (String)headerNames.iterator().next();
                this.headers.set(name, this.getWrappedMessage().getStringHeader(name));
            }
        }
        byte[] buffer = new byte[this.initialBufferSize];
        int off = 0;
        while ((length = this.getWrappedStream().read(buffer, off, buffer.length - off)) >= 0) {
            void name;
            if ((off += name) < buffer.length) continue;
            byte[] newBuffer = new byte[buffer.length + 2000];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            buffer = newBuffer;
        }
        this.setWrappedMessage(this);
        this.setWrappedStream(new ByteArrayInputStream(buffer, 0, off));
    }

    public Set getHeaderNames() throws IOException {
        if (this.headers == null) {
            return this.getWrappedMessage().getHeaderNames();
        }
        return this.headers.getNames();
    }

    public String getContentType() throws IOException {
        if (this.headers == null) {
            return this.getWrappedMessage().getContentType();
        }
        return this.headers.get("content-type");
    }

    public String getStringHeader(String name) throws IOException {
        if (this.headers == null) {
            return this.getWrappedMessage().getStringHeader(name);
        }
        return this.headers.get(name);
    }

    public int getIntHeader(String name) throws IOException {
        if (this.headers == null) {
            return this.getWrappedMessage().getIntHeader(name);
        }
        return this.headers.getInt(name);
    }

    public long getDateHeader(String name) throws IOException {
        if (this.headers == null) {
            return this.getWrappedMessage().getDateHeader(name);
        }
        return this.headers.getDate(name);
    }
}

