/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.smtp.client;

import com.idoox.transport.smtp.client.SmtpPool;
import com.idoox.transport.smtp.client.SmtpReadLine;
import com.idoox.transport.util.Headers;
import com.idoox.transport.util.SocketEx;
import com.idoox.transport.util.WriteLine;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.idoox.transport.RawOutputMessage;
import org.idoox.util.RuntimeWrappedException;

public class SmtpMessage
extends RawOutputMessage {
    private SocketEx socket;
    private String from;
    private String deliverTo;
    private Headers headers;
    private boolean committedHeaders = false;
    private int reachedFromDot = 0;
    private static String MAIL_FROM = "MAIL FROM:";
    private static String RCPT_TO = "RCPT TO:";
    private static String DATA = "DATA";
    private static String DOT = "\r\n.";
    private static byte[] DOT_BYTES;
    private boolean closed = false;

    public SmtpMessage(SocketEx socket, String deliverTo, String from) throws IOException {
        super(socket.output);
        this.socket = socket;
        this.deliverTo = deliverTo;
        this.from = from;
        this.headers = new Headers(13);
    }

    public void setStatusCode(int sc) {
        this.setIntHeader("x-wasp-sc", sc);
    }

    public void setStringHeader(String name, String value) {
        if (this.committedHeaders) {
            throw new RuntimeException("Headers already committed");
        }
        this.headers.set(name, value);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.letsGo();
        int i = off;
        while (i < off + len) {
            if (b[i] == DOT_BYTES[this.reachedFromDot]) {
                ++this.reachedFromDot;
                if (this.reachedFromDot == DOT_BYTES.length) {
                    this.getWrappedStream().write(b, off, i - off);
                    len -= i - off;
                    off = i;
                    this.getWrappedStream().write(46);
                    this.reachedFromDot = 0;
                }
            } else {
                this.reachedFromDot = 0;
                if (b[i] == 10) {
                    this.getWrappedStream().write(b, off, i - off);
                    len -= i - off;
                    off = i;
                    this.getWrappedStream().write(13);
                }
            }
            ++i;
        }
        this.getWrappedStream().write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void flush() throws IOException {
        this.letsGo();
        this.getWrappedStream().flush();
    }

    public void close() throws IOException {
        block5: {
            if (this.closed) {
                return;
            }
            this.letsGo();
            this.closed = true;
            SmtpReadLine readLine = ((SmtpPool.SmtpSocketData)this.socket.ext).readLine;
            WriteLine writeLine = ((SmtpPool.SmtpSocketData)this.socket.ext).writeLine;
            try {
                writeLine.write(DOT, true);
                this.socket.output.flush();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
            }
            while (!readLine.smtpRead()) {
            }
            {
                break block5;
            }
            while (!readLine.smtpRead()) {
            }
            throw throwable;
        }
        this.socket.release();
    }

    void letsGo() throws IOException {
        if (!this.committedHeaders) {
            StringBuffer buffer = new StringBuffer(1024);
            int i = 0;
            while (i < 2) {
                SmtpReadLine readLine = ((SmtpPool.SmtpSocketData)this.socket.ext).readLine;
                WriteLine writeLine = ((SmtpPool.SmtpSocketData)this.socket.ext).writeLine;
                try {
                    buffer.setLength(0);
                    buffer.append(MAIL_FROM);
                    if (this.from != null) {
                        buffer.append('<');
                        buffer.append(this.from);
                        buffer.append('>');
                    }
                    writeLine.write(buffer.toString(), true);
                    this.socket.output.flush();
                    while (!readLine.smtpRead()) {
                    }
                    StringTokenizer tokenizer = new StringTokenizer(this.deliverTo, ",", false);
                    while (tokenizer.hasMoreTokens()) {
                        buffer.setLength(0);
                        buffer.append(RCPT_TO);
                        buffer.append('<');
                        buffer.append(tokenizer.nextToken());
                        buffer.append('>');
                        writeLine.write(buffer.toString(), true);
                        this.socket.output.flush();
                        while (!readLine.smtpRead()) {
                        }
                    }
                    writeLine.write(DATA, true);
                    this.socket.output.flush();
                    while (!readLine.smtpRead()) {
                    }
                    this.headers.write(writeLine);
                    this.committedHeaders = true;
                    break;
                }
                catch (IOException e) {
                    if (i == 0) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException _e) {
                            // empty catch block
                        }
                    } else {
                        throw e;
                    }
                    this.socket.open();
                    this.setWrappedStream(this.socket.output);
                    ++i;
                }
            }
        }
    }

    static {
        try {
            DOT_BYTES = DOT.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
    }
}

