/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.smtp.client;

import com.idoox.transport.mail.MailURI;
import com.idoox.transport.smtp.client.SmtpMessage;
import com.idoox.transport.util.SocketEx;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.URI;
import org.idoox.transport.client.ClientConnection;
import org.systinet.wasp.Version;

public class SmtpConnection
implements ClientConnection {
    private SocketEx socket;
    private MailURI endpoint;
    private TransportMethod method;
    private InputMessage response;
    private OutputMessage request;

    public SmtpConnection(SocketEx socket, URI endpoint, TransportMethod method) throws IOException {
        if (method == TransportMethod.POST) {
            String from = endpoint.getParameter("from");
            String deliverTo = endpoint.getPath();
            if (deliverTo != null && deliverTo.length() > 0 && deliverTo.charAt(0) == '/') {
                deliverTo = deliverTo.substring(1);
            }
            if (endpoint.getParameter("to") != null) {
                deliverTo = deliverTo == null || deliverTo.length() <= 0 ? endpoint.getParameter("to") : deliverTo + "," + endpoint.getParameter("to");
            }
            if (deliverTo == null) {
                throw new IOException("Recipient have to be specified.");
            }
            this.request = new SmtpMessage(socket, deliverTo, from);
            this.response = null;
            this.request.setStringHeader("User-Agent", Version.getVersion());
            if (from != null) {
                this.request.setStringHeader("From", from);
            }
            if (deliverTo != null) {
                this.request.setStringHeader("To", deliverTo);
            }
            this.request.setStringHeader("x-wasp-method", method.toString());
            Set parameterNames = endpoint.getParameterNames();
            if (parameterNames != null) {
                Iterator i = parameterNames.iterator();
                while (i.hasNext()) {
                    String paramName = (String)i.next();
                    String paramValue = endpoint.getParameter(paramName);
                    this.request.setStringHeader(paramName, paramValue);
                }
            }
        } else {
            throw new IOException("Method " + method + " isn't supported for SMTP transport");
        }
        this.socket = socket;
        this.endpoint = new MailURI(endpoint);
        this.method = method;
    }

    public void setTimeout(int time) throws IOException {
        this.socket.setTimeout(time);
    }

    public InputMessage getInputMessage() {
        return this.response;
    }

    public void setInputMessage(InputMessage message) {
        this.response = message;
    }

    public OutputMessage getOutputMessage() {
        return this.request;
    }

    public void setOutputMessage(OutputMessage message) {
        this.request = message;
    }

    public TransportMethod getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.endpoint;
    }
}

