/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.pop.client;

import com.idoox.transport.pop.client.PopPool;
import com.idoox.transport.pop.client.PopReadLine;
import com.idoox.transport.util.Headers;
import com.idoox.transport.util.ReadLine;
import com.idoox.transport.util.SocketEx;
import com.idoox.transport.util.WriteLine;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.idoox.transport.RawInputMessage;
import org.idoox.util.RuntimeWrappedException;

public class PopMessage
extends RawInputMessage {
    private SocketEx socket;
    private Headers headers;
    private int statusCode = -1;
    private boolean endOfStream = false;
    private int reachedFromDot = 0;
    private int missedIndex = 0;
    private int missedByte = -1;
    private static String RETR = "RETR ";
    private static String DELE = "DELE ";
    private static String DOT = "\r\n.";
    private static byte[] DOT_BYTES;

    public PopMessage(SocketEx socket) throws IOException {
        super(socket.input);
        this.socket = socket;
        int length = ((PopPool.PopSocketData)socket.ext).length;
        int index = ((PopPool.PopSocketData)socket.ext).index;
        if (length <= 0 || index > length) {
            this.statusCode = 404;
            this.endOfStream = true;
            this.socket.close();
            this.socket = null;
            return;
        }
        int i = 0;
        while (i < 2) {
            PopReadLine readLine = ((PopPool.PopSocketData)socket.ext).readLine;
            WriteLine writeLine = ((PopPool.PopSocketData)socket.ext).writeLine;
            try {
                String retr = RETR + index;
                writeLine.write(retr, true);
                socket.output.flush();
                readLine.popRead();
                break;
            }
            catch (IOException e) {
                if (i == 0) {
                    try {
                        socket.close();
                    }
                    catch (IOException _e) {
                        // empty catch block
                    }
                } else {
                    throw e;
                }
                this.socket.open();
                this.setWrappedStream(this.socket.input);
                ++i;
            }
        }
        this.headers = new Headers(13);
        this.headers.read(new ReadLine(this));
    }

    public int getStatusCode() throws IOException {
        if (this.headers != null) {
            int sc = this.getIntHeader("x-wasp-sc");
            if (sc == -1) {
                sc = 200;
            }
            return sc;
        }
        return this.statusCode;
    }

    public Set getHeaderNames() {
        if (this.headers != null) {
            return this.headers.getNames();
        }
        return null;
    }

    public String getStringHeader(String name) {
        if (this.headers != null) {
            return this.headers.get(name);
        }
        return null;
    }

    public int read() throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        if (this.reachedFromDot < 0) {
            ++this.reachedFromDot;
            return DOT_BYTES[this.missedIndex++];
        }
        int next = this.missedByte;
        if (next >= 0) {
            this.missedByte = -1;
        } else {
            next = this.getWrappedStream().read();
        }
        if (this.reachedFromDot == DOT_BYTES.length) {
            if (next == ReadLine.CR || next == ReadLine.LF) {
                if (next == ReadLine.CR) {
                    this.getWrappedStream().read();
                }
                this.reachedFromDot = 0;
                this.endOfStream();
                return -1;
            }
            if (next == DOT_BYTES[2]) {
                this.reachedFromDot = -DOT_BYTES.length;
                this.missedIndex = 0;
                return this.read();
            }
            throw new IOException("Malformed escape sequence: " + DOT + (char)next);
        }
        if (next == DOT_BYTES[this.reachedFromDot]) {
            ++this.reachedFromDot;
            return this.read();
        }
        if (this.reachedFromDot > 0) {
            this.reachedFromDot = -this.reachedFromDot;
            this.missedIndex = 0;
            this.missedByte = next;
            return this.read();
        }
        this.reachedFromDot = 0;
        return next;
    }

    public void endOfStream() throws IOException {
        this.endOfStream = true;
        PopReadLine readLine = ((PopPool.PopSocketData)this.socket.ext).readLine;
        WriteLine writeLine = ((PopPool.PopSocketData)this.socket.ext).writeLine;
        int index = ((PopPool.PopSocketData)this.socket.ext).index++;
        String delete = DELE + index;
        writeLine.write(delete, true);
        this.socket.output.flush();
        readLine.popRead();
    }

    public int read(byte[] b) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        int ch = this.read();
        if (ch == -1) {
            return -1;
        }
        b[off] = (byte)ch;
        int num = 1;
        try {
            while (num < len && (ch = this.read()) != -1) {
                b[off + num] = (byte)ch;
                ++num;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return num;
    }

    public void close() throws IOException {
        if (this.socket != null) {
            while (this.read() >= 0) {
            }
            this.socket.release();
        }
    }

    static {
        try {
            DOT_BYTES = DOT.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
    }
}

