/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.pop.client;

import com.idoox.transport.pop.client.PopMessage;
import com.idoox.transport.util.SocketEx;
import java.io.IOException;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.URI;
import org.idoox.transport.client.ClientConnection;

public class PopConnection
implements ClientConnection {
    private SocketEx socket;
    private URI endpoint;
    private TransportMethod method;
    private InputMessage response;
    private OutputMessage request;

    public PopConnection(SocketEx socket, URI endpoint, TransportMethod method) throws IOException {
        if (method != TransportMethod.GET) {
            throw new IOException("Method " + method + " isn't supported for POP transport");
        }
        this.response = new PopMessage(socket);
        this.request = null;
        this.socket = socket;
        this.endpoint = endpoint;
        this.method = method;
    }

    public void setTimeout(int time) throws IOException {
        this.socket.setTimeout(time);
    }

    public InputMessage getInputMessage() {
        return this.response;
    }

    public void setInputMessage(InputMessage message) {
        this.response = message;
    }

    public OutputMessage getOutputMessage() {
        return this.request;
    }

    public void setOutputMessage(OutputMessage message) {
        this.request = message;
    }

    public TransportMethod getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.endpoint;
    }
}

