/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.pop.client;

import com.idoox.transport.pop.client.PopConnection;
import com.idoox.transport.pop.client.PopPool;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.idoox.config.Configurable;
import org.idoox.transport.Transport;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.URI;
import org.idoox.transport.client.ClientConnection;
import org.idoox.transport.client.Endpoint;
import org.idoox.transport.config.PopClientConfig;
import org.idoox.transport.server.ConnectionHandler;

public class PopClient
implements Transport,
VetoableChangeListener {
    private static HashSet methods = new HashSet(2);
    private static int defaultPort;
    private Configurable config;
    private int defaultTimeout = -1;
    private int updateInterval = -1;
    private static int DEFAULT_UPDATE_INTERVAL;
    private PopPool pool;
    static /* synthetic */ Class class$org$idoox$transport$config$PopClientConfig;

    public synchronized void load(Configurable c) {
        PopClientConfig config = (PopClientConfig)c.narrow(class$org$idoox$transport$config$PopClientConfig == null ? (class$org$idoox$transport$config$PopClientConfig = PopClient.class$("org.idoox.transport.config.PopClientConfig")) : class$org$idoox$transport$config$PopClientConfig);
        this.config = c;
        try {
            this.defaultTimeout = config.getDefaultTimeout();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.updateInterval = config.getUpdateInterval();
        }
        catch (Exception e) {
            this.updateInterval = DEFAULT_UPDATE_INTERVAL;
        }
        c.addVetoableChangeListener(this);
        this.pool = new PopPool(13);
    }

    public synchronized void destroy() {
        if (this.pool != null) {
            this.pool.clear();
        }
        if (this.config != null) {
            this.config.removeVetoableChangeListener(this);
        }
    }

    public void start(URI endpoint) {
    }

    public void stop() {
    }

    public boolean isStarted() {
        return false;
    }

    public ConnectionHandler setHandler(ConnectionHandler handler) {
        return null;
    }

    public synchronized ClientConnection newConnection(URI endpoint, TransportMethod method, Map properties) throws IOException {
        if (this.pool == null) {
            return null;
        }
        if (properties == null) {
            throw new IOException("No password found for " + endpoint);
        }
        String pass = (String)properties.get("mail.input.password");
        if (pass == null || pass.length() == 0) {
            throw new IOException("No password found for " + endpoint);
        }
        int port = endpoint.getPort();
        if (port <= 0) {
            port = defaultPort;
        }
        if (endpoint.getHost() == null) {
            throw new IOException("Server name have to be specified for POP transport");
        }
        return new PopConnection(this.pool.get(endpoint.getUserinfo(), endpoint.getHost(), port, this.defaultTimeout, this.updateInterval, properties), endpoint, method);
    }

    public Set getMethods() {
        return methods;
    }

    public int getType() {
        return 2;
    }

    public String getLocalPath(URI endpoint) {
        return null;
    }

    public Endpoint[] getAbsolutePath(String path) {
        return null;
    }

    public synchronized void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        if (event.getPropertyName().equals("defaultTimeout")) {
            this.defaultTimeout = event.getNewValue() != null ? (Integer)event.getNewValue() : -1;
        } else if (event.getPropertyName().equals("updateInterval")) {
            this.updateInterval = event.getNewValue() != null ? (Integer)event.getNewValue() : DEFAULT_UPDATE_INTERVAL;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        methods.add(TransportMethod.GET);
        defaultPort = 110;
        DEFAULT_UPDATE_INTERVAL = 60000;
    }
}

