/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.http.server;

import com.mortbay.HTTP.HttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import org.idoox.transport.RawOutputMessage;

public class JettyResponse
extends RawOutputMessage {
    protected HttpResponse response;
    private boolean commitedHeaders = false;

    public JettyResponse(HttpResponse response) {
        super((OutputStream)response.getOutputStream());
        this.response = response;
    }

    public void setStatusCode(int sc) {
        this.response.setStatus(sc);
    }

    public void setStringHeader(String name, String value) {
        this.response.setField(name, value);
    }

    public void write(byte[] b) throws IOException {
        if (!this.commitedHeaders) {
            this.response.commitHeader();
            this.commitedHeaders = true;
        }
        this.getWrappedStream().write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.commitedHeaders) {
            this.response.commitHeader();
            this.commitedHeaders = true;
        }
        this.getWrappedStream().write(b, off, len);
    }

    public void write(int b) throws IOException {
        if (!this.commitedHeaders) {
            this.response.commitHeader();
            this.commitedHeaders = true;
        }
        this.getWrappedStream().write(b);
    }

    public void flush() throws IOException {
        if (!this.commitedHeaders) {
            this.response.commitHeader();
            this.commitedHeaders = true;
        }
    }

    public void close() throws IOException {
        if (!this.commitedHeaders) {
            this.response.commitHeader();
            this.commitedHeaders = true;
        }
        if (!this.response.isCommitted()) {
            this.response.commit();
        }
        this.response.complete();
        this.response.getConnection().getOutputStream().flush(this.response.getConnection().getOutputStream().isChunking());
    }
}

