/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.http.server;

import com.idoox.transport.http.server.JettyRequest;
import com.idoox.transport.http.server.JettyResponse;
import com.idoox.transport.http.server.JettyURI;
import com.mortbay.HTTP.HttpConnection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.URI;
import org.idoox.transport.server.ServerConnection;

public class JettyConnection
implements ServerConnection {
    private InputMessage request;
    private OutputMessage response;
    private JettyURI endpoint;
    private HttpConnection connection;

    public JettyConnection(JettyURI endpoint, JettyRequest request, JettyResponse response) {
        this.endpoint = endpoint;
        this.request = request;
        this.response = response;
        this.connection = request.getConnection();
    }

    public InputMessage getInputMessage() {
        return this.request;
    }

    public void setInputMessage(InputMessage message) {
        this.request = message;
    }

    public OutputMessage getOutputMessage() {
        return this.response;
    }

    public void setOutputMessage(OutputMessage message) {
        this.response = message;
    }

    public URI getURI() {
        return this.endpoint;
    }

    public String getClientAddress() {
        if (this.connection != null) {
            return this.connection.getRemoteAddr().getHostName();
        }
        return null;
    }

    public TransportMethod getMethod() {
        if (this.connection != null) {
            return TransportMethod.fromString(this.connection.getRequest().getMethod());
        }
        return null;
    }
}

