/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.http.server;

import com.idoox.debug.Category;
import com.idoox.transport.http.server.JettyConnection;
import com.idoox.transport.http.server.JettyRequest;
import com.idoox.transport.http.server.JettyResponse;
import com.idoox.transport.http.server.JettyURI;
import com.idoox.transport.util.Resolve;
import com.mortbay.HTTP.Handler.NotFoundHandler;
import com.mortbay.HTTP.Handler.NullHandler;
import com.mortbay.HTTP.HandlerContext;
import com.mortbay.HTTP.HttpHandler;
import com.mortbay.HTTP.HttpListener;
import com.mortbay.HTTP.HttpRequest;
import com.mortbay.HTTP.HttpResponse;
import com.mortbay.HTTP.HttpServer;
import com.mortbay.HTTP.SocketListener;
import com.mortbay.Util.Code;
import com.mortbay.Util.Log;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.idoox.config.Configurable;
import org.idoox.transport.Transport;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.TransportStartException;
import org.idoox.transport.URI;
import org.idoox.transport.client.ClientConnection;
import org.idoox.transport.client.Endpoint;
import org.idoox.transport.config.HttpServerConfig;
import org.idoox.transport.server.ConnectionHandler;
import org.idoox.util.RuntimeWrappedException;

public class Jetty
implements Transport,
VetoableChangeListener {
    protected Category log = Category.getCategory("com.idoox.transport.http.server");
    protected Endpoint serverEndpoint;
    protected String hostName;
    protected HttpServer server;
    protected Configurable config;
    protected SocketListener socketListener;
    protected int minThreads;
    protected int maxThreads;
    protected int maxIdleTime;
    protected int maxReadTime;
    private ConnectionHandler handler;
    private static HashSet methods = new HashSet(4);
    private boolean stopping = false;
    static /* synthetic */ Class class$org$idoox$transport$config$HttpServerConfig;

    public Jetty() {
        String debug = null;
        try {
            debug = System.getProperty("wasp.jetty.debug");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        if (debug != null) {
            Code.setDebug((boolean)true);
            try {
                Code.setVerbose((int)Integer.parseInt(debug));
            }
            catch (NumberFormatException e) {
                Code.setVerbose((int)99);
            }
        } else {
            Log.instance().disableLog();
        }
        this.createNewSocketListener();
    }

    public synchronized void load(Configurable c) {
        String hostName;
        HttpServerConfig config = (HttpServerConfig)c.narrow(class$org$idoox$transport$config$HttpServerConfig == null ? (class$org$idoox$transport$config$HttpServerConfig = Jetty.class$("org.idoox.transport.config.HttpServerConfig")) : class$org$idoox$transport$config$HttpServerConfig);
        int port = -1;
        try {
            port = config.getPort();
        }
        catch (Exception e) {
            this.log.warn("Config does not contain server port for " + config.getName());
        }
        try {
            this.minThreads = config.getMinThreads();
        }
        catch (Exception e) {
            this.minThreads = -1;
        }
        try {
            this.maxThreads = config.getMaxThreads();
        }
        catch (Exception e) {
            this.maxThreads = -1;
        }
        try {
            this.maxIdleTime = config.getMaxIdleTime();
        }
        catch (Exception e) {
            this.maxIdleTime = -1;
        }
        try {
            this.maxReadTime = config.getMaxReadTime();
        }
        catch (Exception e) {
            this.maxReadTime = -1;
        }
        String contextPath = config.getContextPath();
        if (contextPath != null && contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        if ((hostName = (this.hostName = config.getHostName())) == null) {
            try {
                hostName = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
            }
            catch (UnknownHostException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        String nullString = null;
        this.serverEndpoint = new Endpoint(this.socketListener.getDefaultScheme(), null, hostName, port, contextPath, "/", null, nullString);
        c.addVetoableChangeListener(this);
        this.config = c;
    }

    public synchronized void destroy() {
        this.stop();
        this.config.removeVetoableChangeListener(this);
    }

    public synchronized void start(URI endpoint) throws TransportStartException {
        if (endpoint != null) {
            try {
                this.serverEndpoint = new Endpoint(endpoint.toExternalForm());
                String path = this.serverEndpoint.getPath();
                if (path != null && path.endsWith("/")) {
                    this.serverEndpoint.setContextPath(path.substring(0, path.length() - 1));
                } else {
                    this.serverEndpoint.setContextPath(path);
                }
                this.serverEndpoint.setPath("/");
                if (this.hostName != null) {
                    this.serverEndpoint.setHost(this.hostName);
                }
            }
            catch (MalformedURLException e) {
                throw new TransportStartException(e);
            }
        }
        if (this.serverEndpoint.getPort() <= 0) {
            throw new TransportStartException("Couldn't start '" + this.serverEndpoint + "' server: port isn't specified");
        }
        if (this.server != null && this.server.isStarted()) {
            this.stop();
        }
        this.log.info("Starting '" + this.serverEndpoint + "' server");
        this.server = new HttpServer();
        String contextPath = this.serverEndpoint.getContextPath();
        if (contextPath == null) {
            contextPath = "";
        }
        HandlerContext context = this.server.addContext(null, contextPath);
        context.addHandler((HttpHandler)new WaspHttpHandler());
        context.addHandler((HttpHandler)new NotFoundHandler());
        this.createNewSocketListener();
        this.server.addListener((HttpListener)this.socketListener);
        this.socketListener.setPort(this.serverEndpoint.getPort());
        if (this.hostName != null) {
            try {
                this.socketListener.setHost(this.hostName);
            }
            catch (UnknownHostException e) {
                throw new TransportStartException(e);
            }
        }
        if (this.minThreads != -1) {
            this.socketListener.setMinThreads(this.minThreads);
        }
        if (this.maxThreads != -1) {
            this.socketListener.setMaxThreads(this.maxThreads);
        }
        if (this.maxIdleTime != -1) {
            this.socketListener.setMaxIdleTimeMs(this.maxIdleTime);
        }
        if (this.maxReadTime != -1) {
            this.socketListener.setMaxReadTimeMs(this.maxReadTime);
        }
        try {
            this.server.start();
        }
        catch (Exception e) {
            this.stop(false);
            if (e.getMessage() != null && e.getMessage().indexOf("Address already in use") != -1) {
                StringBuffer sb = new StringBuffer();
                sb.append("Error occurred while attempting to bind a socket to a local address and port ");
                sb.append(this.serverEndpoint.getPort());
                sb.append(".\nProbably, the port ");
                sb.append(this.serverEndpoint.getPort());
                sb.append(" is in use, or the requested local address could not be assigned. ");
                sb.append("\nPlease check if another instance of Systinet Server or another program is using this port.");
                throw new TransportStartException(sb.toString(), e);
            }
            throw new TransportStartException(e);
        }
    }

    protected void createNewSocketListener() throws RuntimeWrappedException {
        try {
            this.socketListener = new SocketListener();
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public void stop() {
        this.stop(true);
    }

    private synchronized void stop(boolean logIt) {
        this.stopping = true;
        if (this.server == null || !this.server.isStarted()) {
            return;
        }
        if (logIt) {
            this.log.info("Stopping '" + this.serverEndpoint + "' server");
        }
        try {
            this.server.stop();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.server = null;
        this.stopping = false;
    }

    public synchronized boolean isStarted() {
        return !this.stopping && this.server != null && this.server.isStarted();
    }

    public synchronized ConnectionHandler setHandler(ConnectionHandler handler) {
        ConnectionHandler oldHandler = this.handler;
        this.handler = handler;
        return oldHandler;
    }

    public Set getMethods() {
        return methods;
    }

    public ClientConnection newConnection(URI endpoint, TransportMethod method, Map properties) {
        return null;
    }

    public int getType() {
        return 1;
    }

    public String getLocalPath(URI endpoint) {
        if (this.serverEndpoint.getPort() != endpoint.getPort()) {
            return null;
        }
        if (!Resolve.equals(this.serverEndpoint.getHost(), endpoint.getHost())) {
            return null;
        }
        String path = endpoint.getPath();
        if (endpoint.getContextPath() != null) {
            path = endpoint.getContextPath() + path;
        }
        if (!path.startsWith(this.serverEndpoint.getPath())) {
            return null;
        }
        return path.substring(this.serverEndpoint.getPath().length() - 1);
    }

    public Endpoint[] getAbsolutePath(String path) throws MalformedURLException {
        return new Endpoint[]{new Endpoint(this.serverEndpoint, path)};
    }

    public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        if (event.getPropertyName().equals("port")) {
            if (event.getNewValue() == null) {
                this.log.warn("Config does not contain server port for " + this.config.getName());
                this.serverEndpoint.setPort(-1);
            } else {
                this.serverEndpoint.setPort((Integer)event.getNewValue());
            }
        } else if (event.getPropertyName().equals("minThreads")) {
            if (event.getNewValue() != null) {
                this.minThreads = (Integer)event.getNewValue();
            }
            if (this.minThreads != -1) {
                this.socketListener.setMinThreads(this.minThreads);
            }
        } else if (event.getPropertyName().equals("maxThreads")) {
            if (event.getNewValue() != null) {
                this.maxThreads = (Integer)event.getNewValue();
            }
            if (this.maxThreads != -1) {
                this.socketListener.setMaxThreads(this.maxThreads);
            }
        } else if (event.getPropertyName().equals("maxIdleTime")) {
            if (event.getNewValue() != null) {
                this.maxIdleTime = (Integer)event.getNewValue();
            }
            if (this.maxIdleTime != -1) {
                this.socketListener.setMaxIdleTimeMs(this.maxIdleTime);
            }
        } else if (event.getPropertyName().equals("contextPath")) {
            String contextPath = (String)event.getNewValue();
            if (contextPath != null && contextPath.endsWith("/")) {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
            this.serverEndpoint.setContextPath(contextPath);
        } else if (event.getPropertyName().equals("hostName")) {
            this.hostName = (String)event.getNewValue();
            if (this.hostName != null) {
                this.serverEndpoint.setHost(this.hostName);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        methods.add(TransportMethod.POST);
        methods.add(TransportMethod.GET);
        methods.add(TransportMethod.PUT);
        methods.add(TransportMethod.DELETE);
    }

    class WaspHttpHandler
    extends NullHandler {
        WaspHttpHandler() {
        }

        public void handle(String pathInContext, HttpRequest request, HttpResponse response) {
            if (Jetty.this.handler == null) {
                return;
            }
            if (Jetty.this.stopping || Jetty.this.server == null || !Jetty.this.server.isStarted()) {
                return;
            }
            TransportMethod method = TransportMethod.fromString(request.getMethod());
            try {
                if (method == TransportMethod.POST) {
                    Jetty.this.handler.handlePost(new JettyConnection(new JettyURI(request, Jetty.this.serverEndpoint.getContextPath()), new JettyRequest(request), new JettyResponse(response)));
                } else if (method == TransportMethod.GET) {
                    Jetty.this.handler.handleGet(new JettyConnection(new JettyURI(request, Jetty.this.serverEndpoint.getContextPath()), new JettyRequest(request), new JettyResponse(response)));
                } else if (method == TransportMethod.PUT) {
                    Jetty.this.handler.handlePut(new JettyConnection(new JettyURI(request, Jetty.this.serverEndpoint.getContextPath()), new JettyRequest(request), new JettyResponse(response)));
                } else if (method == TransportMethod.DELETE) {
                    Jetty.this.handler.handleDelete(new JettyConnection(new JettyURI(request, Jetty.this.serverEndpoint.getContextPath()), new JettyRequest(request), new JettyResponse(response)));
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
    }
}

