/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.http.client;

import com.idoox.transport.http.client.HttpRequest;
import com.idoox.transport.http.client.HttpResponse;
import com.idoox.transport.util.SocketEx;
import java.io.IOException;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.URI;
import org.idoox.transport.client.ClientConnection;

public class HttpConnection
implements ClientConnection {
    private SocketEx socket;
    private URI endpoint;
    private TransportMethod method;
    private InputMessage response;
    private OutputMessage request;

    public HttpConnection(SocketEx socket, URI endpoint, TransportMethod method, boolean requestChunking) throws IOException {
        if (method == TransportMethod.POST) {
            this.request = this.newHttpRequest(socket, endpoint, method, requestChunking, false);
            this.response = this.newHttpResponse(socket, (HttpRequest)this.request, false);
        } else if (method == TransportMethod.GET) {
            this.request = this.newHttpRequest(socket, endpoint, method, requestChunking, false);
            this.response = this.newHttpResponse(socket, (HttpRequest)this.request, true);
        } else if (method == TransportMethod.PUT) {
            this.request = this.newHttpRequest(socket, endpoint, method, requestChunking, false);
            this.response = this.newHttpResponse(socket, (HttpRequest)this.request, false);
        } else if (method == TransportMethod.DELETE) {
            this.request = this.newHttpRequest(socket, endpoint, method, requestChunking, false);
            this.response = this.newHttpResponse(socket, (HttpRequest)this.request, true);
        } else {
            throw new IOException("Method " + method + " isn't supported for HTTP transport");
        }
        this.socket = socket;
        this.endpoint = endpoint;
        this.method = method;
    }

    protected HttpRequest newHttpRequest(SocketEx socket, URI endpoint, TransportMethod method, boolean chunking, boolean checkResponse) throws IOException {
        return new HttpRequest(socket, endpoint, method, chunking, checkResponse);
    }

    protected HttpResponse newHttpResponse(SocketEx socket, HttpRequest request, boolean finishRequest) {
        return new HttpResponse(socket, request, finishRequest);
    }

    public void setTimeout(int time) throws IOException {
        this.socket.setTimeout(time);
    }

    public InputMessage getInputMessage() {
        return this.response;
    }

    public void setInputMessage(InputMessage message) {
        this.response = message;
    }

    public OutputMessage getOutputMessage() {
        return this.request;
    }

    public void setOutputMessage(OutputMessage message) {
        this.request = message;
    }

    public TransportMethod getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.endpoint;
    }
}

