/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.http;

import com.idoox.transport.util.Bytes;
import com.idoox.transport.util.ReadLine;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkableInputStream
extends FilterInputStream {
    private boolean chunking = false;
    private boolean haveLength = false;
    private int length = -1;
    private int mark = -1;
    public ReadLine line;

    public ChunkableInputStream(InputStream rawInput) {
        super(rawInput);
        this.line = new ReadLine(rawInput);
    }

    public InputStream getRawStream() {
        return this.in;
    }

    public void setRawStream(InputStream rawInput) {
        this.in = rawInput;
        this.line.setInputStream(rawInput);
    }

    public boolean isChunking() {
        return this.chunking;
    }

    public void setChunking(boolean chunking) {
        this.chunking = chunking;
    }

    public void setContentLength(int length) {
        this.length = length;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public boolean isHaveLength() {
        return this.haveLength;
    }

    public void setHaveLength(boolean haveLength) {
        this.haveLength = haveLength;
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.haveLength) {
            return this.in.read(b, off, len);
        }
        aux_len = 0;
        aux_readed = 0;
        max_len = 0;
        if (this.length == 0 && this.initChunk() == -1) {
            return -1;
        }
        max_len = len < this.length ? len : this.length;
        aux_readed = this.in.read(b, off, max_len);
        if (aux_readed == -1) {
            return -1;
        }
        if (aux_readed != max_len) ** GOTO lbl17
        this.length -= max_len;
        return max_len;
        while ((aux_len += aux_readed) < max_len) {
            aux_readed = this.in.read(b, off + aux_len, max_len - aux_len);
lbl17:
            // 2 sources

            if (aux_readed != -1) continue;
        }
        this.length -= aux_len;
        return aux_len;
    }

    public long skip(long toskip) throws IOException {
        if (!this.haveLength) {
            return this.in.skip(toskip);
        }
        long ret = 0L;
        while (ret < toskip) {
            if (this.length == 0 && this.initChunk() == -1) {
                return ret;
            }
            long skip = toskip - ret < (long)this.length ? toskip - ret : (long)this.length;
            long skipped = this.in.skip(skip);
            if (skipped == 0L) {
                return ret;
            }
            this.length = (int)((long)this.length - skipped);
            ret += skipped;
        }
        return ret;
    }

    public int read() throws IOException {
        if (!this.haveLength) {
            return this.in.read();
        }
        if (this.length == 0 && this.initChunk() == -1) {
            return -1;
        }
        int ch = this.in.read();
        --this.length;
        return ch;
    }

    private int initChunk() throws IOException {
        if (this.length == 0) {
            if (!this.chunking) {
                return -1;
            }
            while (this.line.read() <= 0) {
            }
            int i = 0;
            while (i < this.line.count) {
                if (this.line.buffer[i] == 59 || this.line.buffer[i] == 32) break;
                ++i;
            }
            this.length = Bytes.parseHexInt(this.line.buffer, 0, i);
            if (this.length == 0) {
                this.line.read();
                this.chunking = false;
                return -1;
            }
        }
        return this.length;
    }

    public void close() throws IOException {
        while (this.read() >= 0) {
        }
        this.chunking = false;
        this.length = 0;
    }

    public void mark(int readlimit) {
        this.mark = this.length;
        super.mark(readlimit);
    }

    public void reset() throws IOException {
        this.length = this.mark;
        super.reset();
    }
}

