/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.dime;

import com.idoox.transport.util.Headers;
import java.io.IOException;
import java.util.Set;
import org.idoox.transport.InputMessage;
import org.idoox.transport.InputMessageWrapper;

public class DIMEInputMessage
extends InputMessageWrapper {
    private static final int MAX_ID_LENGTH = 2048;
    private static final int MAX_TYPE_LENGTH = 2048;
    private boolean dimeMessage = false;
    private static final int MIN_HEADER_LENGTH = 12;
    private byte[] header = new byte[12];
    private int dataLength = 0;
    private int dataPadding = 0;
    private boolean moreChunks = false;
    private boolean messageEnd = false;
    private boolean messageBeginning = true;
    private Headers headers;
    private boolean mainPart = true;
    private String multipartType;

    public DIMEInputMessage(InputMessage message) {
        super(message);
    }

    public Set getHeaderNames() throws IOException {
        if (this.dimeMessage && !this.mainPart) {
            return this.headers.getNames();
        }
        return super.getHeaderNames();
    }

    public String getContentType() throws IOException {
        if (this.dimeMessage && !this.mainPart) {
            return this.headers.get("content-type");
        }
        return super.getContentType();
    }

    public String getStringHeader(String name) throws IOException {
        if (this.dimeMessage && !this.mainPart) {
            String localHeader = this.headers.get(name);
            if (localHeader != null) {
                return localHeader;
            }
            return super.getStringHeader(name);
        }
        return super.getStringHeader(name);
    }

    public int getIntHeader(String name) throws IOException {
        if (this.dimeMessage && !this.mainPart) {
            return this.headers.getInt(name);
        }
        return super.getIntHeader(name);
    }

    public long getDateHeader(String name) throws IOException {
        if (this.dimeMessage && !this.mainPart) {
            return this.headers.getDate(name);
        }
        return super.getDateHeader(name);
    }

    public String getMultipartType() throws IOException {
        if (this.multipartType != null) {
            return this.multipartType;
        }
        this.multipartType = super.getMultipartType();
        String ct = this.multipartType != null ? this.multipartType : super.getContentType();
        this.dimeMessage = "application/dime".equalsIgnoreCase(ct);
        if (this.dimeMessage) {
            this.headers = new Headers(3);
            this.multipartType = ct;
        }
        return this.multipartType;
    }

    public boolean nextPart() throws IOException {
        if (this.dimeMessage) {
            while (this.moreChunks) {
                this.blockingSkip(this.dataLength + this.dataPadding);
                this.headers.clear();
                if (this.readNextRecordHeader()) continue;
                return false;
            }
            this.blockingSkip(this.dataLength + this.dataPadding);
            this.headers.clear();
            this.mainPart = false;
            return this.readNextRecordHeader();
        }
        return super.nextPart();
    }

    public int read(byte[] b) throws IOException {
        if (this.dimeMessage) {
            return this.read(b, 0, b.length);
        }
        return super.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.dimeMessage) {
            int total = 0;
            while (len > 0) {
                if (this.dataLength == 0) {
                    if (this.moreChunks) {
                        this.readNextChunk();
                    } else if (total == 0) {
                        return -1;
                    }
                    if (this.dataLength == 0) {
                        return total;
                    }
                }
                int toRead = len < this.dataLength ? len : this.dataLength;
                int read = super.read(b, off, toRead);
                this.dataLength -= read;
                total += read;
                if (read < toRead) {
                    return total;
                }
                len -= read;
                off += read;
            }
            return total;
        }
        return super.read(b, off, len);
    }

    public int read() throws IOException {
        if (this.dimeMessage) {
            if (this.dataLength == 0) {
                if (this.moreChunks) {
                    this.readNextChunk();
                }
                if (this.dataLength == 0) {
                    return -1;
                }
            }
            --this.dataLength;
            int data = super.read();
            if (data < 0) {
                throw new IOException("Premature message end (reading DATA)");
            }
            return data;
        }
        return super.read();
    }

    public long skip(long n) throws IOException {
        if (this.dimeMessage) {
            if (n > (long)this.dataLength) {
                n = this.dataLength;
            }
            long skipped = this.blockingSkip(n);
            this.dataLength = (int)((long)this.dataLength - skipped);
            return skipped;
        }
        return super.skip(n);
    }

    private int blockingRead(byte[] b, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int l = super.read(b, off, toRead);
            if (l < 0) {
                return l;
            }
            toRead -= l;
            off += l;
        }
        return len;
    }

    private long blockingSkip(long len) throws IOException {
        long toSkip = len;
        while (toSkip > 0L) {
            long l = super.skip(toSkip);
            if (l < 0L) {
                return l;
            }
            toSkip -= l;
        }
        return len;
    }

    private int read32(byte[] src, int offset) {
        return (((src[offset++] & 0xFF) << 8 | src[offset++] & 0xFF) << 8 | src[offset++] & 0xFF) << 8 | src[offset] & 0xFF;
    }

    private int read16(byte[] src, int offset) {
        return (src[offset++] & 0xFF) << 8 | src[offset] & 0xFF;
    }

    private void skipPadding(long len) throws IOException {
        long len32 = (len - 1L | 3L) + 1L;
        if (len32 > len && this.blockingSkip(len32 - len) < 0L) {
            throw new IOException("Incomplete DIME record (skipping padding bytes)");
        }
    }

    private boolean readNextChunk() throws IOException {
        this.blockingSkip(this.dataLength + this.dataPadding);
        return this.readNextRecordHeader();
    }

    private boolean readNextRecordHeader() throws IOException {
        if (this.blockingRead(this.header, 0, 12) < 0) {
            if (!this.messageEnd) {
                throw new IOException("Missing or incomplete DIME record header");
            }
            return false;
        }
        if (this.messageEnd) {
            throw new IOException("DIME record after message end occured");
        }
        if ((this.header[0] & 0xF8) != 8) {
            throw new IOException("Incorrect DIME header version, message corrupt");
        }
        if ((this.header[1] & 0xF) != 0) {
            throw new IOException("Reserved bits in DIME header not zero, message corrupt");
        }
        int optionsLength = this.read16(this.header, 2);
        int idLength = this.read16(this.header, 4);
        int typeLength = this.read16(this.header, 6);
        if (this.moreChunks && (this.header[1] & 0xF0) == 0 && (optionsLength > 0 || idLength > 0 || typeLength > 0)) {
            throw new IOException("OPTIONS / ID / TYPE filed found in middle / last chunk, message corrupt");
        }
        if ((this.header[0] & 4) != 0) {
            if (!this.messageBeginning) {
                throw new IOException("Second record with MB flag set occured, message corrupt");
            }
            this.messageBeginning = false;
        } else if (this.messageBeginning) {
            throw new IOException("First record has MB flag clear, message corrupt");
        }
        this.moreChunks = (this.header[0] & 1) != 0;
        boolean bl = this.messageEnd = (this.header[0] & 2) != 0;
        if (this.blockingSkip(optionsLength) < 0L) {
            throw new IOException("Incomplete DIME record header (reading OPTIONS)");
        }
        if (idLength > 0) {
            if (idLength > 2048) {
                throw new IOException("Maximum ID length (2048 octets) exceeded - was " + idLength + " octets");
            }
            byte[] idBytes = new byte[idLength];
            if (this.blockingRead(idBytes, 0, idLength) < 0) {
                throw new IOException("Incomplete DIME record header (reading ID)");
            }
            this.skipPadding(idLength);
            String contentId = new String(idBytes);
            this.headers.set("content-id", contentId);
            this.headers.set("content-location", contentId);
        }
        if (typeLength > 0) {
            if (typeLength > 2048) {
                throw new IOException("Maximum TYPE length (2048 octets) exceeded - was " + typeLength + " octets");
            }
            byte[] typeBytes = new byte[typeLength];
            if (this.blockingRead(typeBytes, 0, typeLength) < 0) {
                throw new IOException("Incomplete DIME record header (reading TYPE)");
            }
            this.skipPadding(typeLength);
            this.headers.set("content-type", new String(typeBytes));
        }
        this.dataLength = this.read32(this.header, 8);
        this.dataPadding = (this.dataLength - 1 | 3) + 1 - this.dataLength;
        return true;
    }
}

