/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport;

import com.idoox.debug.Category;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.InitialReferencesRegistrar;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.transport.Transport;
import org.idoox.transport.TransportRepository;
import org.idoox.transport.TransportStartException;
import org.idoox.transport.URI;
import org.idoox.transport.client.Endpoint;
import org.idoox.transport.config.TransportConfig;
import org.idoox.transport.server.ConnectionHandler;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.WaspInternalException;

public class TransportRepositoryImpl
implements TransportRepository,
Module {
    private static final Category log = Category.getCategory("com.idoox.transport.TransportRepositoryImpl");
    private Map nameToTransport = Collections.synchronizedMap(new HashMap(13));
    private Map schemeToTransport = Collections.synchronizedMap(new HashMap(13));
    private ConnectionHandler handler;
    private Transport[] httpTransports;
    static /* synthetic */ Class class$org$idoox$transport$config$TransportConfig;

    public Set getTransportNames() {
        return this.nameToTransport.keySet();
    }

    public Transport getTransportForName(String name) {
        TransportRecord transportRecord = (TransportRecord)this.nameToTransport.get(name);
        if (transportRecord == null) {
            return null;
        }
        TransportRecord transportRecord2 = transportRecord;
        synchronized (transportRecord2) {
            try {
                if (transportRecord.transport == null) {
                    transportRecord.load(false);
                }
            }
            catch (Exception e) {
                transportRecord.transport = null;
                throw new RuntimeWrappedException(e);
            }
            Transport transport = transportRecord.transport;
            return transport;
        }
    }

    public String getTransportSchemeForName(String name) {
        TransportRecord transportRecord = (TransportRecord)this.nameToTransport.get(name);
        if (transportRecord == null) {
            return null;
        }
        return transportRecord.scheme;
    }

    public Transport[] getTransportForScheme(String scheme) {
        boolean isHTTP = scheme.equals("http");
        if (isHTTP && this.httpTransports != null) {
            return this.httpTransports;
        }
        LinkedList transportRecords = (LinkedList)this.schemeToTransport.get(scheme);
        if (transportRecords == null) {
            return new Transport[0];
        }
        Transport[] transports = new Transport[transportRecords.size()];
        int j = 0;
        Iterator i = transportRecords.iterator();
        while (i.hasNext()) {
            TransportRecord transportRecord;
            TransportRecord transportRecord2 = transportRecord = (TransportRecord)i.next();
            synchronized (transportRecord2) {
                try {
                    if (transportRecord.transport == null) {
                        transportRecord.load(false);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeWrappedException(e);
                }
                transports[j] = transportRecord.transport;
            }
            ++j;
        }
        if (isHTTP) {
            this.httpTransports = transports;
        }
        return transports;
    }

    public Transport getTransport(String scheme) {
        Transport[] transports = this.getTransportForScheme(scheme);
        int i = 0;
        while (i < transports.length) {
            if ((transports[i].getType() & 1) != 0) {
                return transports[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized void addTransport(String name, String scheme, Transport transport) {
        TransportRecord record = new TransportRecord(name, scheme, false, null, null, transport, null, false);
        if ((transport.getType() & 1) != 0) {
            transport.setHandler(this.handler);
        }
        this.addTransport(record);
    }

    private synchronized void addTransport(TransportRecord record) {
        if (this.nameToTransport.containsKey(record.name)) {
            throw new RuntimeException("Transport '" + record.name + "' is already registered");
        }
        this.nameToTransport.put(record.name, record);
        LinkedList<TransportRecord> transportRecords = (LinkedList<TransportRecord>)this.schemeToTransport.get(record.scheme);
        if (transportRecords == null) {
            transportRecords = new LinkedList<TransportRecord>();
            this.schemeToTransport.put(record.scheme, transportRecords);
        }
        transportRecords.add(record);
        this.httpTransports = null;
    }

    public synchronized Transport addServer(Configurable c, boolean startPreloaded) throws TransportStartException {
        TransportConfig config = (TransportConfig)c.narrow(class$org$idoox$transport$config$TransportConfig == null ? (class$org$idoox$transport$config$TransportConfig = TransportRepositoryImpl.class$("org.idoox.transport.config.TransportConfig")) : class$org$idoox$transport$config$TransportConfig);
        String name = config.getName();
        if (name == null) {
            throw new TransportStartException("Couldn't register new transport wihout name");
        }
        String scheme = config.getScheme();
        if (scheme == null) {
            throw new TransportStartException("Couldn't register new transport wihout scheme");
        }
        Configurable newConfig = null;
        LinkedList transportRecords = (LinkedList)this.schemeToTransport.get(scheme);
        if (transportRecords != null) {
            Iterator i = transportRecords.iterator();
            while (i.hasNext()) {
                TransportRecord transportRecord = (TransportRecord)i.next();
                if (!transportRecord.defaultServer) continue;
                newConfig = Configurator.setDefaultsOnConfigurable(c, transportRecord.config);
                break;
            }
        }
        if (newConfig != null) {
            c = newConfig;
        } else {
            log.warn("Default server transport for '" + scheme + "' scheme wasn't found");
        }
        return this.addTransport(c, startPreloaded);
    }

    public synchronized Transport addTransport(Configurable c, boolean startPreloaded) throws TransportStartException {
        try {
            ClassSpace classSpace;
            TransportConfig config = (TransportConfig)c.narrow(class$org$idoox$transport$config$TransportConfig == null ? (class$org$idoox$transport$config$TransportConfig = TransportRepositoryImpl.class$("org.idoox.transport.config.TransportConfig")) : class$org$idoox$transport$config$TransportConfig);
            String name = config.getName();
            if (name == null) {
                throw new TransportStartException("Couldn't register new transport wihout name");
            }
            String scheme = config.getScheme();
            if (scheme == null) {
                throw new TransportStartException("Couldn't register new transport wihout scheme");
            }
            boolean preload = false;
            try {
                preload = config.getPreload();
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean defaultServer = false;
            try {
                defaultServer = config.getDefaultServer();
            }
            catch (Exception e) {
                // empty catch block
            }
            String classSpaceName = config.getClassSpaceName();
            try {
                classSpace = classSpaceName == null && c.getReferenceLocation() == null ? ClassSpaceHelper.getWaspClassSpace() : ClassSpaceHelper.getClassSpace(classSpaceName, c.getReferenceLocation());
            }
            catch (MalformedURLException e) {
                throw new TransportStartException("Could not find class space " + classSpaceName + " for transport '" + name + "'", e);
            }
            String className = config.getClassName();
            if (className == null) {
                throw new TransportStartException("Config does not contain class name for transport '" + name + "'");
            }
            TransportRecord record = new TransportRecord(name, scheme, preload, classSpace, className, null, c, defaultServer);
            c.addVetoableChangeListener(record);
            if (preload) {
                record.load(startPreloaded);
            }
            this.addTransport(record);
            return record.transport;
        }
        catch (TransportStartException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransportStartException(e);
        }
    }

    public Transport removeTransport(String name) {
        return this.removeTransport(name, true);
    }

    private Transport removeTransport(String name, boolean remove) {
        TransportRecord record;
        if (remove) {
            record = (TransportRecord)this.nameToTransport.remove(name);
            if (record != null) {
                LinkedList transportRecords = (LinkedList)this.schemeToTransport.get(record.scheme);
                transportRecords.remove(record);
                this.httpTransports = null;
            }
        } else {
            record = (TransportRecord)this.nameToTransport.get(name);
        }
        if (record == null) {
            return null;
        }
        if (record.transport != null) {
            if ((record.transport.getType() & 1) != 0) {
                record.transport.stop();
                record.transport.setHandler(null);
            }
            record.transport.destroy();
        }
        if (record.config != null) {
            record.config.removeVetoableChangeListener(record);
        }
        return record.transport;
    }

    public synchronized ConnectionHandler setHandler(ConnectionHandler handler) {
        ConnectionHandler oldHandler = this.handler;
        this.handler = handler;
        Iterator i = this.nameToTransport.values().iterator();
        while (i.hasNext()) {
            TransportRecord record = (TransportRecord)i.next();
            if (record.transport == null || (record.transport.getType() & 1) == 0) continue;
            record.transport.setHandler(handler);
        }
        return oldHandler;
    }

    public synchronized void load(Configurable c) {
        InitialReferencesRegistrar.addInitialReference("org.idoox.transport.TransportRepository", this);
        Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        Configurable[] transports = Configurator.getTopEntries("transport");
        int i = 0;
        while (i < transports.length) {
            try {
                this.addTransport(transports[i], false);
            }
            catch (Exception e) {
                TransportConfig config = (TransportConfig)transports[i].narrow(class$org$idoox$transport$config$TransportConfig == null ? TransportRepositoryImpl.class$("org.idoox.transport.config.TransportConfig") : class$org$idoox$transport$config$TransportConfig);
                log.error("Exception in transport '" + config.getName() + "' (class-space: " + config.getClassSpaceName() + ", class-name: " + config.getClassName() + ")", e);
            }
            ++i;
        }
    }

    public void init() throws WaspInternalException {
        try {
            Iterator i = this.nameToTransport.values().iterator();
            while (i.hasNext()) {
                TransportRecord record = (TransportRecord)i.next();
                if (!record.preload || (record.transport.getType() & 1) == 0) continue;
                record.transport.start(null);
            }
        }
        catch (TransportStartException e) {
            throw new WaspInternalException(e);
        }
    }

    public synchronized void destroy() {
        Iterator i = this.nameToTransport.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            this.removeTransport(name, false);
        }
        this.nameToTransport.clear();
        this.schemeToTransport.clear();
        this.handler = null;
        this.httpTransports = null;
    }

    public String getLocalPath(URI endpoint) {
        LinkedList transportRecords = (LinkedList)this.schemeToTransport.get(endpoint.getScheme());
        if (transportRecords == null) {
            return null;
        }
        Iterator i = transportRecords.iterator();
        while (i.hasNext()) {
            String localPath;
            TransportRecord transportRecord = (TransportRecord)i.next();
            if (transportRecord.transport == null || (transportRecord.transport.getType() & 1) == 0 || (localPath = transportRecord.transport.getLocalPath(endpoint)) == null) continue;
            return localPath;
        }
        return null;
    }

    public Endpoint[] getAbsolutePath(String path) throws MalformedURLException {
        HashSet<Endpoint> endpoints = new HashSet<Endpoint>(5);
        Iterator i = this.nameToTransport.values().iterator();
        while (i.hasNext()) {
            Endpoint[] ends;
            TransportRecord record = (TransportRecord)i.next();
            if (record.transport == null || (record.transport.getType() & 1) == 0 || !record.transport.isStarted() || (ends = record.transport.getAbsolutePath(path)) == null) continue;
            int j = 0;
            while (j < ends.length) {
                if (ends[j] != null) {
                    endpoints.add(ends[j]);
                }
                ++j;
            }
        }
        return endpoints.toArray(new Endpoint[0]);
    }

    static /* synthetic */ Transport[] access$202(TransportRepositoryImpl x0, Transport[] x1) {
        x0.httpTransports = x1;
        return x1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TransportRecord
    implements VetoableChangeListener {
        public String name;
        public String scheme;
        public boolean preload;
        public ClassSpace classSpace;
        public String className;
        public Transport transport;
        public Configurable config;
        public boolean defaultServer;
        static /* synthetic */ Class class$org$idoox$transport$Transport;

        public TransportRecord(String name, String scheme, boolean preload, ClassSpace classSpace, String className, Transport transport, Configurable config, boolean defaultServer) {
            this.name = name;
            this.scheme = scheme;
            this.preload = preload;
            this.classSpace = classSpace;
            this.className = className;
            this.transport = transport;
            this.config = config;
            this.defaultServer = defaultServer;
        }

        public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
            if (!event.getPropertyName().equals("name")) {
                if (event.getPropertyName().equals("scheme")) {
                    String oldScheme = this.scheme;
                    this.scheme = (String)event.getNewValue();
                    try {
                        TransportRepositoryImpl.this.addTransport(this);
                        LinkedList transports = (LinkedList)TransportRepositoryImpl.this.schemeToTransport.get(oldScheme);
                        transports.remove(this);
                        TransportRepositoryImpl.access$202(TransportRepositoryImpl.this, null);
                    }
                    catch (Exception e) {
                        this.scheme = oldScheme;
                        throw new PropertyVetoException("Can't register transport '" + this.name + "' for scheme '" + event.getNewValue() + "': " + e, event);
                    }
                }
                if (event.getPropertyName().equals("preload")) {
                    boolean preload = false;
                    if (event.getNewValue() != null) {
                        preload = (Boolean)event.getNewValue();
                    }
                    try {
                        if (preload && this.transport == null) {
                            this.load(true);
                        }
                    }
                    catch (Exception e) {
                        throw new PropertyVetoException("Exception in transport '" + this.name + "' (class-space: " + this.classSpace + ", class-name: " + this.className + "): " + e, event);
                    }
                    this.preload = preload;
                } else if (event.getPropertyName().equals("defaultServer")) {
                    this.defaultServer = event.getNewValue() != null ? (Boolean)event.getNewValue() : false;
                } else if (event.getPropertyName().equals("classSpaceName")) {
                    ClassSpace cs;
                    String classSpaceName = (String)event.getNewValue();
                    try {
                        cs = ClassSpaceHelper.getClassSpace(classSpaceName, this.config.getReferenceLocation());
                    }
                    catch (MalformedURLException e) {
                        throw new PropertyVetoException("Could not find class space " + classSpaceName + " for transport '" + this.name + "' - MalformedURLException: " + e.getMessage(), event);
                    }
                    this.reload(this.className, cs, event);
                } else if (event.getPropertyName().equals("className")) {
                    String cn = (String)event.getNewValue();
                    if (cn == null) {
                        throw new PropertyVetoException("Config does not contain class name for transport '" + this.name + "'", event);
                    }
                    this.reload(cn, this.classSpace, event);
                }
            }
        }

        public void load(boolean start) throws ClassNotFoundException, InstantiationException, IllegalAccessException, TransportStartException, MalformedURLException {
            if (this.transport != null) {
                return;
            }
            this.transport = (Transport)this.classSpace.createInstance(class$org$idoox$transport$Transport == null ? (class$org$idoox$transport$Transport = TransportRecord.class$("org.idoox.transport.Transport")) : class$org$idoox$transport$Transport, this.className);
            if (this.transport == null) {
                throw new InstantiationException("Could not access transport '" + this.name + "' in class space " + this.classSpace);
            }
            this.transport.load(this.config);
            if ((this.transport.getType() & 1) != 0) {
                this.transport.setHandler(TransportRepositoryImpl.this.handler);
                if (start) {
                    this.transport.start(null);
                }
            }
        }

        private void reload(String className, ClassSpace classSpace, PropertyChangeEvent event) throws PropertyVetoException {
            Transport transport = null;
            if (this.preload) {
                try {
                    transport = (Transport)classSpace.createInstance(class$org$idoox$transport$Transport == null ? (class$org$idoox$transport$Transport = TransportRecord.class$("org.idoox.transport.Transport")) : class$org$idoox$transport$Transport, className);
                    if (transport == null) {
                        throw new PropertyVetoException("Could not access transport '" + this.name + "' in class space " + classSpace, event);
                    }
                }
                catch (Exception e) {
                    throw new PropertyVetoException("Exception in transport '" + this.name + "' (class-space: " + classSpace + ", class-name: " + className + ")" + ": " + e, event);
                }
            }
            if (this.transport != null) {
                if ((this.transport.getType() & 1) != 0) {
                    this.transport.stop();
                }
                this.transport.destroy();
            }
            if (transport != null) {
                transport.load(this.config);
                if ((transport.getType() & 1) != 0) {
                    transport.setHandler(TransportRepositoryImpl.this.handler);
                    try {
                        transport.start(null);
                    }
                    catch (TransportStartException e) {
                        throw new PropertyVetoException("Exception in transport '" + this.name + "' start: " + e, event);
                    }
                }
            }
            this.transport = transport;
            this.className = className;
            this.classSpace = classSpace;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

