/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.soap;

import com.idoox.debug.Category;
import com.idoox.soap.Constants;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.XMLWriterReader;
import org.idoox.xmlrpc.Fault;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.header.HeaderHelper;
import org.idoox.xmlrpc.header.HeaderProcessingException;
import org.idoox.xmlrpc.header.HeaderProcessor;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.soap.bc.MessageConvertor;
import org.systinet.wasp.webservice.Current;

public class VersionMismatchFaultHeaderProcessor
implements HeaderProcessor {
    private static final Category cat = Category.getCategory("com.idoox.soap.VersionMismatchFaultHeaderProcessor");
    private static final String ENVELOPE_ELEMENT = "SupportedEnvelope";
    private static final String QNAME_ATTRIBUTE = "qname";

    public void processInput(Message message) throws HeaderProcessingException {
    }

    public void processInputFault(Message message) throws HeaderProcessingException {
    }

    public void processOutput(Message message) throws HeaderProcessingException {
    }

    public void processOutputFault(Message message) throws HeaderProcessingException {
        try {
            Fault fault = message.getFault();
            QName faultCode = fault.getFaultCode();
            if (!org.idoox.xmlrpc.Constants.VERSION_MISMATCH_FAULT_CODE.equals(faultCode) && !org.idoox.xmlrpc.Constants.VERSION_MISMATCH_FAULT_CODE_12.equals(faultCode)) {
                return;
            }
            LinkedList qnames = new LinkedList();
            Set supportedProtocols = ((ServiceEndpointImpl)Current.getServiceEndpointContext().getServiceEndpoint()).getSupportedProtocols();
            if (supportedProtocols == null) {
                return;
            }
            Iterator it = supportedProtocols.iterator();
            while (it.hasNext()) {
                String supportedProtocol = (String)it.next();
                Object protocolQName = Constants.PROTOCOL_TO_QNAME.get(supportedProtocol);
                if (protocolQName == null) continue;
                qnames.add(protocolQName);
            }
            if (qnames.size() == 0) {
                return;
            }
            HeaderHelper helper = HeaderHelper.getInstance();
            XMLWriterReader writerReader = helper.createWriterTokenizer();
            WaspSOAPMessage saajMsg = MessageConvertor.convertMessage(message);
            String envNS = saajMsg.getSOAPPart().getEnvelope().getElementName().getURI();
            QName qName = new QName(envNS, "Upgrade");
            writerReader.enter(qName.getNamespaceURI(), qName.getLocalPart());
            it = qnames.iterator();
            while (it.hasNext()) {
                writerReader.enter(envNS, ENVELOPE_ELEMENT);
                qName = (QName)it.next();
                String namespace = qName.getNamespaceURI();
                String prefix = namespace == null || namespace.length() == 0 ? null : writerReader.getPrefixForNamespace(namespace);
                String tmp = prefix == null || prefix.length() == 0 ? qName.getLocalPart() : prefix + ":" + qName.getLocalPart();
                writerReader.writeAttribute(null, QNAME_ATTRIBUTE, tmp);
                writerReader.leave();
            }
            writerReader.leave();
            writerReader.next();
            message.addHeader(writerReader);
        }
        catch (Exception e) {
            cat.debug("Error:", e);
            throw new HeaderProcessingException(e.getMessage());
        }
    }
}

