/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.soap;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PushbackTokenizer
implements Tokenizer {
    Tokenizer innerTokenizer;
    Token lastReadToken;
    DeclaredPrefixesStack newlyDeclaredNamespaces;
    Map prefixToNamespaceMap;

    public PushbackTokenizer(Tokenizer innerTokenizer, Token lastReadToken, DeclaredPrefixesStack newlyDeclaredNamespaces, Map prefixToNamespaceMap) {
        this.innerTokenizer = innerTokenizer;
        this.lastReadToken = lastReadToken;
        this.newlyDeclaredNamespaces = newlyDeclaredNamespaces;
        this.prefixToNamespaceMap = prefixToNamespaceMap;
    }

    public String getLocalName() throws TokenizerException {
        if (this.lastReadToken != null) {
            return this.lastReadToken.getLocalName();
        }
        return this.innerTokenizer.getLocalName();
    }

    public String getNamespace() throws TokenizerException {
        if (this.lastReadToken != null) {
            return this.lastReadToken.getNamespace();
        }
        return this.innerTokenizer.getNamespace();
    }

    public String getNamespaceForPrefix(String prefix) {
        if (this.lastReadToken != null) {
            return (String)this.prefixToNamespaceMap.get(prefix);
        }
        String namespace = this.innerTokenizer.getNamespaceForPrefix(prefix);
        if (namespace == null) {
            return (String)this.prefixToNamespaceMap.get(prefix);
        }
        return namespace;
    }

    public Element getDOMRepresentation(Document doc) throws TokenizerException {
        if (this.lastReadToken != null) {
            throw new UnsupportedOperationException("todo");
        }
        return this.innerTokenizer.getDOMRepresentation(doc);
    }

    public QName parseQName(String qName) {
        if (this.lastReadToken != null) {
            if (qName.charAt(0) == '{') {
                return QName.valueOf(qName);
            }
            int p = qName.indexOf(58);
            String prefix = null;
            String localName = qName.substring(p + 1);
            if (p > 0) {
                prefix = qName.substring(0, p);
            }
            return new QName(this.getNamespaceForPrefix(prefix), localName);
        }
        return this.innerTokenizer.parseQName(qName);
    }

    public byte next() throws TokenizerException, IOException {
        if (this.lastReadToken != null) {
            this.lastReadToken = null;
            return this.innerTokenizer.currentState();
        }
        return this.innerTokenizer.next();
    }

    public byte currentState() {
        if (this.lastReadToken != null) {
            return this.lastReadToken.type;
        }
        return this.innerTokenizer.currentState();
    }

    public String readContent() throws TokenizerException {
        if (this.lastReadToken != null) {
            throw new TokenizerException("Illegal state");
        }
        return this.innerTokenizer.readContent();
    }

    public void readToken(Token stoken) throws TokenizerException, IOException {
        if (this.lastReadToken != null) {
            this.lastReadToken.writeTo(stoken);
        } else {
            this.innerTokenizer.readToken(stoken);
        }
    }

    public boolean whitespaceContent() throws TokenizerException {
        if (this.lastReadToken != null) {
            throw new TokenizerException("Illegal state");
        }
        return this.innerTokenizer.whitespaceContent();
    }

    public Map getCurrentPrefixMap() {
        if (this.lastReadToken != null) {
            return (Map)((HashMap)this.prefixToNamespaceMap).clone();
        }
        return this.innerTokenizer.getCurrentPrefixMap();
    }

    public int pushNewlyDeclaredPrefixes(DeclaredPrefixesStack prefixes) {
        if (this.lastReadToken != null) {
            if (this.newlyDeclaredNamespaces.used > 0) {
                prefixes.enlarge(this.newlyDeclaredNamespaces.used);
                System.arraycopy(this.newlyDeclaredNamespaces.prefixes, 0, prefixes.prefixes, prefixes.used, this.newlyDeclaredNamespaces.used);
                System.arraycopy(this.newlyDeclaredNamespaces.prefixValues, 0, prefixes.prefixValues, prefixes.used, this.newlyDeclaredNamespaces.used);
                System.arraycopy(this.newlyDeclaredNamespaces.previousPrefixValues, 0, prefixes.previousPrefixValues, prefixes.used, this.newlyDeclaredNamespaces.used);
                prefixes.used += this.newlyDeclaredNamespaces.used;
            }
            return this.newlyDeclaredNamespaces.used;
        }
        return this.innerTokenizer.pushNewlyDeclaredPrefixes(prefixes);
    }
}

