/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.soap;

import com.idoox.debug.Category;
import com.idoox.soap.Constants;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.idoox.webservice.CallContext;
import org.idoox.xml.XMLWriterReader;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.header.HeaderHelper;
import org.idoox.xmlrpc.header.HeaderProcessingException;
import org.idoox.xmlrpc.header.HeaderProcessor;

public class MustUnderstandFaultHeaderProcessor
implements HeaderProcessor {
    private static final Category cat = Category.getCategory("com.idoox.soap.MustUnderstandFaultHeaderProcessor");
    public static final String ENVELOPE_ELEMENT = "Envelope";
    public static final String QNAME_ATTRIBUTE = "qname";

    public void processInput(Message message) throws HeaderProcessingException {
    }

    public void processInputFault(Message message) throws HeaderProcessingException {
    }

    public void processOutput(Message message) throws HeaderProcessingException {
    }

    public void processOutputFault(Message message) throws HeaderProcessingException {
        try {
            CallContext context = CallContext.getInstance();
            LinkedList qnames = (LinkedList)context.get("soap.MisunderstoodHeaders");
            if (qnames == null) {
                return;
            }
            HeaderHelper helper = HeaderHelper.getInstance();
            QName qName = Constants.MISUNDERSTOOD_HEADER_QNAME;
            Iterator it = qnames.iterator();
            while (it.hasNext()) {
                XMLWriterReader writerReader = helper.createWriterTokenizer();
                writerReader.enter(qName.getNamespaceURI(), qName.getLocalPart());
                qName = (QName)it.next();
                String namespace = qName.getNamespaceURI();
                String prefix = namespace == null || namespace.length() == 0 ? null : writerReader.getPrefixForNamespace(namespace);
                String tmp = prefix == null || prefix.length() == 0 ? qName.getLocalPart() : prefix + ":" + qName.getLocalPart();
                writerReader.writeAttribute(null, QNAME_ATTRIBUTE, tmp);
                writerReader.leave();
                writerReader.next();
                message.addHeader(writerReader);
            }
        }
        catch (Exception e) {
            cat.debug("Error:", e);
            throw new HeaderProcessingException(e.getMessage());
        }
    }
}

