/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.soap;

import com.idoox.soap.EnvelopeCaching;
import com.idoox.soap.InputStreamPulled;
import com.idoox.xml.ReaderTokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.util.Base64;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.Token;
import org.idoox.xml.TokenizerException;

public class EnvelopeInCache {
    public String headerID;
    public int length;
    public String uri;
    public String prefix;
    public String localName;
    public String qName;
    public String defaultNamespace;
    private int prefixesEnd;
    public String[] prefixes;
    public String[] prefixValues;
    public String encodingStyle;
    public Map envelopeNamespaces;
    public Map envelopeAttributes;
    public boolean isValid;

    public static final void prepareEnvelopeInCache(EnvelopeCaching envelopeCache, String headerID, InputStream inputMessage, ReaderTokenizer tokenizer) throws IOException, TokenizerException {
        if (!EnvelopeCaching.isEnabled() || headerID == null || envelopeCache == null || envelopeCache.disabled()) {
            tokenizer.setInput(inputMessage);
            tokenizer.next();
            return;
        }
        EnvelopeInCache envelopeInCache = envelopeCache.findEnvelopeCache(headerID);
        if (envelopeInCache != null) {
            if (!envelopeInCache.isValid) {
                tokenizer.setInput(inputMessage);
                tokenizer.next();
                return;
            }
            try {
                long skipped;
                int toSkip = envelopeInCache.length;
                do {
                    if ((skipped = inputMessage.skip(toSkip)) <= 0L) continue;
                    toSkip = (int)((long)toSkip - skipped);
                } while (skipped >= 0L && toSkip > 0);
                if (toSkip != 0) {
                    throw new IOException("Couldn't determine the content of message. Try JVM option: '-Dwasp.soap.caching=false'");
                }
                tokenizer.setInput(inputMessage);
            }
            catch (IOException e) {
                throw new RuntimeWrappedException(e);
            }
            tokenizer.insertFakeTag(envelopeInCache.uri, envelopeInCache.prefix, envelopeInCache.localName, envelopeInCache.qName, envelopeInCache.defaultNamespace, envelopeInCache.prefixes, envelopeInCache.prefixValues, envelopeInCache.prefixesEnd);
            return;
        }
        envelopeInCache = new EnvelopeInCache();
        envelopeInCache.headerID = headerID;
        EnvelopeInCache.prepareCacheAndTokenizer(envelopeInCache, inputMessage, tokenizer);
        envelopeCache.insertEnvelopeCache(envelopeInCache);
    }

    private static void prepareCacheAndTokenizer(EnvelopeInCache envelopeInCache, InputStream inputMessage, ReaderTokenizer tokenizer) throws IOException, TokenizerException {
        int index = envelopeInCache.headerID.indexOf(45);
        String length = envelopeInCache.headerID.substring(0, index);
        String headerMD5 = envelopeInCache.headerID.substring(index + 1);
        envelopeInCache.length = Integer.parseInt(length, 16);
        byte[] envelopeBytes = new byte[envelopeInCache.length];
        int envelopeBytesRead = inputMessage.read(envelopeBytes);
        if (envelopeBytesRead != envelopeInCache.length) {
            if (envelopeBytesRead >= 0) {
                int actuallyRead;
                int required = envelopeInCache.length - envelopeBytesRead;
                do {
                    if ((actuallyRead = inputMessage.read(envelopeBytes, envelopeBytesRead, required)) <= 0) continue;
                    envelopeBytesRead += actuallyRead;
                    required -= actuallyRead;
                } while (actuallyRead >= 0 && required > 0);
            }
            if (envelopeBytesRead != envelopeInCache.length) {
                tokenizer.setInput(new InputStreamPulled(inputMessage, envelopeBytes, envelopeBytesRead));
                tokenizer.next();
                envelopeInCache.isValid = false;
                return;
            }
        }
        byte[] envelopeDigest = EnvelopeCaching.messageDigest.digest(envelopeBytes);
        String messageMD5 = new String(envelopeDigest = Base64.encode(envelopeDigest, false));
        if (!messageMD5.equals(headerMD5)) {
            tokenizer.setInput(new InputStreamPulled(inputMessage, envelopeBytes));
            tokenizer.next();
            envelopeInCache.isValid = false;
            return;
        }
        tokenizer.setInput(new InputStreamPulled(inputMessage, envelopeBytes));
        tokenizer.next();
        Token token = new Token();
        tokenizer.readToken(token);
        envelopeInCache.uri = tokenizer.getNamespace();
        envelopeInCache.prefix = tokenizer.getPrefix();
        if (envelopeInCache.prefix == null) {
            envelopeInCache.defaultNamespace = envelopeInCache.uri;
        }
        envelopeInCache.localName = tokenizer.getLocalName();
        envelopeInCache.qName = tokenizer.getQName();
        envelopeInCache.prefixesEnd = tokenizer.getPrefixesEnd();
        envelopeInCache.prefixes = new String[envelopeInCache.prefixesEnd];
        System.arraycopy(tokenizer.getPrefixes(), 0, envelopeInCache.prefixes, 0, envelopeInCache.prefixesEnd);
        envelopeInCache.prefixValues = new String[tokenizer.getPrefixesEnd()];
        System.arraycopy(tokenizer.getPrefixValues(), 0, envelopeInCache.prefixValues, 0, envelopeInCache.prefixesEnd);
        envelopeInCache.encodingStyle = token.getAttributeValue(envelopeInCache.uri, "encodingStyle");
        envelopeInCache.envelopeNamespaces = Collections.unmodifiableMap(tokenizer.getCurrentPrefixMap());
        envelopeInCache.envelopeAttributes = new HashMap(11, 0.75f);
        int i = 0;
        while (i < token.attEnd) {
            envelopeInCache.envelopeAttributes.put(new QName(token.attArr[i].uri, token.attArr[i].localName), token.attArr[i].value);
            ++i;
        }
        envelopeInCache.envelopeAttributes = Collections.unmodifiableMap(envelopeInCache.envelopeAttributes);
        envelopeInCache.isValid = true;
    }
}

