/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.config.xml;

import com.idoox.config.xml.ConfigStoreConfig;
import com.idoox.debug.Category;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;

public class ConfigStore
implements Module,
PropertyChangeListener {
    private static final Category log = Category.getCategory("com.idoox.config.xml.ConfigStore");
    private Configurable config;
    private long savingPeriod = -1L;
    private boolean shutdownHook = false;
    private Configurator configurator;
    private ConfigStoreTask configStoreTask = null;
    static /* synthetic */ Class class$com$idoox$config$xml$ConfigStoreConfig;

    public void load(Configurable c) {
        this.configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        ConfigStoreConfig config = (ConfigStoreConfig)c.narrow(class$com$idoox$config$xml$ConfigStoreConfig == null ? (class$com$idoox$config$xml$ConfigStoreConfig = ConfigStore.class$("com.idoox.config.xml.ConfigStoreConfig")) : class$com$idoox$config$xml$ConfigStoreConfig);
        try {
            this.savingPeriod = config.getSavingPeriod();
        }
        catch (Exception e) {
            log.warn("Config does not contain savingPeriod for configStore " + c.getName());
            this.savingPeriod = -1L;
        }
        try {
            this.shutdownHook = config.getShutdownHook();
        }
        catch (Exception e) {
            this.shutdownHook = false;
        }
        c.addPropertyChangeListener(this);
        this.config = c;
    }

    public void init() {
        this.start();
    }

    public void destroy() {
        this.stop();
        this.savingPeriod = -1L;
        this.shutdownHook = false;
        if (this.config != null) {
            this.config.removePropertyChangeListener(this);
            this.config = null;
        }
        this.configurator = null;
    }

    private void start() {
        try {
            log.info("Starting configStore with savingPeriod " + this.savingPeriod);
            Timer timer = (Timer)Context.getInstance("java.util.Timer");
            if (timer != null && this.savingPeriod > 0L) {
                this.configStoreTask = new ConfigStoreTask();
                timer.schedule((TimerTask)this.configStoreTask, this.savingPeriod, this.savingPeriod);
            }
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
    }

    private void stop() {
        try {
            log.info("Stopping configStore thread");
            if (this.shutdownHook) {
                this.flushWhenShutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
    }

    private void flushWhenShutdown() {
        Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        Configurator.flush();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("savingPeriod")) {
            int savingPeriod = -1;
            if (event.getNewValue() == null) {
                log.warn("Config does not contain savingPeriod for configStore " + this.config.getName());
            } else {
                savingPeriod = (Integer)event.getNewValue();
            }
            this.savingPeriod = savingPeriod;
            log.info("SavingPeriod was changed to: " + event.getNewValue().toString());
            if (this.savingPeriod > 0L) {
                if (this.configStoreTask == null) {
                    Timer timer = (Timer)Context.getInstance("java.util.Timer");
                    if (timer != null) {
                        this.configStoreTask = new ConfigStoreTask();
                        timer.schedule((TimerTask)this.configStoreTask, this.savingPeriod, this.savingPeriod);
                    }
                } else {
                    this.configStoreTask.cancel();
                    Timer timer = (Timer)Context.getInstance("java.util.Timer");
                    if (timer != null) {
                        this.configStoreTask = new ConfigStoreTask();
                        timer.schedule((TimerTask)this.configStoreTask, this.savingPeriod, this.savingPeriod);
                    }
                }
            } else if (this.configStoreTask != null) {
                this.configStoreTask.cancel();
            }
        }
        if (event.getPropertyName().equals("shutdownHook")) {
            boolean shutdownHook = false;
            if (event.getNewValue() == null) {
                log.warn("Config does not contain shutdownHook for configStore " + this.config.getName());
            } else {
                shutdownHook = (Boolean)event.getNewValue();
            }
            this.shutdownHook = shutdownHook;
            log.info("ShutdownHoog was changed to: " + event.getNewValue().toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConfigStoreTask
    extends TimerTask {
        private ConfigStoreTask() {
        }

        public void run() {
            if (ConfigStore.this.savingPeriod > 0L) {
                ConfigStore.this.configurator;
                Configurator.flush();
            }
        }
    }
}

