/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.transaction.db;

import com.idoox.debug.Category;
import com.systinet.uddi.database.ApiManager;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.TransactionManager;
import java.sql.SQLException;
import org.systinet.wasp.transaction.CompletionException;
import org.systinet.wasp.transaction.CurrentTransaction;
import org.systinet.wasp.transaction.PropagationContext;
import org.systinet.wasp.transaction.Terminator;

public class DbTerminator
implements Terminator {
    private static Category log = Category.getCategory((String)"org.systinet.wasp.transaction.db.DbPersistentStoreTerminator");
    private TransactionManager txMgr;
    private TransactionManager.TransactionContext txContext;

    public static DbTerminator ensureTx() throws DatabaseCoreException {
        PropagationContext context = CurrentTransaction.getPropagationContext();
        if (context != null) {
            DbTerminator terminator = (DbTerminator)context.getTerminator();
            if (terminator == null) {
                terminator = new DbTerminator(ApiManager.getApiManager().getDatabase().getTransactionManager());
                context.setTerminator((Terminator)terminator);
            }
            terminator.resumeTransaction();
            return terminator;
        }
        return null;
    }

    public static void suspendTx(DbTerminator terminator) {
        if (terminator != null) {
            terminator.suspendTransaction();
            terminator = null;
        }
    }

    DbTerminator(TransactionManager txMgr) throws DatabaseCoreException {
        this.txMgr = txMgr;
        txMgr.beginReadWrite();
        this.txContext = txMgr.suspendTransaction();
    }

    void resumeTransaction() {
        this.txMgr.resumeTransaction(this.txContext);
        this.txContext = null;
    }

    void suspendTransaction() {
        if (this.txContext != null) {
            throw new IllegalStateException("There is already suspended tx");
        }
        this.txContext = this.txMgr.suspendTransaction();
        if (this.txContext == null) {
            throw new IllegalStateException("There is no transaction running");
        }
    }

    public void commit() throws CompletionException {
        try {
            this.txMgr.resumeTransaction(this.txContext);
            this.txContext = null;
            this.txMgr.commit();
        }
        catch (SQLException e) {
            throw new CompletionException("SQLException", (Throwable)e);
        }
        catch (DatabaseCoreException e) {
            throw new CompletionException("DatabaseCoreException", (Throwable)e);
        }
    }

    public void rollback() throws CompletionException {
        try {
            this.txMgr.resumeTransaction(this.txContext);
            this.txContext = null;
            this.txMgr.rollback();
        }
        catch (DatabaseCoreException e) {
            throw new CompletionException("DatabaseCoreException", (Throwable)e);
        }
    }
}

