/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.security.ws;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.idoox.security.pstore.PStore;
import org.idoox.security.pstore.UserStore;
import org.idoox.security.server.Current;
import org.idoox.security.server.ReceivedCredentials;
import org.idoox.util.Base64;
import org.systinet.wasp.security.ws.EncryptedData;
import org.systinet.wasp.security.ws.SecurityElement;
import org.systinet.wasp.security.ws.SecurityToken;
import org.systinet.wasp.security.ws.Signature;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.MessageConf;
import org.systinet.wasp.security.ws.conf.PropertyConf;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;

public class X509Token
extends SecurityToken {
    private String alias = null;
    private String base64Value = null;
    private String password = null;

    public X509Token() {
    }

    public X509Token(String alias) {
        this.alias = alias;
        if (alias == null) {
            this.initReceivedCredentialsToken();
        }
    }

    public X509Token(String alias, String password) {
        this.alias = alias;
        this.password = password;
    }

    protected SecurityTokenConf getSecurityTokenConf(MessageConf messageConf) {
        PropertyConf propertyConf;
        SecurityTokenConf tokenConf = messageConf.newSecurityToken();
        if (this.getId() != null) {
            tokenConf.setWsuId(this.getId());
        }
        tokenConf.setType("X509v3");
        ArrayList<PropertyConf> properties = new ArrayList<PropertyConf>();
        if (this.alias != null) {
            propertyConf = tokenConf.newProperty();
            propertyConf.setPropertyName("alias");
            propertyConf.setPropertyValue(this.alias);
            properties.add(propertyConf);
        } else if (this.base64Value != null) {
            propertyConf = tokenConf.newProperty();
            propertyConf.setPropertyName("base64Certificate");
            propertyConf.setPropertyValue(this.base64Value);
            properties.add(propertyConf);
        }
        if (this.password != null) {
            propertyConf = tokenConf.newProperty();
            propertyConf.setPropertyName("password");
            propertyConf.setPropertyValue(this.password);
            properties.add(propertyConf);
        }
        if (properties.size() > 0) {
            tokenConf.setProperties(properties.toArray(SecurityToken.NULL_PROPERTY_CONF_ARRAY));
        }
        return tokenConf;
    }

    protected String getTokenReferenceModeHint(SecurityElement securityElement) {
        if (securityElement instanceof Signature) {
            return "reference";
        }
        if (securityElement instanceof EncryptedData) {
            return "keyidentifier";
        }
        throw new WSSecurityException(null, "unknown security element");
    }

    protected String getSignatureMethodHint() {
        return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    }

    protected String getEncryptionMethodHint() {
        return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    }

    protected String getKeyEncryptionMethodHint() {
        return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    }

    private void initReceivedCredentialsToken() {
        ReceivedCredentials recvCreds = Current.getInstance().getReceivedCredentials();
        if (recvCreds == null) {
            throw new WSSecurityException(null, "no received credentials");
        }
        if (!"WS-Security".equals(recvCreds.getProviderName())) {
            throw new WSSecurityException(null, "user was not authenticated with WS-Security provider");
        }
        try {
            X509Certificate[] userCertChain;
            String authAlias = recvCreds.getName();
            UserStore userStore = PStore.getInstance((String)"").getUserStore();
            X509Certificate userCert = (X509Certificate)userStore.getUserProperty(authAlias, "X509Certificate");
            if (userCert == null && (userCertChain = (X509Certificate[])userStore.getUserProperty(authAlias, "X509CertificateChain")) != null && userCertChain.length > 0) {
                userCert = userCertChain[0];
            }
            if (userCert == null) {
                throw new WSSecurityException(null, "user " + authAlias + " does not have X509Certificate or X509CertificateChain property");
            }
            this.base64Value = Base64.encodeToString((byte[])userCert.getEncoded());
        }
        catch (Exception e) {
            throw new WSSecurityException(e);
        }
    }
}

