/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.security.ws;

import com.idoox.debug.Category;
import com.idoox.util.UUID;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.ElementProxy;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.impl.SecurityTokenElementProxy;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import java.security.Key;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;
import org.systinet.wasp.webservice.Current;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SecurityTokenSPI {
    private static Category cat = Category.getCategory((String)(class$org$systinet$wasp$security$ws$SecurityTokenSPI == null ? (class$org$systinet$wasp$security$ws$SecurityTokenSPI = SecurityTokenSPI.class$("org.systinet.wasp.security.ws.SecurityTokenSPI")) : class$org$systinet$wasp$security$ws$SecurityTokenSPI).getName());
    private SecurityContext securityContext;
    private SecurityTokenElementProxy elementProxy;
    private boolean isExternal;
    public static final int PM_GENERATE = 0;
    public static final int PM_RECEIVE = 1;
    static /* synthetic */ Class class$org$systinet$wasp$security$ws$SecurityTokenSPI;

    public SecurityTokenSPI(SecurityContext securityContext, boolean isExternal) {
        this.elementProxy = new SecurityTokenElementProxy(this, securityContext.getMessageDocument());
        this.securityContext = securityContext;
        this.isExternal = isExternal;
        this.setUniqueWsuId();
    }

    public SecurityTokenSPI(Element element, SecurityContext securityContext) {
        try {
            this.elementProxy = new SecurityTokenElementProxy(this, element, "");
        }
        catch (XMLSecurityException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY_TOKEN;
        }
        this.securityContext = securityContext;
        this.isExternal = false;
    }

    public abstract void doFinal(int var1) throws WSSecurityException;

    public Element getElement() {
        return this.elementProxy.getElement();
    }

    public Document getDocument() {
        return this.elementProxy.getDocument();
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setUniqueWsuId() {
        this.setWsuId(this.getBaseLocalName() + "-" + UUID.uuidgen());
    }

    public void setWsuId(String wsuId) {
        this.addAnyAttribute(this.getSecurityContext().getWsuNamespace(), WSSecurityImpl.getWsuPrefix(), "Id", wsuId);
    }

    public String getWsuId() {
        return WSSecurityHelper.getAttributeNS(WSSecurity.KNOWN_WSU_URI, "Id", this.getElement());
    }

    public abstract byte[] getKeyIdentifier();

    public abstract String getValueType();

    public void addAnyAttribute(String attrNamespaceURI, String attrNamespacePrefix, String attrLocalName, String attrValue) {
        if (attrNamespaceURI == null || attrNamespacePrefix == null) {
            if (attrNamespaceURI != null || attrNamespacePrefix != null) {
                // empty if block
            }
            attrNamespaceURI = null;
            attrNamespacePrefix = null;
        }
        if (attrNamespacePrefix != null) {
            attrLocalName = attrNamespacePrefix + ":" + attrLocalName;
        }
        this.getElement().setAttributeNS(attrNamespaceURI, attrLocalName, attrValue);
    }

    public void addAnyAttribute(String attrName, String attrValue) {
        this.addAnyAttribute(null, null, attrName, attrValue);
    }

    public void addAnyElement(Element element) {
        this.getElement().appendChild(element);
        XMLUtils.addReturnToElement(this.getElement());
    }

    public Element addAnyElement(String namespaceURI, String prefix, String localName) {
        Element el = this.getDocument().createElementNS(namespaceURI, (prefix == null || "".equals(prefix) ? "" : prefix + ":") + localName);
        this.addAnyElement(el);
        return el;
    }

    public void addBase64Text(byte[] data) {
        this.elementProxy.addBase64Text(data);
    }

    public byte[] getBytesFromTextChild() {
        try {
            return this.elementProxy.getBytesFromTextChild();
        }
        catch (XMLSecurityException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY_TOKEN;
        }
    }

    public static String getDefaultPrefix(String namespace) {
        return ElementProxy.getDefaultPrefix(namespace);
    }

    public abstract Key getEncryptingKey() throws WSSecurityException;

    public abstract Key getDecryptingKey() throws WSSecurityException;

    public abstract Key getSigningKey() throws WSSecurityException;

    public abstract Key getAuthenticatingKey() throws WSSecurityException;

    public abstract SecurityTokenConf getReceivedConf();

    public abstract String getType();

    public String getBaseNamespace() {
        SecurityContext securityContext = this.getSecurityContext();
        if (securityContext == null) {
            securityContext = (SecurityContext)Current.getCallContext().getContextData().get(WSSecurityImpl.WSSECURITY_CONTEXT_KEY);
        }
        return securityContext.getWsseNamespace();
    }

    public String getBaseLocalName() {
        return "BinarySecurityToken";
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public String getKeyIdentifierValueType() {
        return this.getValueType();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

