/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.security.ws;

import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.systinet.wasp.security.ws.IdReference;
import org.systinet.wasp.security.ws.Reference;
import org.systinet.wasp.security.ws.SecurityElement;
import org.systinet.wasp.security.ws.SecurityToken;
import org.systinet.wasp.security.ws.X509Token;
import org.systinet.wasp.security.ws.conf.EncryptedDataConf;
import org.systinet.wasp.security.ws.conf.EncryptedKeyConf;
import org.systinet.wasp.security.ws.conf.EncryptionReferenceConf;
import org.systinet.wasp.security.ws.conf.KeyInfoConf;
import org.systinet.wasp.security.ws.conf.MessageConf;
import org.systinet.wasp.security.ws.conf.PropertyConf;
import org.systinet.wasp.security.ws.conf.ReferenceListConf;

public class EncryptedData
extends SecurityElement {
    private List references = null;
    private boolean encryptBody = false;
    private boolean encryptElementContent = false;
    private String keyEncryptionMethod = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    private String encryptionMethod = null;
    private String securityTokenReferenceId = null;
    private EncryptedDataConf[] encData = null;
    private EncryptedDataConf[] NULL_ENCRYPTED_DATA_CONF_ARRAY = new EncryptedDataConf[0];

    public EncryptedData(SecurityToken token) {
        super(token);
        this.encryptionMethod = token.getEncryptionMethodHint();
        this.keyEncryptionMethod = token.getKeyEncryptionMethodHint();
        token.getIdForced();
    }

    public EncryptedData(SecurityToken token, IdReference reference) {
        super(token);
        this.encryptionMethod = token.getEncryptionMethodHint();
        this.keyEncryptionMethod = token.getKeyEncryptionMethodHint();
        token.getIdForced();
        this.addReference(reference);
    }

    public void addReference(IdReference reference) {
        if (this.references == null) {
            this.references = new ArrayList();
        }
        this.references.add(reference);
    }

    public void setEncryptBody() {
        this.encryptBody = true;
        this.encryptElementContent = true;
    }

    public void setEncryptElementContent(boolean encryptElementContent) {
        this.encryptElementContent = encryptElementContent;
    }

    public void setEncryptionMethod(String encryptionMethod) {
        if (this.getToken() instanceof X509Token) {
            this.encryptionMethod = encryptionMethod;
        }
    }

    public void setKeyEncryptionMethod(String keyEncryptionMethod) {
        if (this.getToken() instanceof X509Token) {
            this.keyEncryptionMethod = keyEncryptionMethod;
        }
    }

    public void setSecurityTokenReferenceId(String strId) {
        this.securityTokenReferenceId = strId;
    }

    EncryptedDataConf[] getEncryptedDataConf(MessageConf messageConf) {
        ArrayList<EncryptedDataConf> e = new ArrayList<EncryptedDataConf>();
        if (this.encryptBody) {
            EncryptedDataConf encDataConf = this.newEncryptedDataConf(messageConf);
            encDataConf.setEncryptBody(Boolean.TRUE);
            e.add(encDataConf);
        }
        if (this.references != null) {
            Iterator it = this.references.iterator();
            while (it.hasNext()) {
                Reference reference = (Reference)it.next();
                EncryptedDataConf encDataConf = this.newEncryptedDataConf(messageConf);
                encDataConf.setEncryptionTargetId(reference.getExpression());
                e.add(encDataConf);
            }
        }
        this.encData = e.toArray(this.NULL_ENCRYPTED_DATA_CONF_ARRAY);
        return this.encData;
    }

    EncryptedKeyConf getEncryptedKeyConf(MessageConf messageConf) {
        if (this.keyEncryptionMethod == null) {
            return null;
        }
        EncryptedKeyConf encKeyConf = messageConf.newEncryptedKey();
        encKeyConf.setEncryptionMethodAlgorithm(this.keyEncryptionMethod);
        if (this.keyEncryptionMethod.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
            PropertyConf digestAlg = encKeyConf.newEncryptionMethodProperty();
            digestAlg.setPropertyName("OAEPDigest");
            digestAlg.setPropertyValue("http://www.w3.org/2000/09/xmldsig#sha1");
            encKeyConf.setEncryptionMethodProperties(new PropertyConf[]{digestAlg});
        }
        KeyInfoConf keyInfoConf = encKeyConf.newKeyInfo();
        this.fillKeyInfoConf(keyInfoConf);
        encKeyConf.setKeyInfo(keyInfoConf);
        EncryptionReferenceConf[] refs = new EncryptionReferenceConf[this.encData.length];
        int n = this.encData.length;
        int i = 0;
        while (i < n) {
            refs[i] = encKeyConf.newReference();
            refs[i].setRefUri("#" + this.encData[i].getWsuId());
            ++i;
        }
        encKeyConf.setReferences(refs);
        return encKeyConf;
    }

    ReferenceListConf getReferenceListConf(MessageConf messageConf) {
        if (this.keyEncryptionMethod != null) {
            return null;
        }
        ReferenceListConf referenceListConf = messageConf.newReferenceList();
        EncryptionReferenceConf[] refs = new EncryptionReferenceConf[this.encData.length];
        int n = this.encData.length;
        int i = 0;
        while (i < n) {
            refs[i] = referenceListConf.newReference();
            refs[i].setRefUri("#" + this.encData[i].getWsuId());
            ++i;
        }
        referenceListConf.setReferences(refs);
        return referenceListConf;
    }

    private void fillKeyInfoConf(KeyInfoConf keyInfoConf) {
        SecurityToken token = this.getToken();
        keyInfoConf.setSecurityTokenMode(token.getTokenReferenceModeHint(this));
        keyInfoConf.setSecurityTokenId(token.getId());
        keyInfoConf.setStrWsuId(this.securityTokenReferenceId);
    }

    private EncryptedDataConf newEncryptedDataConf(MessageConf messageConf) {
        EncryptedDataConf encDataConf = messageConf.newEncryptedData();
        encDataConf.setWsuId(WSSecurityImpl.genId());
        encDataConf.setEncryptionMethodAlgorithm(this.encryptionMethod);
        encDataConf.setEncryptElementContent(this.encryptElementContent ? Boolean.TRUE : Boolean.FALSE);
        if (this.keyEncryptionMethod == null) {
            KeyInfoConf keyInfoConf = encDataConf.newKeyInfo();
            this.fillKeyInfoConf(keyInfoConf);
            encDataConf.setKeyInfo(keyInfoConf);
        }
        return encDataConf;
    }
}

