/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml.security;

import java.util.HashMap;
import org.idoox.xml.security.ReferencedData;
import org.idoox.xml.security.SignatureException;

public abstract class Transform {
    private static HashMap transformsMap = new HashMap();
    private String algorithm;

    protected Transform(String algorithm) {
        this.algorithm = algorithm;
    }

    public static Transform getInstance(String algorithm) throws SignatureException {
        Transform transform = null;
        if (algorithm != null && (transform = (Transform)transformsMap.get(algorithm)) != null) {
            return transform;
        }
        throw new SignatureException("Algoritm " + algorithm + " not implemented.");
    }

    public abstract ReferencedData transform(ReferencedData var1) throws SignatureException;

    public String toCanonicalXMLString(String signaturePrefix) throws SignatureException {
        StringBuffer sb = new StringBuffer();
        String startTag = "";
        String endTag = "";
        if (!signaturePrefix.equals("")) {
            startTag = "<" + signaturePrefix + ":";
            endTag = "</" + signaturePrefix + ":";
        } else {
            startTag = "<";
            endTag = "</";
        }
        sb.append(startTag).append("Transform Algorithm=\"" + this.algorithm + "\">").append(endTag).append("Transform>");
        return sb.toString();
    }

    public static synchronized void addTransform(String algorithm, Transform transform) {
        transformsMap.put(algorithm, transform);
    }

    public static String[] getTransforms() {
        return transformsMap.keySet().toArray(new String[0]);
    }
}

