/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml.security;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.idoox.wasp.Context;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerFactory;
import org.idoox.xml.TokenizerResolver;
import org.idoox.xml.security.SignatureException;

public class ReferencedData {
    byte[] bytesData = null;
    Tokenizer tokenizerData = null;

    public ReferencedData(byte[] bytesData) {
        this.bytesData = bytesData;
    }

    public ReferencedData(Tokenizer tokenizerData) {
        this.tokenizerData = tokenizerData;
    }

    public byte[] getBytes() throws SignatureException {
        if (this.bytesData == null) {
            this.tokenizerToBytes();
        }
        return this.bytesData;
    }

    public Tokenizer getTokenizer() throws SignatureException {
        if (this.tokenizerData == null) {
            this.bytesToTokenizer();
        }
        Tokenizer ret = this.tokenizerData;
        this.tokenizerData = null;
        return ret;
    }

    private void tokenizerToBytes() throws SignatureException {
        if (this.tokenizerData == null) {
            return;
        }
        try {
            this.bytesData = TokenizerResolver.toCanonicalForm((Tokenizer)this.tokenizerData, (boolean)false);
            this.tokenizerData = null;
        }
        catch (Exception e) {
            throw new SignatureException("cannot convert tokenizer to byte array. " + (e.getMessage() == null ? "" : e.getMessage()), e);
        }
    }

    private void bytesToTokenizer() throws SignatureException {
        if (this.bytesData == null) {
            return;
        }
        TokenizerFactory tf = (TokenizerFactory)Context.getInstance((String)"org.idoox.xml.TokenizerFactory");
        try {
            this.tokenizerData = tf.getTokenizer((InputStream)new ByteArrayInputStream(this.bytesData));
            this.tokenizerData.next();
        }
        catch (Exception e) {
            throw new SignatureException("cannot convert tokenizer to byte. " + (e.getMessage() == null ? "" : e.getMessage()), e);
        }
    }
}

