/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.provider;

import com.idoox.debug.Category;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.iface.WSSecurityHeader;
import com.systinet.wasp.security.ws.iface.WSTimestampHeader;
import com.systinet.wasp.security.ws.impl.WSSecurityHeaderImpl;
import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import com.systinet.wasp.security.ws.provider.WSProviderHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Set;
import org.idoox.config.Configurator;
import org.idoox.transport.InputMessage;
import org.idoox.transport.RawInputMessage;
import org.systinet.wasp.security.ws.IncomingValidator;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.MessageConf;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WSSecurityInputMessage
extends RawInputMessage {
    private WSSecurity wsSecurity = null;
    private InputMessage inputMessage = null;
    private Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.provider.WSSecurityInputMessage");
    private Document message = null;
    private ByteArrayInputStream inputStream = null;
    boolean nextPart = false;
    static /* synthetic */ Class class$org$systinet$wasp$security$ws$conf$MessageConf;

    public WSSecurityInputMessage(InputMessage inputMessage, WSSecurity wsSecurity) {
        super((InputStream)inputMessage);
        this.wsSecurity = wsSecurity;
        this.inputMessage = inputMessage;
    }

    public String getMultipartType() throws IOException {
        String retVal = this.inputMessage.getMultipartType();
        return retVal;
    }

    protected void initStream() throws IOException {
        CallContext callContext = Current.getCallContext();
        try {
            PushbackInputStream pin = new PushbackInputStream((InputStream)this.inputMessage);
            int b = pin.read();
            if (b < 0) {
                this.inputStream = new ByteArrayInputStream(new byte[0]);
                super.initStream();
                super.setWrappedStream((InputStream)this.inputStream);
                return;
            }
            pin.unread(b);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int c = 0;
            while ((c = pin.read()) != -1) {
                bos.write(c);
            }
            try {
                this.message = WSProviderHelper.getDocumentBuilder().parse(new ByteArrayInputStream(bos.toByteArray()));
            }
            catch (SAXException e) {
                this.log.error("The response doesn't contain a valid SOAP message ; \n" + e.getMessage());
                throw WSSecurityException.INVALID_SECURITY;
            }
            WSTimestampHeader timestampHeader = this.wsSecurity.getTimestampHeader(this.message);
            if (timestampHeader != null) {
                timestampHeader.validate();
            }
            WSSecurityHeader[] securityHeaders = null;
            securityHeaders = this.wsSecurity.getSecurityHeaders(this.message);
            if (securityHeaders.length > 0) {
                int i = 0;
                while (i < securityHeaders.length) {
                    WSSecurityHeader securityHeader = securityHeaders[i];
                    securityHeader.decryptAndVerify();
                    ++i;
                }
            } else {
                IncomingValidator validator = WSSecurityHeaderImpl.getValidatorInstance();
                if (validator != null) {
                    validator.validate((MessageConf)Configurator.newRuntimeConfigurable().narrow(class$org$systinet$wasp$security$ws$conf$MessageConf == null ? (class$org$systinet$wasp$security$ws$conf$MessageConf = WSSecurityInputMessage.class$("org.systinet.wasp.security.ws.conf.MessageConf")) : class$org$systinet$wasp$security$ws$conf$MessageConf));
                }
            }
            if (timestampHeader != null) {
                timestampHeader.removeFromMessage();
            }
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            callContext.getContextData().put(WSSecurityImpl.UNSESURE_OUTPUT, Boolean.TRUE);
            if (e instanceof WSSecurityException) {
                callContext.getContextData().put("incomingException", e);
            }
            this.inputMessage.close();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage());
        }
        this.inputStream = new ByteArrayInputStream(this.wsSecurity.byteArrayFromDOM(this.message));
        super.setWrappedStream((InputStream)this.inputStream);
    }

    public void close() throws IOException {
        this.inputMessage.close();
        super.close();
    }

    public int getStatusCode() throws IOException {
        if (this.inputMessage != null) {
            return this.inputMessage.getStatusCode();
        }
        throw new IOException("Cannot get status code on the null input message");
    }

    public Set getHeaderNames() throws IOException {
        if (this.inputMessage != null) {
            return this.inputMessage.getHeaderNames();
        }
        throw new IOException("Cannot get header names on the null input message");
    }

    public String getStringHeader(String name) throws IOException {
        if (this.inputMessage != null) {
            return this.inputMessage.getStringHeader(name);
        }
        throw new IOException("Cannot get status code on the null input message");
    }

    public String getContentType() throws IOException {
        return this.inputMessage.getContentType();
    }

    public boolean nextPart() throws IOException {
        if (!this.nextPart) {
            this.nextPart = true;
        } else {
            this.setWrappedStream((InputStream)this.inputMessage);
        }
        return this.inputMessage.nextPart();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

