/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.iface.WSTimestampHeader;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.WSSEConf;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSTimestampHeaderImpl
implements WSTimestampHeader {
    private static final Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.impl.WSTimestampHeaderImpl");
    private Element createdElement = null;
    private Element expiresElement = null;
    private Document message = null;
    private long clockSkew = 300000L;
    private long timestampExpiration = 300000L;
    private String wsuNamespace = null;
    private Element constructionElement = null;

    public WSTimestampHeaderImpl(Document message, String wsseNamespace, String wsuNamespace, String role, String mustUnderstand, String timestampId) {
        WSSEConf wsseConf = WSSecurityHelper.getSecurityConfiguration();
        Integer tmpInteger = wsseConf.getClockSkew();
        if (tmpInteger != null) {
            this.clockSkew = tmpInteger.intValue();
        }
        if ((tmpInteger = wsseConf.getTimestampHeaderExpiration()) != null) {
            this.timestampExpiration = tmpInteger.intValue();
        }
        this.message = message;
        this.wsuNamespace = wsuNamespace;
        Element documentElement = message.getDocumentElement();
        Element headerElement = null;
        Element bodyElement = null;
        Element constructionElement = null;
        WSSEConf securityConf = WSSecurityHelper.getSecurityConfiguration();
        String soapNamespaceUri = documentElement.getNamespaceURI();
        NodeList childs = documentElement.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            if (child.getNodeType() == 1 && soapNamespaceUri.equals(child.getNamespaceURI())) {
                String childLocalName = child.getLocalName();
                if (childLocalName.equals("Body")) {
                    bodyElement = (Element)child;
                } else if (childLocalName.equals("Header")) {
                    headerElement = (Element)child;
                    NodeList headerChilds = child.getChildNodes();
                    int j = 0;
                    while (j < headerChilds.getLength()) {
                        Node headerChild = headerChilds.item(j);
                        if (headerChild.getNodeType() == 1 && headerChild.getLocalName().equals("Timestamp") && WSSecurity.KNOWN_WSU_URI_LIST.contains(child.getNamespaceURI())) {
                            throw new WSSecurityException(null, "There is already a Timestamp header in the message");
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        String soapPrefix = documentElement.getPrefix();
        if (headerElement == null && !WSSecurity.LATE_DRAFT_SECURITY_URI_LIST.contains(wsseNamespace)) {
            headerElement = soapPrefix == null || soapPrefix.length() == 0 ? message.createElementNS(soapNamespaceUri, "Header") : message.createElementNS(soapNamespaceUri, soapPrefix + ":" + "Header");
            documentElement.insertBefore(headerElement, bodyElement);
        }
        constructionElement = message.createElementNS(wsuNamespace, WSSecurityImpl.getWsuPrefix() + ":" + "Timestamp");
        constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + WSSecurityImpl.getWsuPrefix(), wsuNamespace);
        if (timestampId != null) {
            constructionElement.setAttributeNS(wsuNamespace, WSSecurityImpl.getWsuPrefix() + ":" + "Id", timestampId);
        }
        if (soapPrefix == null || soapPrefix.length() == 0) {
            soapPrefix = "soap";
            if (WSSecurityImpl.getWsuPrefix().equals(soapPrefix)) {
                soapPrefix = "S";
            }
            constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + soapPrefix, soapNamespaceUri);
        }
        if (mustUnderstand == null) {
            mustUnderstand = "0";
        }
        if (!WSSecurity.LATE_DRAFT_SECURITY_URI_LIST.contains(wsseNamespace)) {
            constructionElement.setAttributeNS(soapNamespaceUri, soapPrefix + ":" + "mustUnderstand", mustUnderstand);
        }
        if (role != null) {
            constructionElement.setAttributeNS(soapNamespaceUri, soapPrefix + ":" + "role", role);
        }
        this.createdElement = message.createElementNS(wsuNamespace, WSSecurityImpl.getWsuPrefix() + ":" + "Created");
        constructionElement.appendChild(this.createdElement);
        this.constructionElement = constructionElement;
        Date current = WSSecurityImpl.getUtcCalendar().getCurrentTime();
        this.setCreated(current);
        long expTime = current.getTime() + this.timestampExpiration;
        current.setTime(expTime);
        if (!(this.timestampExpiration == -1L || securityConf != null && Boolean.TRUE.equals(securityConf.getIgnoreTimestampHeaderExpiration()))) {
            this.setExpires(current);
        }
        if (!WSSecurity.LATE_DRAFT_SECURITY_URI_LIST.contains(wsseNamespace)) {
            headerElement.appendChild(constructionElement);
        }
    }

    public Element getTimestampElement() {
        return this.constructionElement;
    }

    public WSTimestampHeaderImpl(Element element) {
        Node[] tmpElements;
        WSSEConf wsseConf = WSSecurityHelper.getSecurityConfiguration();
        Integer tmpInteger = wsseConf.getClockSkew();
        if (tmpInteger != null) {
            this.clockSkew = tmpInteger.intValue();
        }
        if ((tmpInteger = wsseConf.getTimestampHeaderExpiration()) != null) {
            this.timestampExpiration = tmpInteger.intValue();
        }
        boolean ignoreExp = false;
        WSSEConf securityConf = WSSecurityHelper.getSecurityConfiguration();
        if (securityConf != null && Boolean.TRUE.equals(securityConf.getIgnoreTimestampHeaderExpiration())) {
            ignoreExp = true;
        }
        if ((tmpElements = WSSecurityHelper.getElementNS(WSSecurity.KNOWN_WSU_URI, "Created", element)).length != 1) {
            throw new RuntimeException("Created element in the timestamp header must be exactly one");
        }
        if (tmpElements[0].getNodeType() != 1) {
            throw new RuntimeException("Wrong node in the timestamp header");
        }
        this.createdElement = (Element)tmpElements[0];
        tmpElements = WSSecurityHelper.getElementNS(WSSecurity.KNOWN_WSU_URI, "Expires", element);
        if (tmpElements.length != 1 && !ignoreExp) {
            throw new RuntimeException("Expires element in the timestamp header must be exactly one");
        }
        this.expiresElement = ignoreExp ? null : (Element)tmpElements[0];
        this.constructionElement = element;
    }

    public void setExpires(Date time) {
        if (time != null) {
            Element oldExpiresElement = this.expiresElement;
            this.expiresElement = this.message.createElementNS(this.wsuNamespace, WSSecurityImpl.getWsuPrefix() + ":" + "Expires");
            if (oldExpiresElement == null) {
                this.constructionElement.appendChild(this.expiresElement);
            } else {
                this.constructionElement.replaceChild(this.expiresElement, oldExpiresElement);
            }
            this.setTimeElement(time, this.expiresElement);
        }
    }

    public Date getExpires() {
        try {
            return WSSecurityImpl.getUtcDateFormat().parse(WSSecurityHelper.getTextNodeValue(this.expiresElement));
        }
        catch (ParseException e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setCreated(Date time) {
        this.setTimeElement(time, this.createdElement);
    }

    private void setTimeElement(Date time, Element timeElement) {
        String formattedCreated = WSSecurityImpl.getUtcDateFormat().format(time);
        if (formattedCreated == null) {
            throw new RuntimeException("An error occured when processing date : " + time.toString() + " " + WSSecurityImpl.getUtcDateFormat().toString());
        }
        Text t = this.message.createTextNode(formattedCreated);
        Node old = timeElement.getFirstChild();
        if (old == null) {
            timeElement.appendChild(t);
        } else {
            timeElement.replaceChild(t, old);
        }
    }

    public Date getCreated() {
        try {
            return WSSecurityHelper.parseDate(WSSecurityHelper.getTextNodeValue(this.createdElement));
        }
        catch (ParseException e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void validate() throws WSSecurityException {
        Date current = WSSecurityImpl.getUtcCalendar().getCurrentTime();
        Date expires = null;
        if (this.expiresElement != null) {
            expires = this.getExpires();
            if (current.after(expires)) {
                throw new RuntimeWrappedException("The timestamp header is expired, rejecting the message");
            }
        } else {
            log.debug("No validation was performed, expires value ignored");
            return;
        }
        if (this.createdElement == null) {
            log.error("The received timestamp header contains no Created value");
            throw new RuntimeWrappedException("The received timestamp header contains no Created value");
        }
        Date created = this.getCreated();
        Calendar skewCal = (Calendar)((Calendar)WSSecurityImpl.getUtcCalendar()).clone();
        WSSecurityImpl.getUtcCalendar();
        skewCal.add(14, (int)this.clockSkew);
        if (!created.before(skewCal.getTime())) {
            throw new RuntimeWrappedException("The Created value of the received timestamp header is not valid: Created " + created + " > Current time " + skewCal.getTime());
        }
        if (expires != null && created.after(expires)) {
            throw new RuntimeWrappedException("The Expires value is before Created value : Created  " + created + " > Expires " + expires);
        }
    }

    public void removeFromMessage() {
        this.constructionElement.getParentNode().removeChild(this.constructionElement);
    }
}

