/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.iface.WSSecurityHeader;
import com.systinet.wasp.security.ws.impl.EncryptedDataObject;
import com.systinet.wasp.security.ws.impl.EncryptedKeyObject;
import com.systinet.wasp.security.ws.impl.InternalWSSecurityContext;
import com.systinet.wasp.security.ws.impl.ReferenceListObject;
import com.systinet.wasp.security.ws.impl.SecurityTokenObject;
import com.systinet.wasp.security.ws.impl.SignatureSecurityObject;
import com.systinet.wasp.security.ws.impl.WSIdResolver;
import com.systinet.wasp.security.ws.impl.WSKeyInfo;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import com.systinet.wasp.security.ws.impl.WSSecurityObject;
import com.systinet.wasp.security.ws.impl.WSTimestampHeaderImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.idoox.config.Configurator;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.PStore;
import org.systinet.wasp.security.ws.IncomingValidator;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.SecurityTokenHandlerSPI;
import org.systinet.wasp.security.ws.SecurityTokenSPI;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.EncryptedDataConf;
import org.systinet.wasp.security.ws.conf.EncryptedKeyConf;
import org.systinet.wasp.security.ws.conf.ExternalSecurityTokensConf;
import org.systinet.wasp.security.ws.conf.MessageConf;
import org.systinet.wasp.security.ws.conf.OrderedElementConf;
import org.systinet.wasp.security.ws.conf.ReferenceListConf;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;
import org.systinet.wasp.security.ws.conf.SignatureConf;
import org.systinet.wasp.security.ws.conf.WSSEGlobalConf;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSecurityHeaderImpl
implements WSSecurityHeader,
InternalWSSecurityContext {
    private static Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.com.WSSecurityHeader");
    private Document message = null;
    private Vector tokenHandlers;
    private String wsseNamespace;
    private String wsuNamespace;
    private WSSEGlobalConf globalConfiguration;
    private long clockSkew;
    private Element documentElement = null;
    private String soapNamespaceUri = null;
    private String soapPrefix = null;
    private Element constructionElement = null;
    private Map securityObjects = new HashMap();
    private Map signatures = new HashMap();
    private Element bodyElement = null;
    private List securityTokens = null;
    private Element headerElement = null;
    private PStore pStore;
    private MessageConf messageConf = null;
    Vector tokenConfs = new Vector();
    Vector signatureConfs = new Vector();
    Vector dataConfs = new Vector();
    Vector encryptedKeyConfs = new Vector();
    Vector referenceListConfs = new Vector();
    int order = 0;
    static /* synthetic */ Class class$org$systinet$wasp$security$ws$conf$MessageConf;

    public WSSecurityHeaderImpl(Document message, Vector tokenHandlers, String wsseNamespace, String wsuNamespace, String role, String mustUnderstand, WSSEGlobalConf globalConf, Element timestampElement) throws WSSecurityException {
        this.message = message;
        this.tokenHandlers = tokenHandlers;
        this.wsseNamespace = wsseNamespace;
        this.wsuNamespace = wsuNamespace;
        this.globalConfiguration = globalConf;
        this.createHeaderElement(role, mustUnderstand);
        this.headerElement.appendChild(this.constructionElement);
        if (WSSecurity.LATE_DRAFT_SECURITY_URI_LIST.contains(wsseNamespace) && timestampElement != null) {
            this.prependSecurityElement(timestampElement);
        }
        this.securityTokens = new LinkedList();
        try {
            this.pStore = PStore.getInstance(null);
        }
        catch (BadPasswordException e) {
            log.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
    }

    public WSSecurityHeaderImpl(Element soapHeaderElement, Element securityHeaderElement, Vector tokenHandlers, String wsseNamespace, WSSEGlobalConf globalConf, long clockSkew) throws WSSecurityException {
        this.tokenHandlers = tokenHandlers;
        this.wsseNamespace = wsseNamespace;
        this.globalConfiguration = globalConf;
        this.clockSkew = clockSkew;
        if (!WSSecurity.RC_SECURITY_URI_LIST.contains(this.wsseNamespace)) {
            this.wsuNamespace = wsseNamespace.substring(0, wsseNamespace.length() - 6) + "utility";
        } else {
            int index = wsseNamespace.indexOf("secext");
            if (index == -1) {
                log.error("Unable to determine wsu namespace");
                throw WSSecurityException.INVALID_SECURITY;
            }
            this.wsuNamespace = wsseNamespace.substring(0, index) + "utility" + wsseNamespace.substring(index + 6);
        }
        this.message = securityHeaderElement.getOwnerDocument();
        this.constructionElement = securityHeaderElement;
        this.headerElement = soapHeaderElement;
        this.soapPrefix = soapHeaderElement.getPrefix();
        this.soapNamespaceUri = soapHeaderElement.getNamespaceURI();
        this.securityTokens = new LinkedList();
        try {
            this.pStore = PStore.getInstance(null);
        }
        catch (BadPasswordException e) {
            log.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
    }

    private void createHeaderElement(String role, String mustUnderstand) throws WSSecurityException {
        this.documentElement = this.message.getDocumentElement();
        this.soapNamespaceUri = this.documentElement.getNamespaceURI();
        this.soapPrefix = this.documentElement.getPrefix();
        NodeList childs = this.documentElement.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            if (child.getNodeType() == 1 && this.soapNamespaceUri.equals(child.getNamespaceURI())) {
                String childLocalName = child.getLocalName();
                if (childLocalName.equals("Body")) {
                    this.bodyElement = (Element)child;
                } else if (childLocalName.equals("Header")) {
                    this.headerElement = (Element)child;
                    if (role != null) {
                        NodeList headerChilds = child.getChildNodes();
                        int j = 0;
                        while (j < headerChilds.getLength()) {
                            Node headerChild = headerChilds.item(j);
                            if (headerChild.getNodeType() == 1 && headerChild.getLocalName().equals("Security") && WSSecurity.KNOWN_SECURITY_URI_LIST.contains(child.getNamespaceURI()) && !((Element)headerChild).hasAttributeNS(this.soapNamespaceUri, "role")) {
                                throw new WSSecurityException(null, "There is already a security header without defined soap:role");
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        if (this.headerElement == null) {
            this.headerElement = this.soapPrefix == null || this.soapPrefix.length() == 0 ? this.message.createElementNS(this.soapNamespaceUri, "Header") : this.message.createElementNS(this.soapNamespaceUri, this.soapPrefix + ":" + "Header");
            this.documentElement.insertBefore(this.headerElement, this.bodyElement);
        }
        this.constructionElement = this.message.createElementNS(this.getWsseNamespace(), WSSecurityImpl.getWssePrefix() + ":" + "Security");
        this.constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + WSSecurityImpl.getWssePrefix(), this.getWsseNamespace());
        this.constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + WSSecurityImpl.getWsuPrefix(), this.getWsuNamespace());
        if (this.soapPrefix == null || this.soapPrefix.length() == 0) {
            this.soapPrefix = "soap";
            if (WSSecurityImpl.getWsuPrefix().equals(this.soapPrefix)) {
                this.soapPrefix = this.soapPrefix + 'x';
            }
            if (WSSecurityImpl.getWssePrefix().equals(this.soapPrefix)) {
                this.soapPrefix = this.soapPrefix + WSSecurityImpl.getWsuPrefix();
            }
            this.constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + this.soapPrefix, this.soapNamespaceUri);
        }
        if (mustUnderstand == null) {
            mustUnderstand = "1";
        }
        this.constructionElement.setAttributeNS(this.soapNamespaceUri, this.soapPrefix + ":" + "mustUnderstand", mustUnderstand);
        if (role != null) {
            this.constructionElement.setAttributeNS(this.soapNamespaceUri, this.soapPrefix + ":" + "role", role);
        }
    }

    public void decryptAndVerify() throws WSSecurityException {
        NodeList childs = this.constructionElement.getChildNodes();
        CallContext callContext = Current.getCallContext();
        callContext.getContextData().put(WSSecurityImpl.WSSECURITY_CONTEXT_KEY, this);
        try {
            NodeList elementsByTagNameNS = this.message.getDocumentElement().getElementsByTagNameNS(this.soapNamespaceUri, "Body");
            if (elementsByTagNameNS != null && elementsByTagNameNS.getLength() == 1) {
                this.bodyElement = (Element)elementsByTagNameNS.item(0);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this.bodyElement == null) {
            log.error("Cannot find SOAP message Body");
            throw WSSecurityException.INVALID_SECURITY;
        }
        ExternalSecurityTokensConf externalSecurityTokens = WSSecurityHelper.getExternalSecurityTokensConf();
        if (externalSecurityTokens != null) {
            SecurityTokenConf[] securityTokenConfs = externalSecurityTokens.getSecurityTokens();
            int i = 0;
            while (i < securityTokenConfs.length) {
                SecurityTokenObject tokenObject = new SecurityTokenObject(this, securityTokenConfs[i], true);
                this.securityObjects.put(tokenObject.getWsuId(), tokenObject);
                tokenObject.doFinal();
                ++i;
            }
        }
        this.messageConf = (MessageConf)Configurator.newRuntimeConfigurable().narrow(class$org$systinet$wasp$security$ws$conf$MessageConf == null ? (class$org$systinet$wasp$security$ws$conf$MessageConf = WSSecurityHeaderImpl.class$("org.systinet.wasp.security.ws.conf.MessageConf")) : class$org$systinet$wasp$security$ws$conf$MessageConf);
        try {
            int i = 0;
            while (i < childs.getLength()) {
                Node child = null;
                child = childs.item(i);
                if (child.getNodeType() == 1) {
                    String localName = child.getLocalName();
                    String namespaceURI = child.getNamespaceURI();
                    if (localName != null && (localName.equals("BinarySecurityToken") || localName.equals("UsernameToken")) && WSSecurity.KNOWN_SECURITY_URI_LIST.contains(namespaceURI)) {
                        SecurityTokenObject tokenObject = new SecurityTokenObject((SecurityContext)this, (Element)child);
                        this.securityObjects.put(tokenObject.getWsuId(), tokenObject);
                        tokenObject.doFinal();
                    } else if (localName != null && localName.equals("Signature") && WSSecurity.KNOWN_DS_URI_LIST.contains(namespaceURI)) {
                        SignatureSecurityObject signatureObject = new SignatureSecurityObject((SecurityContext)this, (Element)child);
                        this.securityObjects.put(signatureObject.getWsuId(), signatureObject);
                        signatureObject.doFinal();
                    } else if ("EncryptedKey".equals(localName) && WSSecurityImpl.encNamespace.equals(namespaceURI)) {
                        EncryptedKeyObject ekh = new EncryptedKeyObject((SecurityContext)this, (Element)child);
                        ekh.doFinal();
                    } else if (!"EncryptedData".equals(localName) || !WSSecurityImpl.encNamespace.equals(namespaceURI)) {
                        if ("ReferenceList".equals(localName) && WSSecurityImpl.encNamespace.equals(namespaceURI)) {
                            ReferenceListObject rlo = new ReferenceListObject((SecurityContext)this, (Element)child);
                            rlo.doFinal();
                        } else if ("Timestamp".equals(localName) && WSSecurity.KNOWN_WSU_URI_LIST.contains(namespaceURI)) {
                            WSTimestampHeaderImpl timestampHeader = new WSTimestampHeaderImpl((Element)child);
                            timestampHeader.validate();
                        }
                    }
                }
                ++i;
            }
            try {
                this.runValidator(WSSecurityHeaderImpl.getValidatorInstance());
            }
            catch (WSSecurityException e) {
                log.error("", (Throwable)((Object)e));
                throw WSSecurityException.FAILED_CHECK;
            }
            this.removeHeader();
            Object var10_13 = null;
            callContext.getContextData().remove(WSSecurityImpl.WSSECURITY_CONTEXT_KEY);
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            callContext.getContextData().remove(WSSecurityImpl.WSSECURITY_CONTEXT_KEY);
            throw throwable;
        }
    }

    public static IncomingValidator getValidatorInstance() {
        IncomingValidator validator = WSSecurityHelper.getValidatorInstance();
        if (validator != null) {
            return validator;
        }
        Class validatorClass = WSSecurityHelper.getValidatorClassConf();
        if (validatorClass == null) {
            return null;
        }
        try {
            validator = (IncomingValidator)validatorClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error("", (Throwable)e);
            throw WSSecurityException.FAILED_CHECK;
        }
        catch (IllegalAccessException e) {
            log.error("", (Throwable)e);
            throw WSSecurityException.FAILED_CHECK;
        }
        catch (ClassCastException e) {
            log.error("", (Throwable)e);
            throw WSSecurityException.FAILED_CHECK;
        }
        return validator;
    }

    private void runValidator(IncomingValidator validator) {
        if (validator == null) {
            return;
        }
        int totalSize = this.signatureConfs.size() + this.encryptedKeyConfs.size() + this.dataConfs.size() + this.tokenConfs.size() + this.referenceListConfs.size();
        this.correctOrder(this.signatureConfs, totalSize);
        this.correctOrder(this.encryptedKeyConfs, totalSize);
        this.correctOrder(this.dataConfs, totalSize);
        this.correctOrder(this.tokenConfs, totalSize);
        this.correctOrder(this.referenceListConfs, totalSize);
        if (this.signatureConfs.size() != 0) {
            this.messageConf.setSignatures(this.signatureConfs.toArray(new SignatureConf[0]));
        }
        if (this.encryptedKeyConfs.size() != 0) {
            this.messageConf.setEncryptedKeys(this.encryptedKeyConfs.toArray(new EncryptedKeyConf[0]));
        }
        if (this.dataConfs.size() != 0) {
            this.messageConf.setEncryptedData(this.dataConfs.toArray(new EncryptedDataConf[0]));
        }
        if (this.tokenConfs.size() != 0) {
            this.messageConf.setSecurityTokens(this.tokenConfs.toArray(new SecurityTokenConf[0]));
        }
        if (this.referenceListConfs.size() != 0) {
            this.messageConf.setReferenceLists(this.referenceListConfs.toArray(new ReferenceListConf[0]));
        }
        validator.validate(this.messageConf);
    }

    private void correctOrder(Vector confs, int totalSize) {
        int i = 0;
        while (i < confs.size()) {
            OrderedElementConf signatureConf = (OrderedElementConf)confs.elementAt(i);
            signatureConf.setOrder(new Integer(totalSize - signatureConf.getOrder()));
            ++i;
        }
    }

    public Object addSecurityToken(SecurityTokenConf securityTokenConf, boolean isExternal) throws WSSecurityException {
        SecurityTokenObject o = new SecurityTokenObject(this, securityTokenConf, isExternal);
        return o;
    }

    public Object createSignature(SignatureConf signatureConfig) throws WSSecurityException {
        SignatureSecurityObject o = new SignatureSecurityObject((SecurityContext)this, signatureConfig);
        return o;
    }

    public Object getSignature(String wsuId) {
        return this.signatures.get(wsuId);
    }

    public Object[] getSignatures() {
        return this.signatures.values().toArray();
    }

    public MessageConf getMessageConf() {
        return this.messageConf;
    }

    private void removeHeader() {
        this.headerElement.removeChild(this.constructionElement);
    }

    public Element getSecurityElement() {
        return this.constructionElement;
    }

    public Object createEncryptedKey(EncryptedKeyConf conf) throws WSSecurityException {
        EncryptedKeyObject o = new EncryptedKeyObject((SecurityContext)this, conf);
        return o;
    }

    public Object createEncryptedData(EncryptedDataConf conf) throws WSSecurityException {
        EncryptedDataObject o = new EncryptedDataObject((SecurityContext)this, conf);
        return o;
    }

    public Object createReferenceList(ReferenceListConf conf) throws WSSecurityException {
        ReferenceListObject o = new ReferenceListObject((SecurityContext)this, conf);
        return o;
    }

    public Document getMessage() {
        return this.message;
    }

    public WSSecurityObject[] getSecurityObjects() throws WSSecurityException {
        return this.securityObjects.values().toArray(new WSSecurityObject[0]);
    }

    public void addSecurityObject(WSSecurityObject securityObject) throws WSSecurityException {
        this.securityObjects.put(securityObject.getWsuId(), securityObject);
    }

    public void removeSecurityObject(WSSecurityObject securityObject) throws WSSecurityException {
        this.securityObjects.remove(securityObject);
    }

    public Element resolveElementById(String id) throws WSSecurityException {
        return WSIdResolver.getElementById(this.message, id);
    }

    public WSSecurityObject resolveSecurityObjectById(String id) throws WSSecurityException {
        return (WSSecurityObject)this.securityObjects.get(id);
    }

    public WSSecurityObject[] resolveSecurityObjectByType(Class securityObjectBaseClass) throws WSSecurityException {
        Iterator it = this.securityObjects.values().iterator();
        LinkedList<WSSecurityObject> retVal = new LinkedList<WSSecurityObject>();
        while (it.hasNext()) {
            WSSecurityObject wsSecurityObject = (WSSecurityObject)it.next();
            if (!wsSecurityObject.getClass().isAssignableFrom(securityObjectBaseClass)) continue;
            retVal.add(wsSecurityObject);
        }
        return retVal.toArray(new WSSecurityObject[0]);
    }

    public void prependSecurityElement(Element securityElement) throws WSSecurityException {
        Node firstChild = this.constructionElement.getFirstChild();
        if (firstChild == null) {
            this.constructionElement.appendChild(securityElement);
        } else {
            this.constructionElement.insertBefore(securityElement, firstChild);
        }
    }

    public Document getMessageDocument() throws WSSecurityException {
        return this.message;
    }

    public String getWsuIdFor(int messagePartId) {
        switch (messagePartId) {
            case 0: {
                return this.processBodyId();
            }
        }
        return null;
    }

    public PStore getPStore() throws WSSecurityException {
        return this.pStore;
    }

    public void addSecurityToken(SecurityTokenSPI securityToken) throws WSSecurityException {
        this.securityTokens.add(securityToken);
    }

    public void removeSecurityToken(SecurityTokenSPI securityToken) throws WSSecurityException {
        this.securityTokens.remove(securityToken);
    }

    public SecurityTokenSPI[] getSecurityTokens() throws WSSecurityException {
        return this.securityTokens.toArray(new SecurityTokenSPI[0]);
    }

    public Object getImplementationSpecificObject(int objectId) throws WSSecurityException {
        return null;
    }

    public SecurityTokenHandlerSPI[] getTokenHandlers() {
        return this.tokenHandlers.toArray(new SecurityTokenHandlerSPI[0]);
    }

    public WSKeyInfo getDefaultWSKeyInfo() {
        return null;
    }

    public String getWsseNamespace() {
        return this.wsseNamespace;
    }

    public String getWsuNamespace() {
        return this.wsuNamespace;
    }

    public String getSoapPrefix() {
        return this.soapPrefix;
    }

    public String getSoapNamespaceUri() {
        return this.soapNamespaceUri;
    }

    public Element getDocumentElement() {
        return this.documentElement;
    }

    private String processBodyId() {
        Attr wsuIdAttr = this.bodyElement.getAttributeNodeNS(this.getWsuNamespace(), "Id");
        if (wsuIdAttr == null) {
            if (this.bodyElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", WSSecurityImpl.getWsuPrefix()) == null) {
                this.bodyElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + WSSecurityImpl.getWsuPrefix(), this.getWsuNamespace());
            }
            wsuIdAttr = this.message.createAttributeNS(this.getWsuNamespace(), WSSecurityImpl.getWsuPrefix() + ":" + "Id");
            wsuIdAttr.setValue("Body-" + WSSecurityImpl.genId());
            this.bodyElement.setAttributeNode(wsuIdAttr);
        }
        return wsuIdAttr.getValue();
    }

    public WSSEGlobalConf getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public void addReceivedSecurityTokenConf(SecurityTokenConf tokenConf) {
        if (tokenConf == null) {
            return;
        }
        tokenConf.setOrder(new Integer(this.order++));
        this.tokenConfs.add(tokenConf);
    }

    public void addReceivedSignatureConf(SignatureConf signatureConf) {
        if (signatureConf == null) {
            return;
        }
        signatureConf.setOrder(new Integer(this.order++));
        this.signatureConfs.add(signatureConf);
    }

    public void addReceivedEncryptedDataConf(EncryptedDataConf dataConf) {
        if (dataConf == null) {
            return;
        }
        dataConf.setOrder(new Integer(this.order++));
        this.dataConfs.add(dataConf);
    }

    public void addReceivedEncryptedKeyConf(EncryptedKeyConf keyConf) {
        if (keyConf == null) {
            return;
        }
        keyConf.setOrder(new Integer(this.order++));
        this.encryptedKeyConfs.add(keyConf);
    }

    public void addReceivedReferenceListConf(ReferenceListConf refListConf) {
        if (refListConf == null) {
            return;
        }
        refListConf.setOrder(new Integer(this.order++));
        this.referenceListConfs.add(refListConf);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

