/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.Base64DecodingException;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.secext.utils.ElementProxy;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.impl.InternalWSSecurityContext;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import java.security.Key;
import java.util.Arrays;
import org.systinet.wasp.security.ws.SecurityTokenSPI;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.w3c.dom.Element;

public class WSKeyResolver {
    private static final Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$ws$impl$WSKeyResolver == null ? (class$com$systinet$wasp$security$ws$impl$WSKeyResolver = WSKeyResolver.class$("com.systinet.wasp.security.ws.impl.WSKeyResolver")) : class$com$systinet$wasp$security$ws$impl$WSKeyResolver).getName());
    static /* synthetic */ Class class$com$systinet$wasp$security$ws$impl$WSKeyResolver;

    protected Key getKeyOfType(SecurityTokenSPI token, Class type) {
        if (token == null || type == null) {
            return null;
        }
        Key key = token.getDecryptingKey();
        if (key != null && type.isAssignableFrom(key.getClass())) {
            return key;
        }
        key = token.getEncryptingKey();
        if (key != null && type.isAssignableFrom(key.getClass())) {
            return key;
        }
        key = token.getSigningKey();
        if (key != null && type.isAssignableFrom(key.getClass())) {
            return key;
        }
        key = token.getAuthenticatingKey();
        if (key != null && type.isAssignableFrom(key.getClass())) {
            return key;
        }
        return null;
    }

    public static SecurityTokenSPI resolverSecurityToken(Element element, InternalWSSecurityContext securityContext) {
        block16: {
            SecurityTokenSPI[] securityTokens;
            block14: {
                String uri;
                Element keyReference;
                block15: {
                    securityTokens = securityContext.getSecurityTokens();
                    if (!"SecurityTokenReference".equals(element.getLocalName()) || !WSSecurity.KNOWN_SECURITY_URI_LIST.contains(element.getNamespaceURI())) break block14;
                    Element keyIdentifier = (Element)WSSecurityHelper.getSingleElementNS(WSSecurity.KNOWN_SECURITY_URI, "KeyIdentifier", element);
                    keyReference = (Element)WSSecurityHelper.getSingleElementNS(WSSecurity.KNOWN_SECURITY_URI, "Reference", element);
                    if (keyIdentifier == null) break block15;
                    String wssePrefix = ElementProxy.getDefaultPrefix(securityContext.getWsseNamespace());
                    String encodingType = null;
                    String wsseNamespace = securityContext.getWsseNamespace();
                    encodingType = !WSSecurity.RC_SECURITY_URI_LIST.contains(wsseNamespace) ? wssePrefix + ":" + "Base64Binary" : WSSecurityHelper.fromNs2SpecLocation(wsseNamespace) + "#" + "Base64Binary";
                    String encoding = keyIdentifier.getAttributeNS(null, "EncodingType");
                    if (encoding != null && !encoding.equals("") && !encoding.equals(encodingType)) {
                        cat.error("KeyIdentifier supports Base64Encoding only");
                        throw WSSecurityException.INVALID_SECURITY;
                    }
                    byte[] keyId = null;
                    try {
                        keyId = Base64.decode(keyIdentifier);
                        if (keyId == null) {
                            cat.error("cannot get keyIdentifier value for keyInfo");
                            throw WSSecurityException.SECURITY_TOKEN_UNAVAILABLE;
                        }
                    }
                    catch (Base64DecodingException e) {
                        cat.error("", (Throwable)e);
                        throw WSSecurityException.INVALID_SECURITY;
                    }
                    int i = 0;
                    while (i < securityTokens.length) {
                        byte[] soki = securityTokens[i].getKeyIdentifier();
                        if (Arrays.equals(soki, keyId)) {
                            return securityTokens[i];
                        }
                        ++i;
                    }
                    StringBuffer msg = new StringBuffer("KeyIdentifier security token reference was not resolved. KeyIdentifier reference value=");
                    int i2 = 0;
                    while (i2 < keyId.length) {
                        String p = Integer.toHexString(keyId[i2] & 0xFF);
                        if (p.length() == 1) {
                            msg.append("0");
                        }
                        msg.append(p).append(" ");
                        ++i2;
                    }
                    cat.warn((Object)msg);
                    break block16;
                }
                if (keyReference == null || (uri = keyReference.getAttributeNS(null, "URI")) == null || !uri.startsWith("#")) break block16;
                String id = uri.substring(1);
                int i = 0;
                while (i < securityTokens.length) {
                    if (id.equals(securityTokens[i].getWsuId())) {
                        return securityTokens[i];
                    }
                    ++i;
                }
                break block16;
            }
            if ("KeyName".equals(element.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(element.getNamespaceURI())) {
                String name = XMLUtils.getFullTextChildrenFromElement(element);
                if (name == null) {
                    return null;
                }
                int i = 0;
                while (i < securityTokens.length) {
                    if (name.equals(securityTokens[i].getWsuId())) {
                        return securityTokens[i];
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

