/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.keys.KeyInfo;
import com.systinet.wasp.security.secext.keys.content.KeyName;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverException;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.secext.utils.ElementProxy;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.impl.InternalWSSecurityContext;
import com.systinet.wasp.security.ws.impl.SecurityTokenObject;
import com.systinet.wasp.security.ws.impl.WSKeyInfo;
import com.systinet.wasp.security.ws.impl.WSKeyResolver;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import com.systinet.wasp.security.ws.impl.WSSecurityObject;
import java.security.Key;
import java.security.PublicKey;
import org.systinet.wasp.security.ws.SecurityTokenSPI;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.KeyInfoConf;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSKeyInfoImpl
implements WSKeyInfo {
    private static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$ws$impl$WSKeyInfoImpl == null ? (class$com$systinet$wasp$security$ws$impl$WSKeyInfoImpl = WSKeyInfoImpl.class$("com.systinet.wasp.security.ws.impl.WSKeyInfoImpl")) : class$com$systinet$wasp$security$ws$impl$WSKeyInfoImpl).getName());
    private KeyInfo apacheKeyInfo;
    private WSSecurityObject parent;
    private KeyInfoConf keyInfoConf;
    private SecurityTokenSPI securityToken;
    private String mode = null;
    private String referencedWsuId = null;
    private String strWsuId = null;
    private String wsuId = null;
    static /* synthetic */ Class class$com$systinet$wasp$security$ws$impl$WSKeyInfoImpl;

    public WSKeyInfoImpl(WSSecurityObject parent, KeyInfoConf keyInfoConf) throws WSSecurityException {
        this.parent = parent;
        this.keyInfoConf = keyInfoConf;
        KeyInfo apacheKeyInfo = new KeyInfo(parent.getSecurityContext().getMessageDocument());
        if (this.keyInfoConf != null) {
            this.setWrappedKeyInfo(apacheKeyInfo);
        }
    }

    public WSKeyInfoImpl(WSSecurityObject parent, KeyInfo apacheKeyInfo) throws WSSecurityException {
        this.parent = parent;
        this.setWrappedKeyInfo(apacheKeyInfo);
    }

    public void doFinal() throws WSSecurityException {
        if (this.parent.getMode() == 0) {
            this.doFinalGenerate();
        } else {
            this.doFinalReceive();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doFinalGenerate() throws WSSecurityException {
        String id;
        KeyInfo wrappedKeyInfo = this.getWrappedKeyInfo();
        if (wrappedKeyInfo != null && (id = this.keyInfoConf.getWsuId()) != null) {
            wrappedKeyInfo.setId(id);
        }
        if (this.keyInfoConf == null) return;
        InternalWSSecurityContext context = this.getSecurityContext();
        if (this.keyInfoConf.getSecurityTokenId() == null) {
            cat.error("SecurityTokenId in the KeyInfo is not set");
            throw WSSecurityException.INVALID_SECURITY;
        }
        if (this.keyInfoConf.getSecurityTokenMode() == null || "keyidentifier".equals(this.keyInfoConf.getSecurityTokenMode()) || "reference".equals(this.keyInfoConf.getSecurityTokenMode())) {
            WSSecurityObject o = context.resolveSecurityObjectById(this.keyInfoConf.getSecurityTokenId());
            if (o == null || !(o instanceof SecurityTokenObject)) {
                cat.error("Reference security token is not security token or is not defined: id=" + this.keyInfoConf.getSecurityTokenId());
                throw WSSecurityException.INVALID_SECURITY;
            }
            this.securityToken = ((SecurityTokenObject)o).getSecurityToken();
            if (this.keyInfoConf.getSecurityTokenMode() == null || "reference".equals(this.keyInfoConf.getSecurityTokenMode())) {
                String wssePrefix = ElementProxy.getDefaultPrefix(this.getSecurityContext().getWsseNamespace());
                Element STR = this.createSTRElement(context);
                Element keyReference = context.getMessageDocument().createElementNS(this.getSecurityContext().getWsseNamespace(), WSSecurityImpl.getWssePrefix() + ":" + "Reference");
                keyReference.setAttributeNS(null, "URI", "#" + this.keyInfoConf.getSecurityTokenId());
                STR.appendChild(keyReference);
                wrappedKeyInfo.addUnknownElement(STR);
                WSSecurityHelper.addNamespacePrefix(this.getSecurityContext().getWsseNamespace(), wssePrefix, STR);
                return;
            }
            String wssePrefix = ElementProxy.getDefaultPrefix(this.getSecurityContext().getWsseNamespace());
            String encodingType = null;
            String wsseNamespace = context.getWsseNamespace();
            encodingType = !WSSecurity.RC_SECURITY_URI_LIST.contains(wsseNamespace) ? wssePrefix + ":" + "Base64Binary" : WSSecurityHelper.fromNs2SpecLocation(wsseNamespace) + "#" + "Base64Binary";
            Element STR = this.createSTRElement(context);
            byte[] tokenId = this.securityToken.getKeyIdentifier();
            if (tokenId == null) {
                cat.error("KeyIdentifier reference in KeyInfo/SecurityTokenReference used on token, that does not support KeyIdentifier");
                throw WSSecurityException.INVALID_SECURITY;
            }
            Element keyId = context.getMessageDocument().createElementNS(this.getSecurityContext().getWsseNamespace(), WSSecurityImpl.getWssePrefix() + ":" + "KeyIdentifier");
            keyId.setAttributeNS(null, "ValueType", this.securityToken.getKeyIdentifierValueType());
            keyId.setAttributeNS(null, "EncodingType", encodingType);
            keyId.appendChild(context.getMessageDocument().createTextNode(Base64.encode(tokenId)));
            STR.appendChild(keyId);
            wrappedKeyInfo.addUnknownElement(STR);
            WSSecurityHelper.addNamespacePrefix(this.getSecurityContext().getWsseNamespace(), wssePrefix, STR);
            return;
        }
        if (!"keyname".equals(this.keyInfoConf.getSecurityTokenMode())) {
            cat.error("unknown security token mode in keyinfo: " + this.keyInfoConf.getSecurityTokenMode());
            throw WSSecurityException.INVALID_SECURITY;
        }
        this.getWrappedKeyInfo().add(new KeyName(this.getSecurityContext().getMessageDocument(), this.keyInfoConf.getSecurityTokenId()));
        WSSecurityObject o = context.resolveSecurityObjectById(this.keyInfoConf.getSecurityTokenId());
        if (o != null && o instanceof SecurityTokenObject) {
            this.securityToken = ((SecurityTokenObject)o).getSecurityToken();
            return;
        }
        cat.error("reference security token is not security token or is not defined: id=" + this.keyInfoConf.getSecurityTokenId());
        throw WSSecurityException.INVALID_SECURITY;
    }

    private Element createSTRElement(InternalWSSecurityContext context) {
        Element STR = context.getMessageDocument().createElementNS(this.getSecurityContext().getWsseNamespace(), WSSecurityImpl.getWssePrefix() + ":" + "SecurityTokenReference");
        String strWsuId = this.keyInfoConf.getStrWsuId();
        if (strWsuId != null) {
            String wsuNamespace = this.getSecurityContext().getWsuNamespace();
            STR.setAttributeNS(wsuNamespace, ElementProxy.getDefaultPrefix(wsuNamespace) + ":" + "Id", strWsuId);
        }
        return STR;
    }

    private void doFinalReceive() throws WSSecurityException {
        KeyInfo wrappedKeyInfo = this.getWrappedKeyInfo();
        if (wrappedKeyInfo == null) {
            return;
        }
        Node child = wrappedKeyInfo.getElement().getFirstChild();
        while (child != null && this.securityToken == null) {
            if (child.getNodeType() == 1) {
                this.securityToken = WSKeyResolver.resolverSecurityToken((Element)child, this.getSecurityContext());
                if (this.securityToken != null) {
                    this.referencedWsuId = this.securityToken.getWsuId();
                }
            }
            child = child.getNextSibling();
        }
        Element keyInfoElement = wrappedKeyInfo.getElement();
        this.wsuId = keyInfoElement.getAttributeNS(this.getSecurityContext().getWsuNamespace(), "Id");
        NodeList nodeList = null;
        nodeList = keyInfoElement.getElementsByTagNameNS(this.getSecurityContext().getWsseNamespace(), "SecurityTokenReference");
        if (nodeList.getLength() > 0) {
            Element strElement = (Element)nodeList.item(0);
            this.strWsuId = strElement.getAttributeNS(this.getSecurityContext().getWsuNamespace(), "Id");
            if (strElement.getElementsByTagNameNS(this.getSecurityContext().getWsseNamespace(), "Reference").getLength() > 0) {
                this.mode = "reference";
            } else if (strElement.getElementsByTagNameNS(this.getSecurityContext().getWsseNamespace(), "KeyIdentifier").getLength() > 0) {
                this.mode = "keyidentifier";
            }
        } else {
            nodeList = keyInfoElement.getElementsByTagNameNS(this.getSecurityContext().getWsseNamespace(), "KeyName");
            if (nodeList.getLength() > 0) {
                this.mode = "keyname";
            }
        }
        if (this.securityToken != null) {
            cat.debug("security token object found");
        } else {
            cat.debug("security token object not found");
        }
    }

    public Key getEncryptingKey() throws WSSecurityException {
        if (this.securityToken != null) {
            return this.securityToken.getEncryptingKey();
        }
        KeyInfo ki = this.getKeyInfo();
        if (ki == null) {
            return null;
        }
        try {
            PublicKey key = ki.getPublicKey();
            if (key != null) {
                return key;
            }
            return ki.getSecretKey();
        }
        catch (KeyResolverException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
    }

    public Key getDecryptingKey() throws WSSecurityException {
        if (this.securityToken != null) {
            return this.securityToken.getDecryptingKey();
        }
        KeyInfo ki = this.getKeyInfo();
        if (ki == null) {
            return null;
        }
        try {
            return ki.getSecretKey();
        }
        catch (KeyResolverException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
    }

    public Key getSigningKey() throws WSSecurityException {
        if (this.securityToken != null) {
            return this.securityToken.getSigningKey();
        }
        KeyInfo ki = this.getKeyInfo();
        if (ki == null) {
            return null;
        }
        try {
            return ki.getSecretKey();
        }
        catch (KeyResolverException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
    }

    public Key getAuthenticatingKey() throws WSSecurityException {
        if (this.securityToken != null) {
            return this.securityToken.getAuthenticatingKey();
        }
        KeyInfo ki = this.getKeyInfo();
        if (ki == null) {
            return null;
        }
        try {
            PublicKey key = ki.getPublicKey();
            if (key != null) {
                return key;
            }
            return ki.getSecretKey();
        }
        catch (KeyResolverException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
    }

    protected KeyInfo getKeyInfo() throws WSSecurityException {
        if (this.getWrappedKeyInfo() == null) {
            WSKeyInfo defKI = this.getSecurityContext().getDefaultWSKeyInfo();
            if (defKI == null) {
                return null;
            }
            return defKI.getWrappedKeyInfo();
        }
        return this.getWrappedKeyInfo();
    }

    private void setWrappedKeyInfo(KeyInfo apacheKeyInfo) throws WSSecurityException {
        this.apacheKeyInfo = apacheKeyInfo;
    }

    public KeyInfo getWrappedKeyInfo() {
        return this.apacheKeyInfo;
    }

    private InternalWSSecurityContext getSecurityContext() {
        return this.parent.getSecurityContext();
    }

    public boolean setupKeyInfoConf(KeyInfoConf keyInfoConf) {
        if (this.getWrappedKeyInfo() == null) {
            return false;
        }
        keyInfoConf.setSecurityTokenMode(this.mode);
        keyInfoConf.setSecurityTokenId(this.referencedWsuId);
        if (this.strWsuId != null) {
            keyInfoConf.setStrWsuId(this.strWsuId);
        }
        return true;
    }

    public SecurityTokenSPI getSecurityTokenSPI() {
        return this.securityToken;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

