/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.idoox.security.util.Base64;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.ws.UserNameToken;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import org.idoox.security.jaas.NamePasswordCredential;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.SecurityTokenHandlerSPI;
import org.systinet.wasp.security.ws.SecurityTokenSPI;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.PropertyConf;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;
import org.systinet.wasp.security.ws.conf.WSSEConf;
import org.w3c.dom.Element;

public class UsernameTokenHandler
extends SecurityTokenHandlerSPI {
    private static final Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.impl.UsernameTokenHandler");
    private static final long DEFAULT_EXPIRATION_LIMIT = 300000L;
    static /* synthetic */ Class class$org$idoox$security$jaas$NamePasswordCredential;

    public SecurityTokenSPI createFromXML(Element constructionElement, SecurityContext securityContext) throws WSSecurityException {
        UserNameToken securityToken = null;
        try {
            Boolean ignore;
            securityToken = new UserNameToken(constructionElement, securityContext);
            byte[] nonce = securityToken.getNonce();
            Date created = securityToken.getCreated();
            boolean noUNTvalidation = false;
            WSSEConf globalConf = WSSecurityHelper.getSecurityConfiguration();
            if (globalConf != null && (ignore = globalConf.getNoUsernameTokenValidation()) != null) {
                noUNTvalidation = ignore;
            }
            if (!noUNTvalidation && !UserNameToken.validate(nonce, created, true, this.getExpirationLimit())) {
                log.error("I'm afraid of UsernameToken without created or nonce values");
                throw WSSecurityException.INVALID_SECURITY_TOKEN;
            }
        }
        catch (XMLSecurityException e) {
            log.error("Unable to verify UsernameToken : " + e.getMessage(), (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY_TOKEN;
        }
        return securityToken;
    }

    private long getExpirationLimit() {
        WSSEConf wsseConf = WSSecurityHelper.getSecurityConfiguration();
        Integer tmpInteger = wsseConf.getTokenExpiration();
        if (tmpInteger == null) {
            return 300000L;
        }
        return tmpInteger.intValue();
    }

    public String getLocalValueType() {
        return "Username";
    }

    public SecurityTokenSPI createFromConf(SecurityTokenConf tokenConf, SecurityContext securityContext, boolean isExternal) {
        UserNameToken usernameToken = new UserNameToken(securityContext, isExternal);
        String passwordType = WSSecurityHelper.getPropertyValue(tokenConf.getProperties(), "PasswordType");
        int pt = -1;
        if ("PasswordDigest".equals(passwordType)) {
            pt = 1;
        }
        if ("PasswordText".equals(passwordType)) {
            pt = 0;
        }
        NamePasswordCredential namePasswordCredential = UsernameTokenHandler.getNamePasswordCredential(tokenConf);
        usernameToken.setUsername(namePasswordCredential.getName());
        Date created = null;
        byte[] nonce = null;
        if (tokenConf.getWsuId() != null) {
            usernameToken.setWsuId(tokenConf.getWsuId());
        }
        boolean noNonceCreated = false;
        String tmpStr = WSSecurityHelper.getPropertyValue(tokenConf.getProperties(), "noNonceAndCreated");
        if ("true".equalsIgnoreCase(tmpStr) || "yes".equalsIgnoreCase(tmpStr)) {
            noNonceCreated = true;
        }
        usernameToken.setPassword(namePasswordCredential.getPassword(), pt);
        if (!noNonceCreated) {
            String nonceStr;
            String createdStr = WSSecurityHelper.getPropertyValue(tokenConf.getProperties(), "created");
            if (createdStr != null) {
                try {
                    created = WSSecurityHelper.parseDate(createdStr);
                }
                catch (ParseException e) {
                    log.error("", (Throwable)e);
                    throw new WSSecurityException(null, e.getMessage());
                }
            } else {
                created = WSSecurityImpl.getUtcCalendar().getCurrentTime();
            }
            if ((nonceStr = WSSecurityHelper.getPropertyValue(tokenConf.getProperties(), "nonceBase64")) != null) {
                try {
                    nonce = Base64.decode((byte[])nonceStr.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("", (Throwable)e);
                    throw new WSSecurityException(null, e.getMessage());
                }
            } else {
                nonce = WSSecurityHelper.getRandomBytes(16);
            }
            usernameToken.setNonce(nonce);
            usernameToken.setCreated(created);
        }
        usernameToken.finalizeCreation();
        if (!noNonceCreated && !UserNameToken.validate(nonce, created, false, this.getExpirationLimit())) {
            log.error("Nonce already used or timestamp expiration");
            throw WSSecurityException.INVALID_SECURITY_TOKEN;
        }
        return usernameToken;
    }

    public String getLocalElementName() {
        return "UsernameToken";
    }

    protected static NamePasswordCredential getNamePasswordCredential(SecurityTokenConf stConf) {
        if (stConf == null) {
            return null;
        }
        String username = null;
        String password = null;
        if (stConf != null) {
            PropertyConf[] propertyConfs = stConf.getProperties();
            username = WSSecurityHelper.getPropertyValue(propertyConfs, "alias");
            password = WSSecurityHelper.getPropertyValue(propertyConfs, "password");
        }
        if (username != null) {
            return WSSecurityHelper.createNamePasswordCredential(username, password);
        }
        NamePasswordCredential[] npCreds = (NamePasswordCredential[])WSSecurityHelper.getCurrentCredentials(class$org$idoox$security$jaas$NamePasswordCredential == null ? (class$org$idoox$security$jaas$NamePasswordCredential = UsernameTokenHandler.class$("org.idoox.security.jaas.NamePasswordCredential")) : class$org$idoox$security$jaas$NamePasswordCredential);
        if (npCreds.length > 0) {
            return npCreds[0];
        }
        log.error("Cannot get UserNamePasswordCredentail for UserName token; wsuId=" + stConf.getWsuId());
        throw WSSecurityException.INVALID_SECURITY_TOKEN;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

