/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.algorithms.encryption.EncryptionMethod;
import com.systinet.wasp.security.secext.algorithms.encryption.params.OAEPParams;
import com.systinet.wasp.security.secext.encryption.EncryptedType;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.ws.impl.EncryptedKeyObject;
import com.systinet.wasp.security.ws.impl.WSSecurityObject;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.OrderedElementConf;
import org.w3c.dom.Element;

public abstract class EncryptedTypeObject
extends WSSecurityObject {
    private static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$ws$impl$EncryptedTypeObject == null ? (class$com$systinet$wasp$security$ws$impl$EncryptedTypeObject = EncryptedTypeObject.class$("com.systinet.wasp.security.ws.impl.EncryptedTypeObject")) : class$com$systinet$wasp$security$ws$impl$EncryptedTypeObject).getName());
    private EncryptedType encryptedTypeHolder;
    private EncryptedKeyObject encryptingKey;
    public static final int TYPE_ENCRYPTEDKEY = 1;
    public static final int TYPE_ENCRYPTEDDATACONTENT = 2;
    public static final int TYPE_ENCRYPTEDDATAELEMENT = 4;
    static /* synthetic */ Class class$com$systinet$wasp$security$ws$impl$EncryptedTypeObject;

    protected EncryptedTypeObject(SecurityContext securityContext, Element element) throws WSSecurityException {
        super(securityContext, element);
    }

    protected EncryptedTypeObject(SecurityContext securityContext, OrderedElementConf conf) throws WSSecurityException {
        super(securityContext, conf);
    }

    protected void setEncryptedTypeHolder(EncryptedType encryptedTypeHolder) throws WSSecurityException {
        if (this.encryptedTypeHolder != null) {
            cat.error("encryptedType holder is already set");
            throw WSSecurityException.INVALID_SECURITY;
        }
        this.encryptedTypeHolder = encryptedTypeHolder;
    }

    protected EncryptedType getEncryptedTypeHolder() throws WSSecurityException {
        if (this.encryptedTypeHolder == null) {
            cat.error("encryptedType holder is not set");
            throw WSSecurityException.INVALID_SECURITY;
        }
        return this.encryptedTypeHolder;
    }

    protected EncryptionMethod getEncryptionMethod() throws WSSecurityException {
        try {
            com.systinet.wasp.security.secext.encryption.EncryptionMethod em = this.encryptedTypeHolder.getEncryptionMethod();
            OAEPParams emp = null;
            if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(em.getAlgorithm())) {
                byte[] params = em.getOAEPparams();
                if (params != null) {
                    params = Base64.decode(params);
                }
                emp = new OAEPParams(em.getOAEPDigestAlgorithm(), params);
            }
            return new EncryptionMethod(this.getSecurityContext().getMessageDocument(), em.getAlgorithm(), emp);
        }
        catch (XMLSecurityException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
    }

    protected void setEncryptingKey(EncryptedKeyObject encryptingKey) throws WSSecurityException {
        if (this.encryptingKey != null && this.encryptingKey != encryptingKey) {
            cat.error("encryptingKey is already set");
            throw WSSecurityException.INVALID_SECURITY;
        }
        this.encryptingKey = encryptingKey;
    }

    protected EncryptedKeyObject getEncryptingKey() throws WSSecurityException {
        return this.encryptingKey;
    }

    public String getWsuId() {
        return this.encryptedTypeHolder.getId();
    }

    protected int getType() throws WSSecurityException {
        String type = this.encryptedTypeHolder.getType();
        if (type != null) {
            if (type.endsWith("#EncryptedKey")) {
                return 1;
            }
            if (type.endsWith("#Content")) {
                return 2;
            }
            if (type.endsWith("#Element")) {
                return 4;
            }
        }
        return 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

